package ph;

import ph.intelligence.*;
import ph.movement.*;
import ph.targeting.*;
import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.io.*;
import java.util.*;

public class Thinker extends ModularRobot {
    
    public void run() {
        super.run();
        setColors(Color.blue, Color.blue.brighter(), Color.white.brighter());
        addModule(new RadarModule(this));
        addModule(new RandomMovementModule(this));
        addModule(new TargetingModule_NN_new(this));
        addCustomEvent(new RadarTurnCompleteCondition(this));
        addCustomEvent(new MoveCompleteCondition(this));
        addCustomEvent(new TurnCompleteCondition(this));
        while (true) {
            executeAllModules();
            execute();
        }
    }
    
    public void onCustomEvent(CustomEvent evt) {
        if(evt.getCondition() instanceof RadarTurnCompleteCondition) {
            executeModuleAt(0);
        } else if(evt.getCondition() instanceof MoveCompleteCondition) {
            executeModuleAt(1);
        } else if(evt.getCondition() instanceof TurnCompleteCondition) {
            setMaxVelocity(8);
        }
    }
    
}
