package tm;

/********************************************************************
* BulletPower1on1SB4b.java -- Cep[vZ
*
* Date:		2002/Dec/29
* Author:	Matunaga Takateru
*
*******************************************************************/
public class BulletPower1on1SB4b implements BulletPower {
	int count = 0;
	double myEne, eneEne;		//GlM[
	double distance;			//CGԋ

	//---------------------------------------------------------
	// getBulletPower()
	//
	//
	//---------------------------------------------------------
	public double getBulletPower(double myEne, double eneEne, double distance, double hitRate) {
		this.myEne = myEne;
		this.eneEne = eneEne;
		this.distance = distance;

		double distancePow, myEnePow, eneEnePow;

		if (myEne <= 0.2) return 0;
		
		if (myEne <= 1.8) {
			if (count > 15) {
				count = 0;
				return 0.1;
			} else {
				count++;
				return 0.0;
			}
		}
		
		// p[
		if (distance < 200) distancePow = 3;
		else distancePow = 3.8 - (distance / 250);
		
		if (distancePow >= 3 && myEne > 5 && distance < 140) return 3;
		
		eneEnePow = calcPowerForEneEnergy();
	
		
		if (myEne > 16 && eneEne < 16) return eneEnePow;
		if (eneEne < 16 && myEne > eneEne * 3) return eneEnePow;
		
		double bp = Math.min(distancePow, eneEnePow);
		
		
		if (bp < 0.1) bp = 0.1;
		
		return bp;
	}

	
	//---------------------------------------------------------
	// calcPowerForEneEnergy() -- GGlM[ɉăp[vZ
	//
	//
	//---------------------------------------------------------
	double calcPowerForEneEnergy() {
		//ŏ
		if (eneEne <= 4) {
			return eneEne / 4 + 0.1;
		} else if (eneEne <= 15.4) {
			return (eneEne + 2) / 6 + 0.1;
		} else {
			return 3.0;
		}
	}
}