package tm;
import robocode.*;
import java.util.*;

/********************************************************************
* Gun1on1_102Ci.java -- for 1 on 1
*                     ASY102
*                     G}b`O
*                     }b`O
*                     last 7 time, 500time, ⊮
*
* Date:		2002/Nov/17
*			2002/Dec/08
*			2002/Dec/31
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*
********************************************************************/
class Gun1on1_102Ci implements Gun1on1 {
	MyRobot my;
	FieldMap map;
	static EnemyHistory3B ehis;
	EnemyMoveAnalyzer3C analyzer;
	double lastEnemyEnergy = 100;
	double lastBulletPower = 1;
	double fW, fH;
	Random rand = new Random(System.currentTimeMillis());
	BulletPower bp = new BulletPower1on1SB6b();

	//------------------------------------------------------------------
	// constructor
	//
	//
	//------------------------------------------------------------------
	public Gun1on1_102Ci(MyRobot my) {
		this.my = my;
		this.map = my.map;
		this.ehis = my.ehis3B;
		this.analyzer = new EnemyMoveAnalyzer3C(ehis, my);
		this.fW = my.fW;
		this.fH = my.fH;
	}
	
	//------------------------------------------------------------------
	// put()
	//
	//
	//------------------------------------------------------------------
	public void put(double x, double y, double distance, double velocity, double heading, double bearing, long t) {
		ehis.put(x, y, distance, velocity, heading, bearing, t);
	}

	public void put(double x, double y, double distance, double velocity, double heading, double bearing, long t, String name) {
		ehis.put(x, y, distance, velocity, heading, bearing, t);
	}
		
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void fire() {
		Enemy ene = map.getNearestEnemy(my.getTime());		
		if (ene == null) return;		
		
		double dx, dy;						//GWƂ̍
		double bulletPower;
		double angle;
		double distance;					//GƂ̋

		//fire łȂCGʒuGun]̂
		if (my.getGunHeat() > 0.2) {
			double absBearing = ene.getBearing() + my.getHeading();
			angle = M.angleUnder180(absBearing - my.getGunHeading());
			my.setTurnGunRight(angle);
			return;		
		} 


		dx = ene.getX() - my.getX();
		dy = ene.getY() - my.getY();
		distance = Math.sqrt(dx*dx + dy*dy);
		
		//bulletPowervZ
		double totalHitRate = (double)(my.result.totalHitAnyCount + 0.5) / (my.result.totalFireCount + 1);
		double currHitRate = (double)(my.result.hitAnyCount + 0.5) / (my.result.fireCount + 1);

		double hitRate = (currHitRate + totalHitRate) / 2;
		bulletPower = bp.getBulletPower(my.getEnergy(), ene.getEnergy(), distance, hitRate);


		if (bulletPower <= 0) return;
		if (bulletPower < 0.1) bulletPower = 0.1;
		
		//Cg̉]p̎Zo
		angle = getTurnAngle(my, ene, bulletPower);

		my.setTurnGunRight(angle);
		
		if (my.getGunHeat() != 0) return;
				
		//px傫ƂfireȂ
		//fire\Ȋpx(CgƓG)
		double canFireAngle =  Math.toDegrees(Math.atan2(my.robotSize / 2, ene.getDistance()));
		if (Math.abs(angle) >= canFireAngle) return;
		
		Bullet bullet = my.setFireBullet(bulletPower);
		if (bullet == null) return;
		long timeToImpact = (long)(distance / bullet.getVelocity() + 0.5);		//B
		timeToImpact += (long)(timeToImpact * 8.0 / bullet.getVelocity() + 0.5);	//ɓGړl
		BulletTracker bt = new BulletTracker(my, bullet, ene, timeToImpact, 0);

		my.result.fire();
		my.selecter.fire(bulletPower);
	}
	
	
	//------------------------------------------------------------------
	// getTurnAngle() -- Cg̉]p̎Zo
	//
	//
	// F	my -- 
	//			ene -- G
	// ߂lF	-180 < theta <= 180
	//------------------------------------------------------------------
	double getTurnAngle(MyRobot my, Enemy ene, double bulletPower) {
		double epX = 0, epY = 0;			//enemy predicteed X, Y
		double bulletVelocity = 20 - 3 * bulletPower;
		double bulletTime = ene.getDistance() / bulletVelocity;		//eۓB
		double eneGoHeading;			//Gis
		
		//GisZo
		if (ene.getVelocity() >= 0) {
			eneGoHeading = ene.getHeading();
		} else {
			eneGoHeading = (180 + ene.getHeading()) % 360;
		}
		
		Point po;
		
		
		if (ene.getDistance() < 90) {
			//GʒuGun]
			double absBearing = ene.getBearing() + my.getHeading();
			return M.angleUnder180(absBearing - my.getGunHeading());
		} else if (ene.getDistance() < 140) {
			return gun3(my, ene, bulletPower);
		} else {
			po = analyzer.getPredictedEnemyPoint3((int)bulletTime, ene.getHeading(), my.getTime(), bulletVelocity, ene.getX(), ene.getY(), my.getX(), my.getY());
		}
		
		if (po == null) return gun7(my, ene, bulletPower);

		epX = ene.getX() + po.x;
		epY = ene.getY() + po.y;
		
		double angle = M.point2degree(my.getX(), my.getY(), epX, epY);
		angle = 90 - angle;								//G̐ΕC̍W
		angle = angle - my.getGunHeading();				//GCCg̊px
		angle = M.angleUnder180(angle);
		
		return angle;
	}
	
	//------------------------------------------------------------------
	// gun3()
	//
	// F	my -- 
	//			ene -- G
	// ߂lF	-180 < theta <= 180
	//------------------------------------------------------------------
	double gun3(Robot my, Enemy ene, double bulletPower) {
		double moveAngleRad = Math.toRadians(90 - ene.getHeading());		//G̈ړ
		double dtime = my.getTime() - ene.getMtime();		//ԍ
		double eX, eY;			//\zGW
		double myX, myY;
		double angle;
		
		eX = ene.getX() + Math.cos(moveAngleRad) * ene.getVelocity() * dtime;
		eY = ene.getY() + Math.sin(moveAngleRad) * ene.getVelocity() * dtime;

		if (eX < 20)           eX = 20;
		else if (eX > fW - 20) eX = fW - 20;
		if (eY < 20)           eY = 20;
		else if (eY > fH - 20) eY = fH - 20;

		myX = my.getX();
		myY = my.getY();
		
		//ɒeۓBԂZ
		double bulletVelocity = 20 - 3 * bulletPower;
		double bulletTime = ene.getDistance() / bulletVelocity;		//eۓB
		
		//eۓBԂQIɎZo
		double diffTime = 9999999;
		int i = 0;
		//15܂͎ԍ0.01timeȉ܂ŎZo
		while (i < 15 && diffTime > 0.01) {
			//GW
			double tmpEX = eX + Math.cos(moveAngleRad) * ene.getVelocity() * bulletTime;
			double tmpEY = eY + Math.sin(moveAngleRad) * ene.getVelocity() * bulletTime;

			if (tmpEX < 20)           tmpEX = 20;
			else if (tmpEX > fW - 20) tmpEX = fW - 20;
			if (tmpEY < 20)           tmpEY = 20;
			else if (tmpEY > fH - 20) tmpEY = fH - 20;

			double dx = my.getX() - tmpEX;
			double dy = my.getY() - tmpEY;
			double distance = Math.abs(Math.sqrt(dx*dx+dy*dy) - 20);	//{bg傫l
			double newBulletTime = distance / bulletVelocity;
			diffTime = Math.abs(newBulletTime - bulletTime);
			bulletTime = newBulletTime;
			i++;
		}
		
		eX += Math.cos(moveAngleRad) * ene.getVelocity() * bulletTime;
		eY += Math.sin(moveAngleRad) * ene.getVelocity() * bulletTime;

		if (eX < 0) eX = 20;
		else if (eX > my.getBattleFieldWidth()) eX = my.getBattleFieldWidth() - 20;
		if (eY < 0) eY = 20;
		else if (eY > my.getBattleFieldHeight()) eY = my.getBattleFieldHeight() - 20;
	
		angle = M.point2degree(my.getX(), my.getY(), eX, eY);
		angle = 90 - angle;						//G̐ΕC̍W
		angle = angle - my.getGunHeading();		//GCCg̊px
		angle = M.angleUnder180(angle);
		
		return angle;
	}
	
	//------------------------------------------------------------------
	// gun7() -- Gɑ΂}20]
	//
	// F	my -- 
	//			ene -- G
	// ߂lF	-180 < theta <= 180
	//------------------------------------------------------------------
	double gun7(MyRobot my, Enemy ene, double bulletPower) {
		double bearing, distance, absoluteBearing;
		double gunAngle;
		
		bearing = ene.getBearing();
		distance = ene.getDistance();
		absoluteBearing = M.angleUnder180(bearing + my.getHeading());		
		
		gunAngle = absoluteBearing - my.getGunHeading();		//G
		gunAngle += rand.nextInt(40) - 20;
		gunAngle = M.angleUnder180(gunAngle);
		
		return gunAngle;
	}
	
	//---------------------------------------
	// bulletTrackComplete() -- CeǐՊ
	//
	//--------------------------------------
	public void bulletTrackComplete(BulletTracker bt) {
		if (bt.hitTarget()) {
			//
			my.result.hit();
		}
	}
	
	//--------------------------------------
	// bulletHit()
	//
	//--------------------------------------
	public void bulletHit(BulletHitEvent e) {
		my.result.hitAnyone();
		my.selecter.hit(e.getBullet().getPower());
	}
}