package djdjdj;
import robocode.*;
import java.awt.geom.*;
import java.text.*;
import java.io.*;
import java.util.TreeMap;
import java.util.Iterator;
import com.braju.format.*;
import robocode.util.Utils;

/*
 * A tiny stinker.  Goes in a circle, doing linear targeting to
 * destroy all enemies.
 *
 * 166 points/round vs FunkyChicken, Freddie, Lib. (1000 rounds)
 * codesize 247.
 */

public class NanoSkunk10
    extends AdvancedRobot
{
    double threshDist = Double.POSITIVE_INFINITY;

    public void run()
    {
	setAdjustGunForRobotTurn(true);
	setTurnRadarRight(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e)
    {
	double eDist = e.getDistance();
	if (eDist < threshDist) {

	    // this linear targeting is adapted from
	    // WaveSurfingChallengeBotB. it used to take up a lot more
	    // codespace! we cut out codespace by ignoring the
	    // walls. once you do that, then you can rewrite it to be
	    // relative to us instead of in absolute coordinates.
	    double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
	    double enemyX = eDist * Math.sin(absoluteBearing);
	    double enemyY = eDist * Math.cos(absoluteBearing);
	    int dist = 0;
	    while((dist += 17) < Point2D.Double.distance(0, 0, enemyX, enemyY)) {
		enemyX += Math.sin(e.getHeadingRadians()) * e.getVelocity();
		enemyY += Math.cos(e.getHeadingRadians()) * e.getVelocity();
	    }
	    double angleToTurnGun;
	    setTurnGunRightRadians(angleToTurnGun =
				   Utils.normalRelativeAngle(Utils.normalAbsoluteAngle(Math.atan2(enemyX, enemyY)) -
							     getGunHeadingRadians()));

	    if (Math.abs(angleToTurnGun) < 0.10) {
		setFireBullet(eDist > 140 ? 1.0 : 3.0);
	    }

	    // the further the enemy is, the more often we let the
	    // radar slip in search of a closer enemy
	    if (getTime() % ((1092 / eDist) + 3) > 0) {
		setTurnRadarLeft(getRadarTurnRemaining());
	    }
	    threshDist = eDist;
	}
	threshDist = threshDist * 1.35;

	// like good old CrowdGrunt, we go in a circle.  Circle is
	// good because simple linear targeting won't hit it.
	//
	// 14-byte movement. hits walls but cant think of a <20-byte
	// fix.
	setAhead(Double.POSITIVE_INFINITY);
	setTurnRightRadians(Double.POSITIVE_INFINITY);
    }
}
