package csp;
import robocode.*;
import java.awt.Color;
import java.lang.Math;
import java.util.ArrayList;

/**
 * Eagle - a robot by Corey Proscia
 */
public class Eagle extends AdvancedRobot
{
	private double bulletPower = 1;
	
	boolean hasHitWall = false;
	boolean isTurning = false;
	double turningFrom = 0;
	
	//double chanceToHit = .6;
	
	ScannedRobot target;
	int targetIndex = -1;
	ArrayList scannedRobots = new ArrayList();
	
	/**
	 * run: Eagle's default behavior
	 */
	public void run() {
		
		setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        setTurnRadarRight(Double.POSITIVE_INFINITY);
        
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		setColors(Color.green,Color.white,Color.yellow);
		while(true)
		{	
			setTarget();
			
			if(isTurning || (distanceToWall() <= 40 && distanceToWall() > -1))
			{
				if(!isTurning)
				{
					isTurning = true;
					turningFrom = getHeading();
					setTurnLeft(90);
				}
				
				setMaxVelocity(2); 
				setAhead(200);
				
				if(getTurnRemaining() == 0)
				{
					isTurning = false;	
				}
			}
			else
			{
				setMaxVelocity(8);
				setAhead(200);
			}
				
			execute();
			
			myFire();	
		}			
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {

		boolean robotFound = false;
		
		// update robot's info
		for(int i = 0; i < scannedRobots.size(); i++)
		{
			ScannedRobot enemy = (ScannedRobot)scannedRobots.get(i);
			
			if(enemy.getName() == e.getName())
			{
				robotFound = true;
				
				enemy.setEnergy(e.getEnergy());
				enemy.setBearing(e.getBearingRadians());
				enemy.setDistance(e.getDistance());
				enemy.setHeading(e.getHeadingRadians());
				enemy.setVelocity(e.getVelocity());
				
				double bearing = (getHeadingRadians() + e.getBearingRadians()) % (2 * Math.PI);
				
				double enemyX = getX() + e.getDistance() * Math.sin(bearing);
				double enemyY = getY() + e.getDistance() * Math.cos(bearing);
				
				enemy.setX(enemyX);
				enemy.setY(enemyY);
				
				enemy.setTimeScanned(getTime());
			}
		}
		
		// add robot to list
		if(!robotFound)
		{		
			ScannedRobot enemy = new ScannedRobot(
					e.getName(),
					e.getEnergy(),
					e.getBearingRadians(),
					e.getDistance(),
					e.getHeadingRadians(),
					e.getVelocity());
			
			double bearing = (getHeadingRadians() + e.getBearingRadians()) % (2 * Math.PI);
			
			double enemyX = getX() + e.getDistance() * Math.sin(bearing);
			double enemyY = getY() + e.getDistance() * Math.cos(bearing);
			
			enemy.setX(enemyX);
			enemy.setY(enemyY);
			
			enemy.setTimeScanned(getTime());
			
			scannedRobots.add(enemy);
			
			out.println("Adding enemy robot:" + e.getName());
			
			if(target == null)
			{
				target = (ScannedRobot)scannedRobots.get(0);
				out.println("Setting target to " + target.getName());
			}
		}
	}
	
	private void setTarget() {
		
		boolean isChanging = false;
		boolean hasChanged = false;
		
		if(target != null)
		{
			
			for(int i = 0; i < scannedRobots.size(); i++)
			{
				isChanging = false;
				
				ScannedRobot enemy = (ScannedRobot)scannedRobots.get(i);
				
				if(enemy.getName() != target.getName())
				{
					if(enemy.getDistance() < 150 && enemy.isAlive() && target.getDistance() > 150)
					{
						
						isChanging = true;
					}
					else if(enemy.getDistance() < 200 && enemy.isAlive() && target.getDistance() > 200)
					{
						
						isChanging = true;
					}
					else if(enemy.getVelocity() < 1 && enemy.isAlive() && target.getDistance() > 200 && target.getVelocity() > 1)
					{
						
						isChanging = true;
					}
					else if(enemy.getDistance() < 350 && enemy.isAlive() && target.getDistance() > 350 && target.getVelocity() > 1)
					{
						
						isChanging = true;
					}
					else if(enemy.getChanceToHit() > target.getChanceToHit() && target.getDistance() > 350 && enemy.isAlive() && target.getVelocity() > 1)
					{
						
						isChanging = true;
					}
					else if(!target.isAlive() && enemy.isAlive())
					{
						
						isChanging = true;
					}
					
					if(isChanging)
					{
						/*out.print("Changing target to: " + enemy.getName() + " (" + (int) enemy.getDistance() + ")");
						if(enemy.getDistance() < 150 && enemy.isAlive() && target.getDistance() > 150)
							out.print(" (1)");
						else if(enemy.getDistance() < 200 && enemy.isAlive() && target.getDistance() > 200)
							out.print(" (2)");
						else if(enemy.getVelocity() < 1 && enemy.isAlive() && target.getDistance() > 200 && target.getVelocity() > 1)
							out.print(" (3)");
						else if(enemy.getDistance() < 350 && enemy.isAlive() && target.getDistance() > 350 && target.getVelocity() > 1)
							out.print(" (4)");
						else if(enemy.getChanceToHit() > target.getChanceToHit() && target.getDistance() > 350 && enemy.isAlive() && target.getVelocity() > 1)
							out.print(" (5)");
						else if(!target.isAlive() && enemy.isAlive())
							out.print(" (6)");
						out.println();*/
						
						target = enemy;
						
						hasChanged = true;
					}
				}
			}
			
			/*if(hasChanged)
				out.println("Overall Change To: " + target.getName());*/
		}
	}
	
	private void myFire() {
		
		setBulletPower();
		
		if(target != null)
		{
			double distance = target.getDistance();
			long time = getTime() + (int)(target.getDistance()/(20-(3*bulletPower)));
			
			for(int i = 0; i < 10; i++)
			{
				distance = getDistance(getX(), getY(), target.getX(time), target.getY(time));
				time = getTime() + (int)(distance /(20-(3*bulletPower)));
			}
				
			
			//setTurnGunRightRadians(normalizeBearingRadians(getHeadingRadians() - getGunHeadingRadians() + target.getBearing()));
			
			double gunOffset = absbearing(getX(),getY(),target.getX(time),target.getY(time)) - getGunHeadingRadians();
            
			setTurnGunRightRadians(normalizeBearingRadians(gunOffset));
			
			if (getGunHeat() == 0 && Math.abs(getGunTurnRemaining()) < 2)
			{
				setFire(bulletPower);
				//out.println("Shooting at: " + target.getName());
			}
		}
	}
	
	private void setBulletPower() {
		
		if(target != null)
		{
			if(target.getChanceToHit() <= 0.0)
				bulletPower = .1;
			else if(target.getChanceToHit() <= 0.2)
				bulletPower = .2;
			else if(target.getChanceToHit() <= 0.4)
				bulletPower = 1;
			else if(target.getChanceToHit() <= 0.6)
				bulletPower = 1.5;
			else if(target.getChanceToHit() <= 0.8)
				bulletPower = 2.0;
			else
				bulletPower = 3.0;
		
		
			if(target.getDistance() < 150)
				bulletPower = 3;
			if(target.getVelocity() < 1)
				bulletPower = 3;
		}
	}
	
	public void onBulletMissed(BulletMissedEvent e) {
		/*if(bulletPower > 1)
			bulletPower = 1;
		if(bulletPower >= .2)
			bulletPower -= .1;*/
		
		target.setChanceToHit(target.getChanceToHit() - .20);
		if(target.getChanceToHit() < 0)
			target.setChanceToHit(0);
	}
	
	public void onBulletHit(BulletHitEvent e) {
		/*if(bulletPower < 1)
			bulletPower = 1;
		bulletPower += .5;	*/
		if(e.getName() == target.getName())
		{
			target.setChanceToHit(target.getChanceToHit() + .40);
			if(target.getChanceToHit() > 1)
				target.setChanceToHit(1);
		}
	}
	
	public void onWin(WinEvent e)
	{
		setTurnLeft(1000);
		setAhead(4);
		execute();
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		//turnLeft(90 - e.getBearing());
	}
	
	public void onHitWall(HitWallEvent e) {
		hasHitWall = true;
		
		setTurnLeft(90 - e.getBearing());
		execute();
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		
		for(int i = 0; i < scannedRobots.size(); i++)
		{
			ScannedRobot enemy = (ScannedRobot)scannedRobots.get(i);
			
			if(e.getName() == enemy.getName())
			{
				enemy.setIsAlive(false);
				out.println(target.getName() + " is dead.");
			}
		}
	}
	
	public double normalizeBearing(double angle) {
		while (angle >  180) angle -= 360;
		while (angle < -180) angle += 360;
		return angle;
	}
	
	public double normalizeBearingRadians(double angle) {
		while (angle >  Math.PI / 2) angle -= 2 * Math.PI;
		while (angle < -Math.PI / 2) angle += 2 * Math.PI;
		return angle;
	}
	
	public double normalizeAngle(double angle) {
		while (angle >  360) angle -= 360;
		while (angle < 0) angle += 360;
		return angle;
	}
	
	public double distanceToWall() {
		
		double currentLocation = getX();
		double heading = getHeading();
		double wallLocation = 0;
		
		if(heading > -1 && heading < 1) //heading up along right wall
		{
			wallLocation = getBattleFieldHeight();
			return wallLocation - getY();
		}
		else if(heading > 89 && heading < 91) // heading right along bottom wall
		{
			wallLocation = getBattleFieldWidth();
			return wallLocation - getX();
		}
		else if(heading > 179 && heading < 181) // heading down along left wall
		{
			return getY();	
		}
		else if(heading > 269 && heading < 271) // heading left along top wall
		{
			return getX();	
		}
		else
		{
			return -1;
		}
	}
	
//	gets the absolute bearing between two x,y coordinates
    public double absbearing(double x1, double y1, double x2, double y2)
    {
            double x = x2 - x1;
            double y = y2 - y1;
            double distance = getDistance(x1, y1, x2, y2);
            if( x > 0 && y > 0 )
            {
                    return Math.asin(x / distance);
            }
            if( x > 0 && y < 0 )
            {
                    return Math.PI - Math.asin(x / distance);
            }
            if( x < 0 && y < 0 )
            {
                    return Math.PI + Math.asin(-x / distance);
            }
            if( x < 0 && y > 0 )
            {
                    return 2.0 * Math.PI - Math.asin(-x / distance);
            }
            return 0;
    }

    public double getDistance(double x1, double y1, double x2, double y2)
    {
            double x = x2 - x1;
            double y = y2 - y1;
            double length = Math.sqrt(x*x + y*y);
            return length;
    }
}
