package sheldor.melee.nano;

import java.awt.Color;
import robocode.*;
import robocode.util.Utils;
import java.lang.Math;

public class TestMelee extends AdvancedRobot
{
	static String closestEnemyName;
	static double closestEnemyDistance;
	static double moveAmount;
	
	public void run() 
	{
		setAdjustGunForRobotTurn(true);	
		setColors(Color.black, Color.cyan, Color.yellow);		
		
		closestEnemyName = null;
		setTurnRadarRightRadians(closestEnemyDistance = moveAmount = Double.POSITIVE_INFINITY);		
	}
	
	public void onScannedRobot(ScannedRobotEvent e) 
	{
		if (e.getDistance() < (closestEnemyDistance - 72) || e.getName().equals(closestEnemyName))
		{	
			closestEnemyName = e.getName();	
			
			double absoluteBearing;	
			double bulletPower;	
					
			if (getDistanceRemaining() == 0)
			{
				setAhead(moveAmount = -moveAmount);
				setTurnRight(90);
			}
	
			if (getGunHeat() < (300 / (closestEnemyDistance = e.getDistance())))
			{			
				setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
			}
		
			setTurnGunRightRadians(Utils.normalRelativeAngle(
				((absoluteBearing = getHeadingRadians() + e.getBearingRadians()) + (Math.asin((e.getVelocity() * (Math.random())) /
				Rules.getBulletSpeed(bulletPower = Math.min(Math.min(e.getEnergy(), getEnergy()) / 4, 750 / closestEnemyDistance))))
				* Math.sin(e.getHeadingRadians() - absoluteBearing)) - getGunHeadingRadians()));				
			
			setFire(bulletPower);		
		}
	}	
	
	public void onHitWall(HitWallEvent e) 
	{
		if(Math.abs(moveAmount) > 153)
		{
			moveAmount = 153;
		}
	}

	public void onRobotDeath(RobotDeathEvent e)
	{
		closestEnemyDistance = Double.POSITIVE_INFINITY;
	}
}			