package fromHell;

import java.awt.Color;

import fromHell.movement.*;
import fromHell.scanning.*;
import fromHell.targeting.*;

import robocode.*;

/*
 * Credits should go to: PEZ, Skilgannon, Voidious
 * and to all other developers sharing their knowledge
 * in form of open source bots and at the wiki!
 */

public class CHCl3 extends AdvancedRobot {
    private static GFTGun targeting;
    private static WaveSurfing movement;
    private static Scanning scanning;
    private static boolean isTC = false;
    private static boolean isMC = false;

    public void run() {
	setAdjustRadarForRobotTurn(true);
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setColors(Color.black, Color.darkGray, Color.lightGray, null, Color.black);
	targeting = new GFTGun(this);
	movement = new WaveSurfing(this);
	scanning = new Scanning(this);
	scanning.run();
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
	scanning.onScannedRobot(scannedRobotEvent);
	if (!isTC) {
	    movement.onScannedRobot(scannedRobotEvent);
	}
	if (!isMC) {
	    targeting.onScannedRobot(scannedRobotEvent);
	}
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
	if (!isMC) {
	    targeting.onBulletHitBullet(bulletHitBulletEvent);
	}
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
	if (!isMC) {
	    targeting.onBulletHit(bulletHitEvent);
	}
    }

    public void onBulletMissed(BulletMissedEvent bulletMissedEvent) {
	if (!isMC) {
	    targeting.onBulletMissed(bulletMissedEvent);
	}
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
	if (!isTC) {
	    movement.onHitByBullet(hitByBulletEvent);
	}
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
	out.println("Ouch, I hit a wall bearing " + hitWallEvent.getBearingRadians() + " * PI.");
    }

    public void onWin(WinEvent winEvent) {
	if (!isTC) {
	    movement.onWin(winEvent);
	}
    }
}
