package davidalves.net.targeting;

import robocode.*;
import davidalves.net.*;
import davidalves.net.math.*;
import davidalves.net.data.*;
import davidalves.net.util.*;
import java.util.*;
import java.io.*;

public class GunManager{
	Duelist me;
	EnvironmentInterface environment;
	RobocodeRobot target;
	double bulletPower = 2;
	//FiniteMovingAverage FiringAngle = new FiniteMovingAverage(1);
	

	int currentTargetingMethod = 2;
	final int strategyCount = 3;
	
	public GunManager(Duelist myBot,EnvironmentInterface myEnvironment){
		me = myBot;
		environment = myEnvironment;
	}
	
	public void manageGun(){
		target = environment.getTarget();
		if (environment.targetLocked()){
			selectBulletPower();
			aim();
			fireWhenReady();
		}
	}
	
	void selectBulletPower(){
		StrategyDatabase targetingStrategyDatabase = (StrategyDatabase) me.strategyDatabase;
		//*
		if (targetingStrategyDatabase != null){			
			if (me.getEnergy() < 30){
				double bestBulletPowerGoodness = -9999;
				double bestBulletPower = 3;
				double probableEnergyGain;
				for(bulletPower = 3; bulletPower >= .1; bulletPower -= Math.PI / 100){
					probableEnergyGain = targetingStrategyDatabase.probabilityOfHit(target, bulletPower) * DaveMath.energyGainedByHitOfPower(bulletPower) / DaveMath.maxFiringFrequency(bulletPower, me.getGunCoolingRate()) - bulletPower;
					//double bulletPowerGoodness = probableEnergyGain;
					double probableDamageToEnemy = targetingStrategyDatabase.probabilityOfHit(target, bulletPower) * DaveMath.damageDoneByPower(bulletPower);
					
					//Factor in how import each of these concerns are right now
					double bulletPowerGoodness = probableEnergyGain + probableDamageToEnemy;
					
					if (bulletPowerGoodness > bestBulletPowerGoodness){
						bestBulletPowerGoodness = bulletPowerGoodness;
						bestBulletPower = bulletPower;
					}
				}
				if (target.powerNeededToKill() < bulletPower)
					bestBulletPower = target.powerNeededToKill();
				bulletPower = Math.max(Math.min(bestBulletPower, me.getEnergy() / 3), .1);
			} else {
				bulletPower = 3;
			}
		} else {
			me.error("GunManager:selectBulletPower()","Targeting strategy database for <" + target.getRobotClass() + "> is null");
			bulletPower = .1;
		}
		//*/
		//bulletPower = DaveMath.scaledArcTangent(0,1200,.75,3,-10,550, target.getDistance());
		//bulletPower = 3;
		//me.out.println("Enemy Distance " + Math.round(target.getDistance()) + " Bullet Power: " + bulletPower);
		
		//If not much energy is needed to kill target, fire with minimum energy
		//so that we're more likely to hit.
		bulletPower = Math.max(.1, Math.min(target.powerNeededToKill(), bulletPower));
		
		//If we don't have much energy, fire low power bullets to conserve energy
		bulletPower = Math.max(.1, Math.min(bulletPower, me.getEnergy() / 8));
	}
	
	void fireWhenReady(){
		if (environment.targetLocked()){
			//me.strategyDatabase.fireVirtualBullets(me, environment, target, bulletPower);
		}
		if (me.getGunHeat() == 0 && me.getGunTurnRemaining() < 3 && me.getOthers() != 0 && environment.getTarget()!=null){
			StrategyDatabase targetingStrategyDatabase = me.strategyDatabase;
			double probableEnergyGain = targetingStrategyDatabase.probabilityOfHit(target, bulletPower) * DaveMath.energyGainedByHitOfPower(bulletPower) / DaveMath.maxFiringFrequency(bulletPower, me.getGunCoolingRate()) - bulletPower;
			if (targetingStrategyDatabase != null){
				/*
				me.out.println("\nFiring:");
				if(target.powerNeededToKill() <= bulletPower && bulletPower != 3)
					me.out.println("> DEATHBLOW!");
				me.out.print("> Firing using " + targetingStrategyDatabase.getIdealTargetingStrategy(target, bulletPower));
				me.out.print(" at range " + DaveMath.getRangeClass(target.getDistance(), bulletPower) + " (" + Math.round(target.getDistance()) + ")");
				me.out.println(" with power " + bulletPower);
				me.out.println("> Intercept Time: " + Math.round(target.getDistance() / DaveMath.speedCorrespondingToPower(bulletPower)));
				me.out.println("> Estimated energy gained by firing: " + ((targetingStrategyDatabase.probabilityOfHit(target, bulletPower) / 100) * DaveMath.energyGainedByHitOfPower(bulletPower) - bulletPower));
				me.out.println("> Estimated chance of hit: " + Math.round(targetingStrategyDatabase.probabilityOfHit(target, bulletPower)) + "%");
				me.out.println("> Confidence in estimated % chance to hit / energy gain: " + Math.round(targetingStrategyDatabase.confidenceInProbabilityToHit(target, bulletPower)) + "%");
				//*/
				targetingStrategyDatabase.fireVirtualBullets(me, environment, target, bulletPower);
			} else {
				me.error("GunManager:fireWhenReady()","Targeting strategy database for <" + target.getRobotClass() + "> is null");
			}
			if(probableEnergyGain > 0 || me.getTime() < 150 || target.getEnergy() < (me.getEnergy() + 10 * probableEnergyGain) || Math.random() < .1)
			//if(environment.getTarget().getDistance() < 800 || me.getEnergy() > 75)
				if((me.getTime() % Math.max(Math.round(40 / (me.getEnergy())),1) == 0) 
					|| me.getEnergy() > 10)
						me.setFire(bulletPower);
		}
		
		//prospectiveDestinations
	}
	
	
	void aim(){
		Point predictedIntercept;
		RobocodeRobot target = environment.getTarget();
		//targetingStrategyDatabaseStrategyDatabase targetingStrategyDatabase = (StrategyDatabase) me.strategyDatabase.get(target.getRobotClass());
		StrategyDatabase targetingStrategyDatabase = me.strategyDatabase;
		if(targetingStrategyDatabase != null){
			targetingStrategyDatabase.updateVirtualBullets(me, environment);
			if(target.getEnergy() > 0){
				predictedIntercept = targetingStrategyDatabase.getIdealTargetingStrategy(target, bulletPower).predictedIntercept(me, environment, bulletPower);		
			} else {
				predictedIntercept = target.getLocation();
			}
		} else {
			if (target != null){
				me.error("GunManager:aim()","Targeting strategy database for <" + target.getRobotClass() + "> is null, firing directly at target");
				predictedIntercept = target.getLocation();
			} else {
				me.error("GunManager:aim()","target is null, aiming at battlefield center");
				predictedIntercept = environment.getArenaCenter();
			}
		}
		/*if(target!=null){
			FiringAngle.addValue(DaveMath.angularDifferenceBetween(me.getAbsoluteAngleTo(target.getLocation()), me.getAbsoluteAngleTo(predictedIntercept)));
		}
		me.setTurnGunRight(DaveMath.angularDifferenceBetween(me.getGunHeading(), FiringAngle.getAverage() + me.getAbsoluteAngleTo(target.getLocation())));*/
		me.setTurnGunRight(DaveMath.angularDifferenceBetween(me.getGunHeading(), me.getAbsoluteAngleTo(predictedIntercept)));
	}
}