package erdnis;

import robocode.*;

public class EnemyBullet {
	
	long timeFired;
	double xFiredFrom;
	double xFiredTo;
	double yFiredFrom;
	double yFiredTo;
	double xDist;
	double yDist;
	double power;
	
	public EnemyBullet(long timeFired, double firedFrom, double firedTo, double firedFrom2, double firedTo2, double power) {
		this.timeFired = timeFired;
		xFiredFrom = firedFrom;
		xFiredTo = firedTo;
		yFiredFrom = firedFrom2;
		yFiredTo = firedTo2;
		this.power = power;
		xDist = xFiredTo - xFiredFrom;
		yDist = yFiredTo - yFiredFrom;
	}
	
	public boolean passedMe(long currentTime){
		double dist = Math.sqrt(Math.pow(xDist, 2) + Math.pow(yDist, 2));
		if(currentTime - timeFired > dist/getBulletSpeed(power)){
			return true;
		}
		return false;
			
	}

	public double getBulletSpeed(double power) {
		return 20-power*3;
	}
}
