package bvh.mini;

import java.util.*;
import java.awt.geom.Point2D;
import java.awt.Color;
import java.io.*;

import robocode.*;
import robocode.util.Utils;

/**
 * Fenrir - a (mini) robot by Bart van Hest
 *
 *   "Fenrir is a gigantic and terrible monster in the shape of a wolf. He is the eldest child
 *    of Loki and the giantess Angrboda. The Asgard gods learned of a prophecy which stated that
 *    the wolf and his family would one day be responsible for the destruction of the world."
 *
 * aimed to be a melee-specialist in the mini league...
 *
 *
 * Wijzigingshistorie v0.35 (05-03-2004): 
 *  - volgende stap wordt eerder gezet (getDistanceRemaining()<18 ipv <5): doet het iets beter.
 *  - reduceert snelheid bij scherpe draaien.
 *
 * Wijzigingshistorie v0.34 (26-05-2003): 
 *  - bewegingspatroon periodiek gemaakt: meer dan pm. 200 matches mogelijk, 
 *    maar bot stop met leren als maximale lengte is bereikt. 
 *
 * Wijzigingshistorie v0.33b (18-05-2003): 
 *  - statics uit Doel patroonherkenningsvariabelen gehaald!
 *  - kogelkracht van 2.0 naar 2.5
 *  - goed, maar nog niet zo goed als v0.21
 *
 * Wijzigingshistorie v0.32 (18-05-2003): 
 *  - statics uit Doel patroonherkenningsvariabelen gehaald!
 *
 * Wijzigingshistorie v0.30 (16-05-2003): 
 *  - ??
 *
 * Wijzigingshistorie v0.21 (26-04-2003): codesize 1483
 *  - kogelkracht 2.5 ipv 2: effectiver terwijl overleving ongeveer gelijk blijft.
 *  - nu een officiele, werkende mini!
 *
 * Wijzigingshistorie v0.2 (26-04-2003): codesize 1483
 *  - bewegings bug opgelost: probleem met omkeren om rotaties te minimaliseren.
 *  - nu een officiele, werkende mini!
 *
 * Wijzigingshistorie v0.186f (25-04-2003): codesize 1495
 *  - versie e gecorrigeerd, is nu te groot --> kleuren zijn niet mogelijk.
 *
 * Wijzigingshistorie v0.186e (25-04-2003): codesize 1490
 *  - versie d verder verkleind
 *  --> radar verliest contact doel, tank blijft hangen tegen muren...
 *
 * Wijzigingshistorie v0.186b/c (25-04-2003): codesize 1690 (bijna een mini... :-) )
 *  - versies b en c verder verkleind
 *
 * Wijzigingshistorie v0.186 (23-04-2003): codesize 1856 (bijna een mini... :-) )
 *  - minimalisering van de grootte.
 *  - minimalisering van de grootte.
 *
 * Wijzigingshistorie v0.183 (21-04-2003):
 *  - incl. patroon herkenning gebaseerd op methode nano.LauLectric en nano.Moebius,
 *    aangepast aan melee gevechten.
 *
 * Wijzigingshistorie v0.182 (17-04-2003):
 *  - bug fixes.
 *
 * Wijzigingshistorie v0.181 (15-04-2003):
 *  - incl. patroon herkenning gebaseerd op methode nano.LauLectric en nano.Moebius,
 *
 * Wijzigingshistorie v0.18 (10-04-2003): 
 *  - incl. patroon herkenning gebaseerd op methode nano.LauLectric en nano.Moebius,
 *    aangepast aan melee gevechten.
 *
 * Wijzigingshistorie v0.x (17-02-2003): @#*# lost this version because my laptop was stolen..
 *  - incl. patroon herkenning
 *
 * Wijzigingshistorie v0.174 (25-02-2003):
 *  - increased standard walk distance: improves bullet dodging.
 * 
 * Wijzigingshistorie v0.173 (25-02-2003):
 *  - increased standard walk distance: improves bullet dodging.
 * 
 * Wijzigingshistorie v0.172 (25-02-2003):
 *  - verbeterde waarden parameters voor berekening vd. bewegings potentiaal.
 *
 * Wijzigingshistorie v0.17 (24-02-2003):
 *  - neemt laatste bewegingsrichting mee in bepalen nieuwe postie.
 *
 * Wijzigingshistorie v0.16 (23-02-2003):
 *  - inclusief circulaire doel pos. schatter.
 *
 * Wijzigingshistorie v0.15 (20-02-2003):
 *  - inclusief lineaire doel pos. schatter gebaseerd op gemiddelde snelheid van doel.
 *
 * Wijzigingshistorie v0.1 (17-02-2003):
 *  - gebaseerd op Balder v0.53
 *  - beweging gebaseerd op combinatie van potentiaal-methode en SandboxMini
 *
 */

public class Fenrir extends AdvancedRobot implements Constanten {

/**********************************************************************
** BEGIN CLASS DOEL
**********************************************************************/
/**
 * Doel - deze class bevat zoveel mogelijk informatie over het doel:
 *
 * Deze class wordt gebruikt om gescande tegenstanders op te slaan en
 * om het huidig doel vast te leggen.
 *
 * to do: doel en kogel laten overerven van gemeenschappelijk "inkomend" object.
 */
static class Doel implements Constanten {

/**********************************************************************
** definitie variabelen.
**********************************************************************/
   public  String               naam; // naam opponent
   public  boolean              locked;
   public  double               e, richting, afstand, schatting;
   private long                 scanTijd; //tijd waarop doel is gescanned

	private double 		        transversaleVerplaatsing[] = new double[PATROONLENGTE];
	private StringBuffer         bewegingsPatroon           = new StringBuffer();
	private int 			        scanTeller, sampleTijd     = 5;

// variabelen statistiek patroonherkenning
//   public  int           probeerTeller, succesTeller;
/**********************************************************************
** Constructor.
**********************************************************************/
   public Doel() {
      naam   = null;
      locked = false;
   }

/**********************************************************************
** methoden voor bijhouden info doel.
**********************************************************************/
/**
* Methode voor bijwerken doel-info.
*/
   public void setInfo(ScannedRobotEvent evt, Fenrir bot) {
		int    matchIndex;
      double transversaleBeweging;
      long   deltaT;

      naam                = evt.getName();
      locked              = true;

// bijwerken sampleTijd:
      sampleTijd          = (int) Math.round(0.99 * sampleTijd + 0.01 * (deltaT= - scanTijd + (scanTijd = bot.getTime())));

// bijwerken pattern matching code:
// - in 1-vs-1 is de sampleTijd gelijk 1 en hoeft er niets extras te worden gedaan
// - in melee modus moet onderscheid worden gemaakt tussen verwerking scans in 
//   daadwerkelijke melee of eindstadium waar slechts 1 tegenstander resteerd. Omdat
//   radar in melee 360 graden spint en in 1-vs-1 gelocked blijft op het doel (ook 
//   in melee mode), moet in de laatste situatie de scan slechts worden opgeslagen 
//   als de sample tijd gelijk is aan die tijdens het 360 graden spinnen van de radar. 
      if ( !bot.meleeModus
        || (bot.meleeModus && bot.getOthers() == 1 && scanTijd%sampleTijd == 1)
        || (bot.meleeModus && bot.getOthers()  > 1 )
         ) {
         transversaleBeweging  = evt.getVelocity() * Math.sin(evt.getHeadingRadians() - (richting= bot.getHeadingRadians() + evt.getBearingRadians()) );

         ++scanTeller;
      // het array transversaleVerplaatsing bevat de cummulatieve transversale
      // snelheid ten op zichte van de robot.
      // commentaar uit Moebius: ArcLength S = Angle (radians) * Radius of circle.
         transversaleVerplaatsing[scanTeller%PATROONLENGTE] = transversaleVerplaatsing[(scanTeller - 1)%PATROONLENGTE] 
                                                            + transversaleBeweging;
		
		// Add velocity to search table. Convert it to a base 20 number so our 17 
      // possible answers fit in 1 char
	   	bewegingsPatroon.append((char)transversaleBeweging);

		// Search the string vs. the last SEARCH_DEPTH entries. Add SEARCH_DEPTH - 1 
      // so we're at the end of the match.
		// One optimization here - using scanTeller instead of structure length.  
//         ++probeerTeller; // nieuwe poging patroonherkenning

         matchIndex = bewegingsPatroon.lastIndexOf(
	   						 bewegingsPatroon.substring( Math.max((scanTeller - ZOEK_DIEPTE)%PATROONLENGTE, 0) )
                        ,(int)Math.max((scanTeller- 600 - ZOEK_DIEPTE)%PATROONLENGTE, 0) 
                                                   );

         if (matchIndex == -1 ) 
            matchIndex = scanTeller-1;
         else {
            matchIndex += ZOEK_DIEPTE;
//            ++succesTeller; // geslaagde poging patroonherkenning
         }

         schatting = (e = evt.getEnergy()) > 0?
                    (transversaleVerplaatsing[Math.min( (matchIndex + (int)( (afstand=evt.getDistance()) / 14D))%PATROONLENGTE, scanTeller%PATROONLENGTE)] 
                   - transversaleVerplaatsing[matchIndex%PATROONLENGTE]) / afstand
		             + richting
                   : richting;
      }
   }
}
/**********************************************************************
** EINDE CLASS DOEL.
**********************************************************************/

/**
* run: Fenrir's hoofdroutine.
*/
   public void run() {
// initieer tank kleuren:
		setColors(Color.black, Color.black, Color.yellow);

// initialisatie tank:
      setAdjustGunForRobotTurn(true);
      setAdjustRadarForGunTurn(true);

// bepaal type gevecht( o.b.v. het aantal tegenstanders):
      meleeModus = getOthers() > 1? true: false;

// start radar:
      setTurnRadarRightRadians( Double.POSITIVE_INFINITY );

// levensloop:
      do {
         navigatie();   // verplaats robot:
         execute();
      } while (true);
   } // einde run-method

/**********************************************************************
** Methods voor event-afhandeling:
**********************************************************************/
/**
 * onScannedRobot: What to do when you see another robot
 * let op: van alle scanned bots tijdens een radar-sweep wordt de dichtstbijzijnde bot doorgegegeven!
 */
   public void onScannedRobot(ScannedRobotEvent evt) {
      Doel   opponent;
      String naam;
// doel nieuw opvoeren in lijst of opzoeken en bijwerken:
      if( doelen.containsKey(naam=evt.getName()) ) {
         opponent = (Doel)doelen.get(naam);
      } else {
         opponent = new Doel();
         doelen.put(naam, opponent);
      }
      opponent.setInfo(evt, this);  // leg informatie over doel vast:

// oportunistisch handelen: alleen doel selecteren als energie laag is en kans op vernietiging groot (Loki trekje :-o )
//                          of als doel dichterbij is
//                          of als ik geen doel in het leven heb:
      if ( !doel.locked                   // selecteer gunstig doel indien nog geen ander doel gevonden
       || doel.naam == naam             // update doel indien al eerder gevonden
      || ( doel.afstand > opponent.afstand
        && doel.e > opponent.e)     // selecteer gunstiger doel
         )
         doel = opponent;  // leg informatie over doel vast:

      stuurKannon(); // stuur kanon aan:
      stuurRadar();  // stuur radar aan:
   }

/**
* onRobotDeath: Bewegingstoestand resetten wanneer doel is vernietigd.
*/
   public void onRobotDeath(RobotDeathEvent evt) {
      // indien huidige doel is vernietigd, dan lock op doel vrijgeven:
      if ( doel.naam == evt.getName() ) doel.locked = false;
   }

/**********************************************************************
** Methods voor besturing tank
**********************************************************************/
/**
* navigatie(): Beweging o.b.v. potentiaalveld waarbij minder gunstige
* posities een hogere potentiaal krijgen en bot richting laagste potentiaal
* beweegd.
*/
   public void navigatie() {
      double draaiHoek;

      if ( Math.abs(getDistanceRemaining()) < 18D ) {
         nieuwePositie  = potentiaalMode( huidigePositie= new Point2D.Double(getX(), getY()) );
         nieuweRichting = Utils.normalRelativeAngle( bepaalRichting(nieuwePositie, huidigePositie) - getHeadingRadians() );
// draai en verplaats robot:
         setTurnRightRadians(draaiHoek = Math.atan(Math.tan(nieuweRichting)));
         setAhead(huidigePositie.distance(nieuwePositie) * (nieuweRichting == draaiHoek ? 1 : -1));
      }
// eventueel snelheid minderen om sneller te kunnen draaien:
      if ( Math.abs(getTurnRemainingRadians()) > KWARTPI ) {
         setMaxVelocity( (HALFPI-Math.abs(getTurnRemainingRadians()))/7.5D );
      }
      else
         setMaxVelocity(MAXIMUM_SNELHEID);
   }

   private Point2D.Double potentiaalMode(Point2D.Double positie) {
      int      kwadrant   = 0;
      double[] potentiaal = {0, 0, 0, 0, 0, 0, 0, 0};
      double   r          = 99;
      Point2D.Double   doelPositie;

      // betrek wanden in potentiaal:
      if ( positie.x < WANDAFSTAND ) {
         potentiaal[5] += 7;
         potentiaal[6] += 9;
         potentiaal[7] += 7;
      }
      if ( positie.x > (getBattleFieldWidth()  - WANDAFSTAND) ) {
         potentiaal[1] += 7;
         potentiaal[2] += 9;
         potentiaal[3] += 7;
      }
      if ( positie.y < WANDAFSTAND ) {
         potentiaal[3] += 7;
         potentiaal[4] += 9;
         potentiaal[5] += 5;
      }
      if ( positie.y > (getBattleFieldHeight()  - WANDAFSTAND) ) {
         potentiaal[0] += 7;
         potentiaal[1] += 9;
         potentiaal[7] += 7;
      }

// uitbreiden potentiaal door laatste eigen bewegingsrichting te betrekken (bewegingsrichting 
// omkeren wordt ontmoedigd)
// proefondervindelijk aangetoond dat dit verbetering geeft in 1-vs-1, 
// verslechtering bij melee-gevechten:
      if (getOthers() == 1) {
         // afstoting van vorige positie (nieuwe richting bevat hier nog de voorgaande richting...):
         kwadrant        = (int)(Math.round(4+8*nieuweRichting/TWEEPI))%8;
         potentiaal[kwadrant]  += 0.5; // bewegingsrichting niet omkeren 

         // aantrekking naar middelpunt slaveld:
         kwadrant        = (int)(Math.round(8+8*bepaalRichting(new Point2D.Double(getBattleFieldWidth()/2D,getBattleFieldHeight()/2D), positie)/TWEEPI))%8;
         potentiaal[kwadrant]  -= 1.0;   // naar middelpunt slagveld 
      }
/*
      else {
         // afstoting van vorige positie (nieuwe richting bevat hier nog de voorgaande richting...):
         kwadrant        = (int)(Math.round(4+8*nieuweRichting/TWEEPI))%8;
         potentiaal[kwadrant]  += 0.25; // bewegingsrichting niet omkeren 
      }
*/
      // bepaal potentiaal door te sommeren over positie v.d. tegenstanders:
      for (Enumeration e = doelen.elements(); e.hasMoreElements(); ) {
         potentiaal[ kwadrant = (int)(Math.round(8+8*((Doel)e.nextElement()).richting/TWEEPI))%8 ]  
                                       += 2.0;  // niet naar tegenstander toe bewegen
         potentiaal[(kwadrant + 4)%8]  += 1.5;  // niet van tegenstander af bewegen
         potentiaal[(kwadrant + 1)%8]  += 1.0;  // en kans op beweging schuin vanaf/naar tegenstander ook verkleinen 
         potentiaal[(kwadrant + 7)%8]  += 1.0;
         potentiaal[(kwadrant + 3)%8]  += 0.5;
         potentiaal[(kwadrant + 5)%8]  += 0.5;
      }


      // bepaal gunstigste richting:
      for (int i=0; i < 8 ; i++) {
         if (    potentiaal[i] < r
            || ( potentiaal[i]== r && Math.random() > 0.5 )
            ) 
            r  = potentiaal[kwadrant = i];
      }

      // inbouwen willekeur in bewegingsafstand en tijdstip waarop volgende nieuwe
      // positie wordt bepaald.
      // bepaal nieuwe x,y positie o.b.v. huidige positie, nieuwe hoek t.o.v. doel
      // en loopafstand die afhankelijk is van huidige afstand tot doel en hierboven
      // bepaalde random factor.
      doelPositie = new Point2D.Double( positie.getX() + (r = (1D+Math.random()) * STANDAARDLOOPAFSTAND) * Math.sin(kwadrant*KWARTPI)
                                      , positie.getY() + r * Math.cos(kwadrant*KWARTPI)
                                      );
      // ontwijk wanden door min./max. waarden te bepalen voor nieuwe x,y positie.
      // overleving verbeterd door positie te spiegelen t.o.v. minimum wandafstand!
      doelPositie.setLocation( Math.min( getBattleFieldWidth()  - WANDAFSTAND, Math.max(WANDAFSTAND, doelPositie.getX()) )
                             , Math.min( getBattleFieldHeight() - WANDAFSTAND, Math.max(WANDAFSTAND, doelPositie.getY()) )
                             );
      return( doelPositie );
   }
/**********************************************************************
** Methods voor besturing kanon
**********************************************************************/
/**
* Vuurkracht konstant (onafhankelijk van de doelafstand en de (voorspelde) hoek tussen kanon en doel).
*
* v0.2 (28-08-2002)
*/
   public void stuurKannon() {
      if ( doel.locked ) { // alleen kanon sturen als er op iets te schieten valt
         setTurnGunRightRadians( Utils.normalRelativeAngle( doel.schatting - getGunHeadingRadians() ) );

         if (getEnergy()   > STANDAARDVUURKRACHT 
             ) setFire( STANDAARDVUURKRACHT );

      } // einde controle op aanwezigheid doel
   } // einde method stuurKannon()

/**********************************************************************
** Methods voor besturing radar
**********************************************************************/
/**
* stuurRadar(): Radarsturing in melee gevechten waarbij zo groot mogelijk gebied wordt bestreken:
*
* v0.4 (10-04-2003): 1-vs-1 mode toegevoegd zodat een constanter scan-tussentijd wordt bereikt.
* v0.3 (25-12-2002): radar draait door tot alle bots in melee zijn gescanned waarna de
*                    draairichting omkeerd. Op deze manier hoeft niet perse 360 graden
*                    te worden gescanned en worden toch alle bots bijgehouden.
* v0.2 (09-11-2002): bestreken gebied wordt gebaseerd op de max. en min. hoek waarbinnen zich
*                    alle tegenstanders bevinden.
* v0.1 (10-09-2002): volledige 360 graden wordt bestreken.
*/
   public void stuurRadar() {
      if (!meleeModus && doel.locked)
         setTurnRadarRightRadians(3D*Utils.normalRelativeAngle( doel.richting - getRadarHeadingRadians() ));
      else 
         setTurnRadarRightRadians( Double.POSITIVE_INFINITY );
      
      // else (melee-mode) laat de radar draaien in dezelfde richting om een 
      // gelijkmatige sample-rate te verkrijgen voor de patroon herkenning. 
      // setTurnRadarRightRadians( -getRadarTurnRemainingRadians() );
   }

/**********************************************************************
** Utils.
**********************************************************************/
/**
* bepaal richting van bot tot doel-positie.
*/
   public static double bepaalRichting(Point2D.Double doel, Point2D.Double oorsprong) {
      return Math.atan2( (doel.getX()-oorsprong.getX()), (doel.getY()-oorsprong.getY()) );
   }

/**********************************************************************
** Definitie van variabelen.
**********************************************************************/
// variabelen voor beweging:
   private double              nieuweRichting;
   public  Point2D.Double      huidigePositie, nieuwePositie;

// variabelen die huidig doel of directe bedreiging bevatten:
   private static Hashtable    doelen = new Hashtable();
   private Doel                doel   = new Doel();
   public  boolean             meleeModus;        
}
/**********************************************************************
** EINDE CLASS Fenrir
**********************************************************************/