package simonton.nano;

import robocode.*;
import robocode.util.*;

/*
 * This is a pattern matcher just like WeekendObsession that runs stop & go 
 * movement until that proves unfruitful.  Then it switches to random movement
 * that attempts to flatten its profile based on distance.
 * 
 * Credit goes to Kev's Splinter for the movement (with the "flattening"
 * improvement by me).
 * 
 * Version 1.0: + codesize: 249.
 * 
 * Version 1.1: + pattern matching on lateral velocity now, instead of just
 *				  velocity.  This is a deviation from the original
 *				  idea behind the WeekendObsession series, but was necessary
 *				  to beat Merkava - my worst enemy.
 *				+ codesize: 249
 * 
 * Version 1.2: + the flattener had a logical bug.  Namely, it was not flat.  
 * 				  Not at all.  BUT, bane of my existance, it takes ONE more byte
 * 				  to flatten it, and I couldn't find it ANYWHERE!  So I had to
 * 				  change the functionality of how stop-and-go is chosen.  We'll
 * 				  see if it's effective.
 * 				+ codesize: 248.
 * 
 * Version 1.3: + Ok, how about this method? (w/ a little enegry management)
 * 				+ codesize: 249.
 * 
 * Version 1.4: + Alright, back to version 1.1 (with the non-flat movement) 
 * 				  with a super-small tweek in hopes of squeezing a few more
 * 				  points out if it.
 * 				+ codesize: 249.
 * 
 * Version 1.5: + Ok, that didn't work - we'll tweak it once the other direction
 * 				  and then give up.
 * 				+ codesize: 249.
 * 
 * Version 1.6: + I found 2 more bytes & was able to fix the flattener bug!
 * 				+ codesize: 248.
 * 
 * Version 1.6.2: + Tuning the "flattener" experimentally.
 * 				  + codesize: 249.
 *
 * Version 1.6.3: + Let's try reducing our firepower a bit.
 *                + codesize: 249.
 * 
 * Version 1.7: + squeezed codesize (and I thought I didn't have any left!).
 *              + back to full firepower
 *              + added a little energy management!
 *              + codesize: 249.
 */
public class WeekendObsession_S extends AdvancedRobot {
	static final double flipFactor = 1.5;
	static final int firePower = 3;
	static final int fireSpeed = 20 - firePower * 3;
	static final int maxMatchLen = 30;
	static final int sngDeaths = 5;
	
	static double move = 36;
	static double enemyEnergy;
	static int deaths;

	public void run() {
		setAdjustGunForRobotTurn(true);
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		int matchLen = maxMatchLen;
		double a = e.getBearingRadians();
		double dist;
		int matchPos;
		int i;
		
		// turn.
		setTurnRightRadians(Math.cos(a));
		a += getHeadingRadians();

////////
// CFC2K
		// fire.
		setFire(getEnergy() - 5);
		
		// think.
		enemyHistory = 
			String.valueOf(
				(char) (e.getVelocity() * Math.sin(e.getHeadingRadians() - a)))
			.concat(enemyHistory);
		
		while(
			(matchPos = 
				enemyHistory.indexOf(
					enemyHistory.substring(0, matchLen--), 
					i = (int) (dist = e.getDistance()) / fireSpeed)) 
			< 0);
		
		// aim.
		do {
			a += (short) enemyHistory.charAt(--matchPos) / dist;
		} while (--i > 0);
		setTurnGunRightRadians(
			Utils.normalRelativeAngle(a - getGunHeadingRadians()));
//// CFC2K
//////////
//hangTime = e.getDistance() / fireSpeed;
//double flipFactor = Double.parseDouble(System.getProperty("flipFactor"));
//////////

		// move.
		if (enemyEnergy > (enemyEnergy = e.getEnergy())) {
			setAhead(move);
		}
		if (deaths > sngDeaths) {
			if (Math.random() < (flipFactor * fireSpeed) / dist) {
				onHitWall(null);
			}
			setAhead(move);
		}

		// look.
		setTurnRadarLeft(getRadarTurnRemaining());
	}
	
	public void onHitWall(HitWallEvent e) {
		move = -move;
	}
	
	public void onDeath(DeathEvent e) {
		++deaths;
	}

	static String enemyHistory = ""
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 1
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 2
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char)-1
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char)-2 + (char)-4 + (char)-6
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-7 + (char)-6 + (char)-5 + (char)-4
		+ (char)-3 + (char)-2 + (char)-1 + (char)0
		+ (char) 2 + (char) 4 + (char) 6 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 7 + (char) 6 + (char) 5 + (char) 4
		+ (char) 3 + (char) 2 + (char) 1 + (char) 0;
}
