package tobe.statistics;
import tobe.util.BearingVector;

/**
 * An Evasion is a record of where enemy was when we fired and when we should have hit
 */
public class Evasion extends BearingVector implements java.io.Serializable
{
	public Evasion(EvasionCondition shot, double currentX, double currentY, double timeDiff) {
		super();
		setPoints(currentX, currentY, shot.x, shot.y);
		originalHeading = shot.heading;
		originalVelocity = shot.velocity;
		time = shot.timeToHit - timeDiff;
	}
	
	public double getHeadingRelativeHeading() {
		return normalizeAngle(getBearing() - originalHeading);
	}
	
	public double getAngularVelocity() {
		return getHeadingRelativeHeading()/time;
	}
	
	public double getVelocity() {
		return getDistance()/time;
	}
	
	public double getVelocityRelativeVelocity(double v) {
		return getVelocity()*((Math.abs(v)+4)/(Math.abs(originalVelocity)+4));
	}
	
	double originalHeading;
	double originalVelocity;
	double time;
}
