package dsekercioglu.mega;

import dsekercioglu.mega.*;
import dsekercioglu.mega.gresVretter.GresVretter;
import dsekercioglu.mega.raikoGun.RaikoGun;
import dsekercioglu.mega.weefSuffurd.WeefSuffurd;
import dsekercioglu.mega.wfGun.Fangs;
import dsekercioglu.mega.wfMove.Lightning;
import dsekercioglu.mega.wfEyes.Lock;
import dsekercioglu.mega.wfShield.Defense;
import dsekercioglu.mega.wolfBreath.WolfBreath;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.control.events.BattleCompletedEvent;

public class WhiteFang extends AdvancedRobot {

    public static Lock radar;
    public static Lightning move;
    public static Fangs gun;
    public static WolfBreath shield;

    public double damageTaken = 0;
    boolean killModeOn = false;
    static boolean shieldOff = false;
    
    public static double shieldingSuccess = 0;

    public void run() {
        setBodyColor(new Color(192, 192, 192));
        setGunColor(new Color(76, 76, 76));
        setRadarColor(new Color(0, 0, 0));
        setScanColor(new Color(0, 0, 0));
        setBulletColor(new Color(255, 255, 255));

        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);

        if (getRoundNum() == 0) {
            radar = new Lock(this);
            move = new Lightning(this);
            gun = new Fangs(this, false);
            shield = new WolfBreath(this);
        }

        move.run();
        gun.run();
        shield.run();
        radar.run();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        radar.onScannedRobot(e);
        if (getEnergy() / e.getEnergy() > 7.5) {
            killModeOn = true;
        }
        if (damageTaken >= 16 && shieldingSuccess / (getRoundNum() + 1) < 0.67) {
            shieldOff = true;
        }
        if (shieldOff || killModeOn) {
            move.onScannedRobot(e);
            //gun.setNextPosition(move.getNextPosition());
            gun.setNextPosition(new Point2D.Double(getX(), getY()));
            gun.onScannedRobot(e);
        } else {
            shield.onScannedRobot(e);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (shieldOff || killModeOn) {
            move.onHitByBullet(e);
            gun.onHitByBullet(e);
        } else {
            shield.onHitByBullet(e);
        }
        damageTaken += Rules.getBulletDamage(e.getBullet().getPower());
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (shieldOff || killModeOn) {
            gun.onBulletHitBullet(e);
            move.onBulletHitBullet(e);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        if (!shieldOff && !killModeOn) {
            shield.onBulletHit(e);
        } else {
            gun.onBulletHit(e);
            //move.onBulletHit(e);
        }
    }

    public void onRoundEnded(RoundEndedEvent e) {
        if (shieldOff || killModeOn) {
            gun.onRoundEnded(e);
            move.onRoundEnded(e);
        }
        if(!shieldOff) {
            shieldingSuccess++;
        }
    }

    public void onDeath(DeathEvent e) {
        shieldOff = true;
    }

    public void onPaint(Graphics2D g) {
        if (shieldOff || killModeOn) {
            gun.onPaint(g);
            move.onPaint(g);
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        shieldOff = true;
    }

}
