package dsekercioglu.mega.wfGun;

import dsekercioglu.mega.wfMove.precise.WallSmoothingMEACalculator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import static robocode.util.Utils.normalRelativeAngle;

public class Wave implements Cloneable {

    public Point2D.Double fireLocation;
    public Point2D.Double enemyLocation;

    double waveVelocity;
    double waveDamage;
    double distanceTraveled;
    double absBearing;
    public int lateralDirection;

    public double maxEscapeAngle;
    public int binNum;
    public double binWidth;

    public double[] bins;
    public double[] data;

    public boolean real;

    ArrayList<Object> information = new ArrayList<>();

    public Wave(double wavePower, Point2D.Double fireLocation, Point2D.Double enemyLocation, int lateralDirection, boolean real) {
        this.fireLocation = (Point2D.Double) fireLocation.clone();
        this.enemyLocation = (Point2D.Double) enemyLocation.clone();
        this.lateralDirection = lateralDirection;
        waveVelocity = 20 - 3 * wavePower;
        waveDamage = 4 * wavePower + 2 * Math.max(wavePower - 1, 0);
        absBearing = GunUtils.absoluteBearing(fireLocation, enemyLocation);
        maxEscapeAngle = GunUtils.calculateMEA(waveVelocity);
        this.real = real;
    }

    public void setData(double[] data) {
        this.data = data.clone();
    }

    public void setBins(double[] bins) {
        binNum = bins.length;
        binWidth = maxEscapeAngle / (binNum / 2);
        this.bins = GunUtils.getWindowBins(bins, fireLocation.distance(enemyLocation), binWidth);
    }

    public void setInformation(ArrayList<Object> information) {
        this.information = information;
    }

    public double getFireAngle(int startBin, int endBin) {
        double[] cutBins = new double[endBin - startBin + 1];
        for (int i = startBin; i <= endBin; i++) {
            cutBins[i - startBin] = bins[i];
        }
        return absBearing + ((GunUtils.getMostVisitedBin(cutBins) + startBin - binNum / 2) * binWidth * lateralDirection);
    }

    public boolean update(Point2D.Double enemyLocation) {
        distanceTraveled += waveVelocity;
        if (distanceTraveled > fireLocation.distance(enemyLocation) - 18) {
            return true;
        }
        return false;
    }

    public int getBin(Point2D.Double location) {
        double angleDif = normalRelativeAngle(GunUtils.absoluteBearing(fireLocation, location) - absBearing);
        return (int) GunUtils.limit(0, Math.round((angleDif / (lateralDirection * binWidth)) + (binNum / 2)), binNum - 1);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
