package cyragia;
import robocode.*;
import java.awt.geom.*;

public class LinearTargeting
{
	
	static double getAngle( EnemyBot enemy, Robot bot, double firepower , int accuracy ){
		double bulletSpeed = 20 - firepower * 3;
		long time = (long)(enemy.getDistance() / bulletSpeed);
		double futureX = 0;
		double futureY = 0;
		
		for( int i = 0; i < accuracy ; i++ ){
			futureX = enemy.getFutureX(time);
			futureY = enemy.getFutureY(time);
			time = (long)Point2D.distance(bot.getX(), bot.getY(), futureX, futureY)  / (long)bulletSpeed;
		}
	
		return absoluteBearing(bot.getX(), bot.getY(), futureX, futureY);
	}

	static double absoluteBearing(double x1, double y1, double x2, double y2) {
		double xo = x2-x1;
		double yo = y2-y1;
		double hyp = Point2D.distance(x1, y1, x2, y2);
		double arcSin = Math.toDegrees(Math.asin(xo / hyp));
		double bearing = 0;

		if (xo > 0 && yo > 0) { // both pos: lower-Left
			bearing = arcSin;
		} else if (xo < 0 && yo > 0) { // x neg, y pos: lower-right
			bearing = 360 + arcSin; // arcsin is negative here, actuall 360 - ang
		} else if (xo > 0 && yo < 0) { // x pos, y neg: upper-left
			bearing = 180 - arcSin;
		} else if (xo < 0 && yo < 0) { // both neg: upper-right
			bearing = 180 - arcSin; // arcsin is negative here, actually 180 + ang
		}
		return bearing;
	}		
}
