/**
 *	Predict and turn gun radians and shoot enemy.
 */

package timmit;

class Gun{
	private static TimmiT bot;
	private static Enemy en;
	private static double firePower;
	
	Gun(TimmiT owner){
		this.bot = owner;
	}//end construct
	
	protected void do_gun(Enemy en){
		this.en = en;
		firePower = this.getFirePower();
		int m = en.match;
		if(bot.getRoundNum()>=bot.getNumRounds()/5 && bot.getOthers()>=2){		//melee and round>10.get new match.
			m = this.getMatch();
		}//end if
		if(m==0){
			this.predictionGun();
		}else if(m==1){
			this.directionGun();
		}else if(m==2){
			this.fixlinearGun();
		}
		this.shootTarget();
	}//end
	
	private double getFirePower(){						//set the fire power energy.
		return Math.min(Math.min(en.energy/4,bot.getEnergy()/2),3);
	}//end
	
	private int getMatch(){
		//return en.score[0]>=en.score[1] ? 0 : 1;
		double tmp = Math.max(en.score[0],Math.max(en.score[1],en.score[2]));
		if(tmp==en.score[0]){
			return 0;
		}else if(tmp==en.score[1]){
			return 1;
		}else if(tmp==en.score[2]){
			return 2;
		}else{
			return 2;
		}
	}//end
	
	private void predictionGun(){						//prediction the linear angle.
		double utime = Math.sin(en.headingRadians - en.absoluteBearingRadians) / (20 - 3 * firePower);
		double linear = Math.asin(en.velocity[en.n] * utime);
		bot.setTurnGunRightRadians(Util.getRelativeRadians(en.absoluteBearingRadians - bot.getGunHeadingRadians() + linear));
	}//end
	
	private void directionGun(){
		bot.setTurnGunRightRadians(Util.getRelativeRadians(en.absoluteBearingRadians - bot.getGunHeadingRadians()));
	}//end
	
	private void fixlinearGun(){
		double fix = en.distance * Math.abs(en.velocity[en.n]) / 300;
		double linear = Math.asin(en.velocity[en.n] * Math.sin(en.headingRadians - en.absoluteBearingRadians)/(20-3*firePower+fix));
		bot.setTurnGunRightRadians(Util.getRelativeRadians(en.absoluteBearingRadians - bot.getGunHeadingRadians() + linear));
	}//end
	
	private void shootTarget(){
		if(bot.getGunHeat()==0 && bot.getOthers()>0){
			if(bot.getEnergy()>3){
				bot.setFire(firePower);
			}else if(((bot.getEnergy() - firePower)>en.energy) && bot.getEnergy()>0.1){
				bot.setFire(firePower);
			}//end if
			//Util.out(en.name+" match[0]="+en.score[0]+" match[1]="+en.score[1],bot);		//debug match.
		}//end if
	}//end
}