package sgp;
import robocode.*;
import java.util.*;

/**
 * Intercept - a class by Simon Parker
 */

public class Intercept
{
	public Coordinate impactPoint = new Coordinate(0,0);
	public double bulletHeading_deg;

	protected Coordinate bulletStartingPoint = new Coordinate();
	protected Coordinate targetStartingPoint = new Coordinate();
	public double targetHeading;
	public double targetVelocity;
	public double bulletPower;
	public double angleThreshold;
	public double distance;

	protected double impactTime;


	public void calculate
		(
			double xb,
			double yb,
			double xt,
			double yt,
			double tHeading,
			double vt,
			double bPower,
			double angularVelocity_deg_per_sec
		)
	{
		bulletStartingPoint.x = xb;
		bulletStartingPoint.y = yb;
		targetStartingPoint.x = xt;
		targetStartingPoint.y = yt;

		targetHeading = tHeading;
		targetVelocity = vt;
		bulletPower = bPower;
		double vb = 20-3*bulletPower;

		double dX = xt - xb;
		double dY = yt - yb;
		double r = Math.sqrt(dX*dX + dY*dY);
		double K = vt/vb*(dX*Math.cos(Math.toRadians(targetHeading)) - dY*Math.sin(Math.toRadians(targetHeading)));
		bulletHeading_deg = 180.0 - (Math.toRadians(Math.asin(K/r)) ) - (Math.toRadians(Math.atan2(dX,-dY)));

		double A = vb*Math.cos(Math.toRadians(bulletHeading_deg)) - vt*Math.cos(Math.toRadians(targetHeading));
		double B = vb*Math.sin(Math.toRadians(bulletHeading_deg)) - vt*Math.sin(Math.toRadians(targetHeading));
		impactTime = (dY*A+dX*B)/(A*A+B*B);

		impactPoint.x = xb + vb*Math.sin(Math.toRadians(bulletHeading_deg))*impactTime;
		impactPoint.y = yb + vb*Math.cos(Math.toRadians(bulletHeading_deg))*impactTime;

		distance = Math.sqrt(dX*dX+dY*dY);
		angleThreshold = Math.toDegrees(Math.atan(MadHatter.ROBOT_RADIUS/distance));

	}
}

