// MirrorMicro
// codesize 746
package stelo;
import robocode.*;
//import java.awt.Color;
import robocode.util.Utils;
import java.util.*;
import java.awt.geom.*;

// mirror movement
public class MirrorMicro extends AdvancedRobot
{
	double centerX, centerY;

	Point2D robotLocation;
    Point2D enemyLocation;
    double enemyDistance;
    double enemyAbsoluteBearing;
    double movementLateralAngle = 0.2;

	double lastEnemyAbsoluteBearing;
	double lastEnemyHeading;
	
    static double MAX_VELOCITY = 8;
		
	/**
	 * run: Mirror's default behavior
	 */
	public void run() {
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		//setColors(Color.red,Color.blue,Color.green);
		centerX = getBattleFieldWidth() / 2.0;
		centerY = getBattleFieldHeight() / 2.0;
		
		while(true) {
            turnRadarRightRadians(Double.POSITIVE_INFINITY); 
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
        robotLocation = new Point2D.Double(getX(), getY());
        enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();
        enemyLocation = vectorToLocation(enemyAbsoluteBearing, enemyDistance, robotLocation);
		
		attack(e);
		move(e);
		
        setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getRadarHeadingRadians()) * 2);
		lastEnemyAbsoluteBearing = enemyAbsoluteBearing;
	}
	
	void move(ScannedRobotEvent e) {
		// setTurnRightRadians(Utils.normalRelativeAngle(e.getHeadingRadians() + Math.PI / 2.0 - getHeadingRadians()));
		if (getOthers() == 1)
			goTo(new Point2D.Double(2.0 * centerX - enemyLocation.getX(), 2.0 * centerY - enemyLocation.getY()));
		else
			goTo(new Point2D.Double(3.0 * centerX - 2.0 * enemyLocation.getX(), 3.0 * centerY - 2.0 * enemyLocation.getY()));
	}
	
	void attack(ScannedRobotEvent e) {
		double bulletPower = 1.8;
		if (e.getEnergy() > getEnergy()) bulletPower = 1.0;
		if (getOthers() > 8) bulletPower = 3.0;
		
		if (e.getDistance() < 200 || e.getVelocity() == 0) bulletPower = 3;
				
		double w = e.getHeadingRadians() - lastEnemyHeading;
		
		bulletPower = Math.min(bulletPower, e.getEnergy() / 4);
		bulletPower = Math.min(bulletPower, getEnergy() - 2);
		
		lastEnemyHeading = e.getHeadingRadians();
				
		if (bulletPower < getEnergy()) {
			//fire(bulletPower); // to use FiringAssistance, fire before move!
			
			//if (w == 0) {
			//	linearTarget(bulletPower, e);
			//}
			//else {
				circularTarget(bulletPower, e, w);
			//}
			//headOnTarget(e);
			fire(bulletPower);
		}
					
	}
	
	/*
	private void headOnTarget(ScannedRobotEvent e) {
		setTurnGunRightRadians(Utils.normalRelativeAngle(e.getBearingRadians() + getHeadingRadians() - getGunHeadingRadians()));
	}*/
	
	private void circularTarget(double bulletPower, ScannedRobotEvent e, double w) {
		double absbearing = e.getBearingRadians() + getHeadingRadians();
		double eX = e.getDistance()*Math.sin(absbearing);
		double eY = e.getDistance()*Math.cos(absbearing);

		double db = 0;
		double ww = e.getHeadingRadians();  // enemy's starting heading
			
		do
		{
			// db+=11; //11 is the velocity of a fire(3) bullet.
			db += (20.0 - 3.0 * bulletPower);
			double dx=e.getVelocity()*Math.sin(ww);
			double dy=e.getVelocity()*Math.cos(ww);
			ww+=w;  // turn w radians for next step
				
			eX+=dx;
			eY+=dy;
		}while (db< Point2D.distance(0,0,eX,eY));	// The bullet travelled far enough to hit our target!
		
		setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(eX, eY) - getGunHeadingRadians())) );			
	}
	/*			
	private void linearTarget(double bulletPower, ScannedRobotEvent e) {
		double myX = getX();
		double myY = getY();
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyVelocity = e.getVelocity();
		
		
		double deltaTime = 0;
		double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
		double predictedX = enemyX, predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;	
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			if(	predictedX < 18.0 
				|| predictedY < 18.0
				|| predictedX > battleFieldWidth - 18.0
				|| predictedY > battleFieldHeight - 18.0){
				predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
				break;
			}
		}
		double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
		
		setTurnGunRightRadians( Utils.normalRelativeAngle(theta - getGunHeadingRadians() ) );
	}
	*/
    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }
	
    void goTo(Point2D destination) {
		destination.setLocation(limit(25.0, destination.getX(), getBattleFieldWidth() - 25.0), limit(25.0, destination.getY(), getBattleFieldHeight() - 25.0));
        double angle = Utils.normalRelativeAngle(absoluteBearing(robotLocation, destination) - getHeadingRadians());
		double turnAngle = Math.atan(Math.tan(angle));
        setTurnRightRadians(turnAngle);
        setAhead(robotLocation.distance(destination) * (angle == turnAngle ? 1 : -1));
		// Hit the brake pedal hard if we need to turn sharply
		setMaxVelocity(Math.abs(getTurnRemaining()) > 30 ? 0 : MAX_VELOCITY);
    }

   static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
		return vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length,
            sourceLocation.getY() + Math.cos(angle) * length);
		return targetLocation;
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
/*
	public void onHitWall(HitWallEvent e) {
		out.println("Hit wall");
	}
	*/

	public void onHitByBullet(HitByBulletEvent e) {
		if (getOthers() > 1)
			turnRadarRightRadians(Utils.normalRelativeAngle(e.getBearingRadians() + getHeadingRadians() - getRadarHeadingRadians()));
	}
}
					