package djc.gun;

import djc.*;
import djc.util.*;

import java.awt.*;
import java.util.*;
import robocode.*;
import robocode.util.*;

/**
 * Base Gun Class; fires right at the current Enemy
 */
public class BaseGun
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */	
    public static final double FIREANGLE_THRESHHOLD_DEGREES = 3.0;
	
	public String name;
	public static AbstractDynaBot myrobot = null;
	public int gunID;
	
	public BaseGun(AbstractDynaBot themyrobot) {
		myrobot = themyrobot;
		name = "HEADONGUN";
		gunID = DynaBotConstants.HEADONGUN;
	}

	/**
	 * Returns this gun's fitness for the current target
	 * or if not enough data are available, its global fitness
	 */
	public double gunFitness() {
		return gunFitnessCurrentTarget();
	} 

	protected double gunFitnessCurrentTarget() {
		int iShotsFired = myrobot.theEnemyManager.getShotsFired(gunID);
		double hitRate = myrobot.theEnemyManager.getHitRate(gunID);
		double vHitRateRolling = myrobot.theEnemyManager.getVirtualHitRateRolling(gunID);
		double vHitRate = myrobot.theEnemyManager.getVirtualHitRate(gunID);
		// myrobot.out.println("For " + name + "hitRate " + hitRate + " Rolling: " + vHitRateRolling + " vHitRate " + vHitRate);
		if(iShotsFired < DynaBotConstants.MIN_NUM_SHOT) {
			return (vHitRateRolling + vHitRate) / 2.0;
		} else {
			return (2.0 * hitRate + vHitRateRolling + vHitRate) / 4.0;
		}
	}

	public void doWork() {
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		boolean bSwingGun = false;
		if(myrobot.theEnemyManager.currentEnemy == null) bSwingGun = false;
		else {
			if(e.getName() == myrobot.theEnemyManager.currentEnemy.name) bSwingGun = true;
		}
		if(bSwingGun) {
			doScannedCurrentEnemy(e);
		}
	}

	public double calcGunTurnRadians(Enemy e) {
		return e.absBearing;
	}

	public void doScannedCurrentEnemy(ScannedRobotEvent e) {
		double gunTurnRadians;
		Enemy enemy = (Enemy)myrobot.theEnemyManager.enemyList.get(e.getName());
		//myrobot.out.println("Is: " + e.getBearing() + " i think: " + Math.toDegrees(getGunAbsoluteBearing(enemy)));
		gunTurnRadians = Utils.normalRelativeAngle(calcGunTurnRadians(enemy) - myrobot.getGunHeadingRadians());
		myrobot.setTurnGunRightRadians(gunTurnRadians);
		doFireGun(computeFirePower(e.getDistance(), myrobot.theEnemyManager.currentEnemy));
	}

	protected void doFireGun(double shotPower) {
		if(shotPower < .1) return;
		//if(Math.abs(myrobot.getGunTurnRemainingRadians()) < .01 && myrobot.getGunHeat() == 0) {
		if(Math.abs(myrobot.getGunTurnRemainingRadians()) < getFireAngleTolerance() && myrobot.getGunHeat() == 0) {
			myrobot.doFireGun(shotPower);
		}
	}

    /**
     * Computes the FirePower to use when shooting a target.
     *
     * @author Dan Cieslak
     */
    public double computeFirePower(double targetDist, Enemy e)
    {
		double hitRate = myrobot.theEnemyManager.getHitRate(e.name, myrobot.theGunManager.currentGunIndex);
		if(myrobot.getEnergy() < .5 && e.energy > 0) return 0;                                        // Try not to be suicidal
		if(e.energy < .1) return DynaBotConstants.MIN_SHOT_ENERGY;                                    // Enemy Disabled

		if(targetDist < DynaBotConstants.DIST_CLOSE) 
			return Math.min(myrobot.getEnergy()/2.0,MyUtils.getPowerToKill(e.energy));         // Point Blank
		if(hitRate > .2 && myrobot.getEnergy() > 20) {
			return MyUtils.getPowerToKill(e.energy);  // Above 20%, fire max power for points/energy
		}
				
		if (myrobot.getEnergy() > 30) {
			if(myrobot.getOthers() == 1) {
			    double duelHitRate = myrobot.theEnemyManager.getDuelOpponentHitRate();
				if(hitRate < duelHitRate) return 3.0;                                      // Deny points to opponent
				else {
					if(hitRate > .16) return 3.0;
					else {
						return Math.random() * 2.0;
					}
				}
			} else { // melee - conserve energy
				if(hitRate < .1 && myrobot.getEnergy() > 20) return .5;                                       // Not hitting well 
				if(hitRate < .1 && myrobot.getEnergy() <= 20) return .1;                                      // Not hitting well 
				if(myrobot.getEnergy() <= 15) { 
					Random rdm = new Random();
					if(myrobot.getEnergy() > rdm.nextDouble()) {
						return .1;
					} else {
						return 0.001;
					}
				}
					
		    	if(targetDist < DynaBotConstants.DIST_NEAR) return 3.0;
			    else if (targetDist < DynaBotConstants.DIST_MID) return 2.5;
	    		else if (targetDist < DynaBotConstants.DIST_LONG) return 2.0;
		    	else return .1;
			}
		} else {
			Random rdm = new Random();
			return Math.min(1.0, myrobot.getEnergy() * rdm.nextDouble());
		}
    }

	protected double getFireAngleTolerance() {
		if(myrobot.getOthers() > 1) {
			return Math.atan2(36 /* BotWidth */ , myrobot.theEnemyManager.currentEnemy.lastDistance);
		} else {
			return Math.toRadians(3.0);
		}
	}

	public void onPaint(Graphics2D g) {
	}
		
}
