package djc.movement;

import djc.*;
import djc.util.*;

import java.util.*;
import java.awt.geom.*;

import robocode.*;
import robocode.util.*;

/**
 * Movement based on kawigi.mini.Coriantumr
 *
 * From:
 *    http://www.robocoderepository.com/BotDetail.jsp?id=1988
 */
public class CoriantumrMovement extends BaseMovement
{
	Point2D.Double next;
	Point2D.Double last;
		
	public CoriantumrMovement(AbstractDynaBot themyrobot) {
		super(themyrobot);
				
		name = "CORIANTUMR";
		movementID = DynaBotConstants.CORIANTUMR;
	}

	public void reset() {
		next = null;
		last = null;
	}

	/**
	 * what to do each tick
	 */
	public void doWork() {
		if (myrobot.theEnemyManager.currentEnemy == null) {
			return ;
		}
		if (next == null) {
			next = last = myrobot.location;
		}
	
		if (next.distance(myrobot.location) < 15 || myrobot.getOthers() > 1) {
			boolean changed = false;
			double angle = 0;
			double moveDist = myrobot.location.distance(myrobot.theEnemyManager.currentEnemy.location);
			moveDist = (myrobot.getOthers() == 1 ? Math.random()*moveDist : Math.min(500, moveDist))*.5;
			//sometimes I'll change my point here, sometimes I won't.  It's a big mystery!
			do {
				Point2D.Double p;
				if (myrobot.theBattleManager.inFieldRect.contains(p = MyUtils.project(myrobot.location, angle, moveDist)) 
						&& findRisk(p) < findRisk(next)) {
					changed = true;
					next = p;
				}
				angle += .1;
			} while (angle < Math.PI*2);
			//this helps the whole movement system know what direction I'm going, and avoid head-on targeting:
			if (changed) {
				last = myrobot.location;
			}
		}
		//Thanks, David, for a quick way of doing this:
		double a1, a2;
		myrobot.setTurnRightRadians(a1 = Math.atan(Math.tan(a2 = robocode.util.Utils.normalRelativeAngle(angle(next, myrobot.location) - myrobot.getHeadingRadians()))));
		myrobot.setAhead(Math.abs(myrobot.getTurnRemainingRadians()) > 1 ? 0 : (a1 == a2 ? 1.0 : -1.0) * next.distance(myrobot.location));
	}

	protected double findRisk(Point2D.Double point)
	{
		double risk = 0;
		Collection enemySet;
		Iterator it = (enemySet = myrobot.theEnemyManager.enemyList.values()).iterator();
		do {
			Enemy e = (Enemy)it.next();
			//start with an anti-gravity-type value:
			double thisrisk = (e.energy+50)/point.distanceSq(e.location);
			//woah, nested iterations!  Here, I'm counting the enemies that are closer to e than the proposed point is.
			//The more, the better, since this robot would be less likely to target me.
			int closer = 0;
			Iterator it2 = enemySet.iterator();
			do {
				Enemy e2 = (Enemy)it2.next();
				if (e.location.distance(e2.location)*.9 > e.location.distance(point))
					closer++;
			} while (it2.hasNext());
			//try this, multiply this number by the number of enemies to which I would be the closest:
			//if they are likely targeting me, multiply by some factor that has to do with "perpendicularity"
			//(I think I remember David Alves calling it that):
			if (closer <= 1 || e.lastHitMe > myrobot.getTime()-200 || e == myrobot.theEnemyManager.currentEnemy)
			{
				//I had to think about this one, but I think DuelistMicroMelee helped me make sure that it was correct.  I can't remember anymore.
				thisrisk *= 2+2*Math.abs(Math.cos(angle(myrobot.location, point) - angle(e.location, myrobot.location)));
			}
			//don't run into people!  (This is a guess of whether someone is between me and p)
			//I suppose this deserves an explanation.  I'm figuring that if to 36x36 squares will hit each other moving
			//along a certain vector (my vector, and I assume they'll be in roughly the same place), then a line
			//representing the vector will intersect a 72x72 square centered in the same place.
			//if (new Line2D.Double(myLocation, point).intersects(new Rectangle2D.Double(e.x-36, e.y-36, 72, 72)))
			//	thisrisk *= 4;
			risk += thisrisk;
		} while (it.hasNext());
		//add a small antigravity value to the point I was at before now, just to kind of push me in straight
		//lines (this made me too hitable in one-on-one, though):
		if (myrobot.getOthers() > 1) {
			risk += Math.random()/last.distanceSq(point);
		}
		//and repel my current location, to make it more likely that I change my mind before I get to my assigned
		//point (and less likely to change my mind right away maybe):
		risk += Math.random()/5/myrobot.location.distanceSq(point);
		return risk;
	}

	//This strange habit of putting point2 before point1 in this method - and the funny thing is I think
	//I've seen other people do the same thing:
	protected double angle(Point2D.Double point2, Point2D.Double point1)
	{
		return Math.atan2(point2.getX()-point1.getX(), point2.getY()-point1.getY());
	}

}
