package djc.movement;

import djc.*;
import djc.util.*;

import robocode.*;
import robocode.util.*;

/**
 * SandBoxMini Movement; based on:
 *
 *    http://robowiki.net/cgi-bin/robowiki?SandboxMini
 */
public class SandboxMiniMovement extends BaseMovement
{
	static double direction;			//direction we are heading...0 = forward, 1 = backwards
	static double nextTurn;				//the time we will select another co-ordinate to move to
	static double nextX;				//co-ordinates of where we are moving to at the moment
	static double nextY;
			
	public SandboxMiniMovement(AbstractDynaBot themyrobot) {
		super(themyrobot);
				
		name = "SANDBOXMINI";
		movementID = DynaBotConstants.SANDBOXMINI;
	}

	public void reset() {
		direction  = 0;
		nextTurn = 0;
		nextY = 0;
		nextX = 0;
	}

	/**
	 * what to do each tick
	 */
	public void doWork() {
		if(myrobot.theEnemyManager.currentEnemy == null) {
			//myrobot.out.println("No enemy; no movement");
			return;
		}
		
		if(myrobot.getTime()>=nextTurn) {	//has the time come to set new nextX and nextY co-ordinates
			nextTurn = myrobot.getTime() + myrobot.theEnemyManager.currentEnemy.lastDistance/16.5;		//bullets travel at between 11 and 19.7 units per tick - set new nextX,Y co-ordinates a little before a 3.0 bullet would reach us
			double distFactor = Math.random();				//distance factor is roughly how far to travel until nextTurn (1.0 a long way, 0.0 nowhere)
			double adjustInOut = -(myrobot.theEnemyManager.currentEnemy.lastDistance-400)/200.0*Math.PI/4;  //negative -get nearer the opponent, +ve further away
			double angleAwayFromTarget = (Math.PI/2.0 + adjustInOut) * (Math.rint(Math.random())*2.0 - 1.0);		//basically move at 90 degrees to the opponent, adjust if we are too far or too near the opponent - and choose either clockwise or anticlockwise at random.
			nextX=myrobot.getX() + Math.sin(myrobot.theEnemyManager.currentEnemy.absBearing+angleAwayFromTarget) * myrobot.theEnemyManager.currentEnemy.lastDistance*0.88*distFactor;		//in the time allocated we could travel a maximum of around 0.8 times the distance to the enemy
			nextY=myrobot.getY() + Math.cos(myrobot.theEnemyManager.currentEnemy.absBearing+angleAwayFromTarget) * myrobot.theEnemyManager.currentEnemy.lastDistance*0.88*distFactor;
			nextX=MyUtils.maxMin(myrobot.getBattleFieldWidth()-50,50,nextX)*2.0 - nextX;	//we don't want to crash into walls so if our co-ordinates cross a 50 unit margin inside the walls - reflect the co-ordinate about the margin line
			nextY=MyUtils.maxMin(myrobot.getBattleFieldHeight()-50, 50,nextY)*2.0 - nextY;
		}
		
		double reqOffset = Utils.normalRelativeAngle(MyUtils.absBearing(myrobot.getX(),myrobot.getY(),nextX,nextY)
											+direction*Math.PI - myrobot.getHeadingRadians());  //calculate the change of angle required to get to the target co-ordianates
		if (Math.abs(reqOffset) > Math.PI/2) {  //if it is more than 180 degrees
			reqOffset += Math.PI;				//add 180 degrees to the offset
			if (direction == 1) direction=0; else direction=1;  //and change the direction.
		}
		myrobot.setTurnRightRadians(Utils.normalRelativeAngle(reqOffset));
		double distToGo=MyUtils.getRange(myrobot.getX(),myrobot.getY(),nextX,nextY);	//calculate how far to out target point
		myrobot.setAhead((-2.0*direction+1.0)*distToGo);				//tell the engine the distance (it will do all the speed calcs to stop on the point)
		if(Math.abs(myrobot.getTurnRemaining()) > 65) myrobot.setAhead(0);  	// if we need to turn sharply slow down/stop for a faster, tighter turn (note using degrees here)
		
		if (Math.abs(distToGo) < 5.0) {		//to ensure we do not wobble and spin over the target point - be stationary if within 5 units of the point
			myrobot.setAhead(0.0);
			myrobot.setTurnRightRadians(0.0);
		}
	}
	
}
