package djc.radar;

import djc.*;
//import djc.util.MyUtils;
import java.util.*;
import robocode.*;
import robocode.util.Utils;

/**
 * Melee Radar from tzu.TheArtOfWar
 *
 * Modified slightly to fit my bot-framework
 */
public class TheArtOfWarRadar extends BaseRadar
{
	int      direction        = 1;
	String   scannedBots      = null;
	int      scanCount        = 0;
	
	public TheArtOfWarRadar(AbstractDynaBot themyrobot) {
		super(themyrobot);
		name = "THEARTOFWAR_RADAR";
	}
	
	public void reset() {
		scannedBots = null;
		scanCount   = 0;
	}
	
	public void doWork() {
		if(myrobot.getRadarTurnRemaining() == 0.0) {
			myrobot.setTurnRadarRight(360.0 * direction);
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent event) {
		String scannedName = event.getName();
		if(scannedBots == null) {
			scannedBots = scannedName;
			scanCount++;
		} else {
			if(scannedBots.indexOf(scannedName) == -1) {
				scanCount++;
				scannedBots += scannedName;
			}
			if(scanCount >= myrobot.getOthers()) {
				scannedBots = scannedName;
				scanCount = 1;
				direction *= -1;
				myrobot.setTurnRadarRight(22.5);
			}
		}
	}

}
