package Krabb.sliNk;
import Krabb.*;
import robocode.*;
import robocode.util.Utils;
import java.io.*;
import java.awt.*;
import java.awt.geom.Point2D;
import java.util.*;

public class Stats implements Serializable
{
	String name;
	public long t;
	double eg; //Energy
	double deg; //Energy diff
	double x,y;
	double v;
	double b;			//Enemy bearing (not relative to my heading)
	double d;
	double h;
	boolean wh=false; //wall hit
	boolean alive=true;
	Stats()
	{
	}
	
	//Enemy
	Stats(ScannedRobotEvent e, Data r, Stats ls)
	{
		eg=e.getEnergy();
		if(ls!=null)
			deg=eg-ls.getEnergy();
		t=r.getTime();
		name=e.getName();
		b = r.getHeadingRadians()+e.getBearingRadians();
		d = e.getDistance();
		y=r.getY()+Math.cos(b)*d;
		x=r.getX()+Math.sin(b)*d;
		v=e.getVelocity();
		h=e.getHeadingRadians();
	}
	
	//Mate
	Stats(AdvancedRobot r, Stats ls)
	{
		eg=r.getEnergy();
		if(ls!=null)
			deg=eg-ls.getEnergy();
		t=r.getTime();
		name=r.getName();
//		b = r.getHeadingRadians()+e.getBearingRadians();
//		d = e.getDistance();
		y=r.getY();
		x=r.getX();
		v=r.getVelocity();
		h=r.getHeadingRadians();
	}
	
	public void onPaint(java.awt.Graphics2D g)
	{
		if(alive)
			onPaint(g,Color.red);
		else
			onPaint(g,Color.green);
	}
	
	public void onPaint(java.awt.Graphics2D g, Color c)
	{
		g.setColor(c);
		g.fillOval((int)x-3,(int)y-3,7,7);
//		g.drawRect((int)x-16,(int)(y-16), 32, 32);
	}
		
	public String getName(){
		return name;}
	public long getT(){
		return t;}
	public double getX(){
		return x;}
	public double getY(){
		return y;}
	public double getV(){
		return v;}
	public double getH(){
		return h;}
	public double getEnergy(){
		return eg;}
	public double getE(){
		return eg;}
	public double getDEnergy(){
		return deg;}
	public double getB(AdvancedRobot r){
		double dx = getX()-r.getX();
		double dy = getY()-r.getY();
		return Math.atan2(dx,dy);}
	public double getB(Stats r){
		double dx = getX()-r.getX();
		double dy = getY()-r.getY();
		return Math.atan2(dx,dy);}
	public double getDistance(Stats s){
		double dx = getX()-s.getX();
		double dy = getY()-s.getY();
		return Math.sqrt(dx*dx+dy*dy);}
	public double getDistance(double x, double y){
		double dx = getX()-x;
		double dy = getY()-y;
		return Math.sqrt(dx*dx+dy*dy);}
	public double getDistance(MyBullet b){
		double dt=t-b.t;
		double dx = getX()-(b.getX()+Math.sin(b.getH())*b.getV()*dt);
		double dy = getY()-(b.getY()+Math.cos(b.getH())*b.getV()*dt);
		return Math.sqrt(dx*dx+dy*dy);}
	public double getAlpha(Stats s){
		double dx = getX()-s.getX();
		double dy = getY()-s.getY();
		return Math.atan2(dx,dy)+Math.PI;}
	public double getAlpha(double x, double y){
		double dx = getX()-x;
		double dy = getY()-y;
		return Math.atan2(dx,dy)+Math.PI;}
	}		

class LStats
{
	private LStats next=null;
	private Stats s;
	LStats(Stats s)
	{
		this.s=s;
	} 
	
	LStats(ScannedRobotEvent e, Data r, Stats ls)
	{
		s=new Stats(e,r,ls);
	}
	
	LStats(AdvancedRobot r, Stats ls)
	{
		s=new Stats(r,ls);
	}
	
	public void onPaint(java.awt.Graphics2D g)
	{
		if(next!=null && next.getStats().getEnergy()-s.getEnergy()>0)
			s.onPaint(g,Color.red);
		else
			s.onPaint(g,Color.green);
		if(next!=null)
			next.onPaint(g);
		if(next!=null && next.getStats().getEnergy()-s.getEnergy()>0)
			next.getStats().onPaint(g,Color.orange);
	}
			
	public LStats newChangeStats(Stats s)
	{
		//Wenn gleiche Zeit, nicht einfgern
		if(s.t==this.s.t)
			return this;
		//Wenn Zeit des neuen Eintrags > diese Zeit: fge vor diesem ein
		else if(s.t>this.s.t)
		{
			LStats ls = new LStats(s);
			//Wenn di8es der erste Eintrag ist, oder ein Energiechange zwischen dem jetzigem und dem letztem 
			// oder dem neuem und dem jetzigem gegeben hat setze den neuen Eintrag vor diese
			if(next==null || (next.getStats().getEnergy()-this.s.getEnergy()>=0.1 && next.getStats().getEnergy()-this.s.getEnergy()<=3)
			|| (this.s.getEnergy()-s.getEnergy()>=0.1 && this.s.getEnergy()-s.getEnergy()<=3))
				ls.setNext(this);
			//Wenn kein change statgefunden hat
			else
				ls.setNext(next);
			return ls;				
		}
		//Wenn neue Zeit < diese Zeit fge hinter diesem ein
		else
			return next.newChangeStats(s);		
	}
	
	public LStats newStats(Stats s)
	{
		//Wenn gleiche Zeit, nicht einfgern
		if(s.t==this.s.t)
			return this;
		//Wenn Zeit des neuen Eintrags > diese Zeit: fge vor diesem ein
		else if(s.t>this.s.t)
		{
			LStats ls = new LStats(s);
			ls.setNext(this);
			return ls;				
		}
		//Wenn neue Zeit < diese Zeit fge hinter diesem ein
		else
			return next.newStats(s);		
	}
		
	public void setNext(LStats s){
		next = s;}
	public LStats getNext(){
		return next;}
	public Stats getStats(long n, long i){
		if(i==n || next==null)
			return s;
		return next.getStats(n,++i);}
	public Stats getTimeStats(long t){
		if(next==null || s.t<t)
			return s;
		return next.getTimeStats(t);}
	public LStats getTimeLStats(long t){
		if(next==null || s.t<t)
			return this;
		return next.getTimeLStats(t);}
	public Stats getStats(){
		return s;}
}

class MyOwnBullet extends MyBullet
{
	public Bullet b;
	MyOwnBullet(Bullet b, Data r)
	{
		this.b=b;
		init(b,r);
	}
}


class MyBullet implements Serializable
{
	private double x,y;
	private String name;
	private double h;
	private double p;
	public long t;
	public boolean hit=false;
//	private Bullet b;
	
	MyBullet()
	{}
		
	MyBullet(MyOwnBullet b)
	{
		t=b.t;
		name=b.getName();
//		this.b = b;
		x=b.getX();
		y=b.getY();
		h=b.getH();
		p=b.getP();	
		hit=b.hit;
	}
				
	MyBullet(Bullet b, Data r)	
	{
		init(b,r);
//		System.out.println("bla");
	}
	
	protected void init(Bullet b, Data r)
	{
		t=r.getTime();
		name=b.getName();
//		this.b = b;
		x=r.getX();
		y=r.getY();
		h=b.getHeadingRadians();
		p=b.getPower();	
	}
		
	public boolean test(AdvancedRobot r) 
	{
		double nx=x+Math.sin(h)*getV()*(r.getTime()-t);
		double ny=y+Math.cos(h)*getV()*(r.getTime()-t);
		return (nx < 0 || nx > r.getBattleFieldWidth() || ny < 0 || ny > r.getBattleFieldHeight()) ;
	}
	
	public double getX(){
		return x;}
	public double getY(){
		return y;}
	public double getH(){
		return h;}
	public double getHeading(){
		return h;}
	public double getP(){
		return p;}
	public double getV(){
		return 20-3*p;}
	public String getName(){
		return name;} 
}

class HitPar implements Serializable
{
	public String name;
	public double d;
	public double p;
	public double v;
	public int hx,hy; //hitx ,y 
	public long st,ht;//shot time, hit time
	Stats mstart;	//Stats des getroffenem (zur abschusszeit)
	Stats estart;	//Stats des abfeuerndem
	Stats mhit;		//Stats des getroffenem (zur hit Zeit)
	//his hit par
	HitPar(Data r, Enemy e, HitByBulletEvent ev)
	{
		ht=r.getTime();
		p=ev.getPower();
		v=20-3*p;
		LStats ls = e.getLStats();
		Stats s = ls.getStats();
		Stats lasts = s;
		name=ev.getName();	
		Mate m = r.getMate(r.getName());
		mhit = m.getFirstStats();
		d=0;
		double dp,ldp=9999,v,np; //delta p, lastdp, velocity, new p;
		long dt;
		st=r.getTime(); 
		Bullet b=ev.getBullet();
		//Abschusspunkt berechnen (es wird davon ausgegangen, dass die power zwischen den stats linear veluft) 
		for(int i=0; true; i++)
		{
//			s=s.getStats(i);
			hx=(int)b.getX();
			hy=(int)b.getY();
			d=s.getDistance(hx,hy);
			dt=st-s.getT();
			v=d/dt;
			np=20./3.-v/3.;
			dp=p-np;
//			System.out.println("dp: "+dp);
			if(dp<0)
			{
				double l = s.getDistance(lasts)*ldp/(ldp-dp);	//Lengt
				Global.x1=(int)(lasts.getX()+Math.sin(lasts.getAlpha(s))*l);
				Global.y1=(int)(lasts.getY()+Math.cos(lasts.getAlpha(s))*l);		
				estart=lasts;
				mstart=m.getTimeStats(estart.getT());
				d=mstart.getDistance(estart);
				break;
			}
			ldp=dp;
			lasts=s;
			ls=ls.getNext();
			s=ls.getStats();
		}
		Global.x2=(int)mstart.getX();
		Global.y2=(int)mstart.getY();		
	}
}

/* to do:
botwidth bei hit berksichtigen
*/
class MovementGFStats
{
	int nfactors=37;
	int nlv=5;
	int ndist=4;
	int np=8;
//	int shots[][][] = new int[nlv][ndist][np];
	double gf[][][][] = new double[nlv][ndist][np][nfactors];
	
	public void checkHits(Enemy e, Stats es, Mate me)
	{
		LStats ml=me.getLStats();
		if(ml==null)
			return;
		Stats ms;
		double d,v,p;
		while(true)
		{
			ms=ml.getStats();
			d=es.getDistance(ms);
			v=d/(double)(es.t-ms.t);
			p=(20.-v)/3.;
			if(p>3.)
				break;
			if(p>0.1)
			{
				//zwischen virtual und real shot unterscheiden
				newHit(es,e.getTimeStats(ms.t),ms,p,false);
			}
			if(ml.getNext()==null)
				break;	
			ml=ml.getNext();
		}
	}
	
	private void newHit(Stats es, Stats estarts, Stats ms, double bp, boolean reals)
	{
		if(estarts==null)
			return;
		double d=ms.getDistance(estarts);
		double v=20-3*bp;
		double amax=Math.asin(8/v);
		double a=ms.getAlpha(es)-ms.getAlpha(estarts);
//		int n = (int)((Math.max(-1,Math.min(1,a/amax))+1)/2.*(nfactors-1));
		double abotwidth = 18./ms.getDistance(es);
		int ns = MyUtils.getBin((a-abotwidth)/amax,-1,1,nfactors);
		int ne = MyUtils.getBin((a+abotwidth)/amax,-1,1,nfactors);
		if(ns>ne)
			System.out.println("auasdadiwdi");
		if(ns<0 || ne>nfactors-1)
		{
			System.out.println("Error in class MovementGFStats newHit(Stats es, Stats estarts, Stats ms, double bp, boolean reals)");
			System.out.println("gf: "+a/amax);
			System.out.println("gf: "+(a-abotwidth)/amax);
			System.out.println("gf: "+(a+abotwidth)/amax);
			System.out.println("power: "+bp);
			return;
		}
//		int ns = (int)((Math.max(-1,Math.min(1,(a-abotwidth)/amax))+1)/2.*(nfactors-1));
//		int ne = (int)((Math.max(-1,Math.min(1,(a+abotwidth)/amax))+1)/2.*(nfactors-1));
		double a2 = ms.getAlpha(estarts)-estarts.getH();
		int lv = MyUtils.getBin(Math.sin(a2)*estarts.getV(), -8, 8, nlv);
		int dist = MyUtils.getBin(estarts.getDistance(ms),0,Global.maxdist,ndist);
		int pow = MyUtils.getBin(bp,0.1,3,np);
		for(int i=ns; i<ne; i++)
		{
			if(i>=ns && i<=ne)	//hit
				gf[lv][dist][pow][i]=MyUtils.rollingAvg(gf[lv][dist][pow][i],1.,100.,1.);
			else				//miss
				gf[lv][dist][pow][i]=MyUtils.rollingAvg(gf[lv][dist][pow][i],0.,100.,1.);
		}
//		shots[lv][dist][pow]++;
	}
	
	public double getBestGF(Stats estart, Stats mstart, double bp)
	{
		double[] bins = getBins(estart,mstart,bp);
		double bestp=0;
		int best=-1;
		for(int i=0; i<nfactors; i++)
		{
			if(bins[i]>=bestp) // >
			{
				bestp=bins[i];
				best=i;
			}			
		}
		if(best==-1)
		{
			System.out.println("auiwdi");
			best=0;
		}
		return ((best*2./(double)nfactors-1.)+((best+1)*2./(double)nfactors-1.))/2.;
	}
	
	public double[] getBins(Stats estart, Stats mstart, double bp)
	{
		double a2 = mstart.getAlpha(estart)-estart.getH();
		int lv = MyUtils.getBin(Math.sin(a2)*estart.getV(), -8, 8, nlv);
		int dist = MyUtils.getBin(estart.getDistance(mstart),0,Global.maxdist,ndist);
		int pow = MyUtils.getBin(bp,0.1,3,np);
		return gf[lv][dist][pow];
	}
	
	public void onPaint(Data r, Enemy e, java.awt.Graphics2D g)
	{
		if(e.stats==null || (r.getTeammates()!=null && !e.getStats(0).getName().contains("(1)")))
			return;
		for(int i=0; i<nfactors; i++)
		for(int k=0; k<ndist; k++)
		for(int l=0; l<1.0; l++)
		for(int j=0; j<nlv; j++)
		{
//			if(shots[j][k][l]==0)
//				continue;
			g.fillRect(60+80*j+3*i,50+100*k,3,2+(int)(100.*gf[j][k][l][i]));///shots[j][k][l]
		}
	}
}

class BulletPStats
{
	int ashots;
	int[] shots;
	int[][] power;
	int ndist=9,npower=6;
	double dmax;
	double pmax=3.1;
	BulletPStats(double bwidth, double bheight)
	{
		dmax=Math.sqrt(bwidth*bwidth+bheight*bheight);
		shots = new int[ndist];
		power = new int[ndist][npower];
		for(int i=0; i<ndist; i++)
		{
			shots[i]=0;
			for(int j=0; j<npower; j++)
				power[i][j]=0;
		}
	}
	
	public void newHit(HitPar par)
	{
		int nd=(int)(par.d/dmax*ndist);
		int np=(int)(par.p/pmax*npower);
		shots[nd]++;
		power[nd][np]++;	
	}
	
	public double getProbability(double d, double p)
	{
		int nd=(int)(d/dmax*ndist);
		int np=(int)(p/pmax*npower);
		if(shots[nd]==0)
			return 0;
		return (double)power[nd][np]/(double)shots[nd];
	}
	
	//not finished
	public double getProbability(double d)
	{
		int nd=(int)(d/dmax*ndist);
		return (double)shots[nd]/(double)ashots;
	}
		
	public void onPaint(Data r, Enemy e, java.awt.Graphics2D g)
	{
		if(e.stats==null || (r.getTeammates()!=null && !e.getStats(0).getName().contains("(1)")))
			return;
		for(int i=0; i<ndist; i++)
		{
			for(int j=0; j<npower; j++)
			{
				g.fillRect(5*j,105*i,5,(shots[i] != 0 ? 100*power[i][j]/shots[i] : 3));
			}
		}
	}
}

class GunGFStats
{
	int nfactors=21;
	int nlv=3;
	int shots[] = new int[nlv];
	int gf[][] = new int[nfactors][nlv];
	
	public void newHit(HitPar par)
	{
/*
		double ft=par.mhit.getDistance(par.estart)/par.v;	//flug zeit
		double smax=ft*9;
		double s=par.mstart.getDistance(par.mhit);
		s*=(Math.sin(par.mstart.getAlpha(par.mhit)-par.mstart.getAlpha(par.estart)));//Math.abs(Math.sin(par.mstart.getAlpha(par.mhit)-par.mstart.getAlpha(par.estart)));
		if(s/smax >=1)
			System.out.println("gf zu gro: "+Math.sin(par.mstart.getAlpha(par.mhit)-par.mstart.getAlpha(par.estart)));
			//xxxxx gf zu gro, wie mglich?
			*/
		double d=par.estart.getDistance(par.mstart);
//		double ft=d/par.v;	//flug zeit
		double amax=Math.asin(8/par.v);
		double a=par.estart.getAlpha(par.hx,par.hy)-par.estart.getAlpha(par.mstart);
		int n = (int)((Math.max(-1,Math.min(1,a/amax))+1)/2.*(nfactors-1));
		double a2 = par.estart.getAlpha(par.mstart)-par.mstart.getH();
		int lv = MyUtils.getBin(Math.sin(a2)*par.mstart.getV(), -8, 8, nlv);
//		int lv = (int)((0.5+(Math.sin(a2)*par.mstart.getV()/16.))*nlv);
		gf[n][lv]++;
		shots[lv]++;
	}
	
	public double getChance(Stats mstart, Stats mhit, Stats estart)
	{
		double d=estart.getDistance(mstart);
//		double ft=d/bv;	//flug zeit
		double dmin=mhit.getDistance(estart)-18.;
		double dmax=dmin+36.;
		double bv=d/(mhit.t-estart.t);
		double bvmin=dmin/(mhit.t-estart.t);
		double bvmax=dmax/(mhit.t-estart.t);
		//fr jede bv amax?
		double amax=Math.asin(8/bv);
		double a=estart.getAlpha(mhit)-estart.getAlpha(mstart);
		double a2 = estart.getAlpha(mstart)-mstart.getH();
		double abotwidth = 18./d;
		int lv = MyUtils.getBin(Math.sin(a2)*mstart.getV(), -8, 8, nlv);
//		int lv = (int)((0.5+(Math.sin(a2)*mstart.getV()/16.))*nlv);
		if(shots[lv]==0)
			return 0;
			//xxxxx gf zu gro, wie mglich?
		int ns = (int)((Math.max(-1,Math.min(1,(a-abotwidth)/amax))+1)/2.*(nfactors-1));
		int ne = (int)((Math.max(-1,Math.min(1,(a+abotwidth)/amax))+1)/2.*(nfactors-1));
		double chance=0;
		for(int i=ns; i<ne; i++) 
			chance += gf[i][lv]/(double)shots[lv];
		if(ne-ns>0)
			return chance/(double)(ne-ns);
		else if(ne-ns<0)
		{
			System.out.println("baiuegfasdgpauegfaeugaeufgaioeudf");
			return 0;
		}
		else// if(ne-ns==0)
			return chance;
			
	}
	
	public void onPaint(Data r, Enemy e, java.awt.Graphics2D g)
	{
		if(e.stats==null || (r.getTeammates()!=null && !e.getStats(0).getName().contains("(1)")))
			return;
		for(int i=0; i<nfactors; i++)
		for(int j=0; j<nlv; j++)
		{
			g.fillRect(60+80*j+3*i,50,3,2+(shots[j] != 0 ? 100*gf[i][j]/shots[j] : 3));
		}
	}
}
