package vuen.cfCake;
import vuen.Cake;
import robocode.*;

public class cMovDodge {
	private Cake oRobot = null;
	private cMovControl oMovControl = null;
	private cComControl oComControl = null;
	
	private double mEnergy = -1;
	public boolean mNextReset = false;
	
	double mBiasIncMult = 0;
	
	double CMoveAmt = 60;
	double CSpeedMin = -0.5;
	double CSpeedMax = 8;
	double CSpeedDiv = 200;
	double CSpeedTime = 8;
	double CAngleDiv = 1;
	double CAngleFixMaxLow = 35;
	double CAngleFixMaxHigh = 50;
	double CWallAngleRev = 20;
	//double CDistanceDiffWallRev = 5000;
	//double CAngleDistance = 250;
	double CMinAngleDistance = 150;
	double CLineSpace = 75;
	double mJiggleTime = 0;
	double CJiggleRnd = 30;
	double CJiggleMin = 30;
	double mLastJiggle = 0;
	double mDirection = 1;
	double mSpeedTime = 100;
	double CAngleFixMax = 40;
	double mAngleFix = 0;
	static double[] mJiggleMult = null;
	static double[] mJiggleInc = null;
	static double[] mAngleDistance = null;
	static double[] mDistanceChange = null;
	
	static double CStatLearnTime = 220;
	//static double mStatLastEnergy = 10000;
	//static double mStatThisEnergy = 0;
	//static double mStatTimeLeft = CStatLearnTime;
	static boolean[] mStatMode = null; //false = Jiggle, true = Distance
	static double[] mStatLastEnergy = null;
	static double[] mStatThisEnergy = null;
	static double[] mStatTimeLeft = null;
	
	public cMovDodge(Cake pRobot, cMovControl pMovControl, cComControl pComControl) {
		oRobot = pRobot;
		oMovControl = pMovControl;
		oComControl = pComControl;
		if (oRobot.getRoundNum() == 0) {
			mJiggleMult = new double[oRobot.getOthers()];
			mJiggleInc = new double[oRobot.getOthers()];
			mAngleDistance = new double[oRobot.getOthers()];
			mDistanceChange = new double[oRobot.getOthers()];
			mStatMode = new boolean[oRobot.getOthers()];
			mStatLastEnergy = new double[oRobot.getOthers()];
			mStatThisEnergy = new double[oRobot.getOthers()];
			mStatTimeLeft = new double[oRobot.getOthers()];
			for (int i = 0; i < oRobot.getOthers(); i++) {
				//The learning vars are currently initialized as
				// constants; I'll make some exponential round-based
				// formula instead as soon as I get unlazy.
				mJiggleMult[i] = 1;
				mJiggleInc[i] = 2.2;
				mAngleDistance[i] = 250;
				if (oRobot.getNumRounds() > 9) mDistanceChange[i] = 60;
				mStatLastEnergy[i] = 10000;
				mStatThisEnergy[i] = 0;
				mStatTimeLeft[i] = CStatLearnTime;
			}
		}
	}
	
	public void doInit() {
		mBiasIncMult = (double)1 - (double)5 / (double)oRobot.getNumRounds();
		mBiasIncMult = -0.92;
		oRobot.setMaxTurnRate(100);
		oRobot.setMaxVelocity(8);
		oRobot.setTurnRight(0);
		oRobot.setAhead(0);
		mNextReset = false;
		mEnergy = -1;
		mSpeedTime = 100;
		mJiggleTime = Math.random() * CJiggleRnd + CJiggleMin;
		mLastJiggle = oRobot.getTime();
	}
	
	public void doUnInit() {
	}
	
	public void doTurn() {
		//oRobot.out.println(mJiggleMult[oComControl.mTarget] + " " + mJiggleInc[oComControl.mTarget]);
		doStatDistance();
		doJiggle(false);
		setTurn();
		oRobot.setAhead(60000 * mDirection);
		setVelocity();
	}

	public void doJiggle(boolean pForce) {
		if (oRobot.getTime() > mLastJiggle + mJiggleTime * Math.max(Math.min(mJiggleMult[oComControl.mTarget] * mJiggleInc[oComControl.mTarget], 2.0), 0.5)) {
			//It's time to change direction!
			//Only change direction if we are not going to
			// head towards the wall, but we MUST CHANGE if
			// pForce is true.
			if (!oMovControl.mMovWall.isRobotHeadingToWall(getFixedHeading(), CLineSpace * 2) || pForce) mDirection *= -1;
			//Reset Jigglers:
			mJiggleTime = Math.random() * CJiggleRnd + CJiggleMin;
			mLastJiggle = oRobot.getTime();
		}
	}

	private void doStatDistance() {  //*I was too lazy to rename this when I added Jiggle learning
		//Don't add deltas unless we are close to the distance we are testing.
		// This applies to both distance and jiggle learning because learning
		// jiggle isn't much good at the wrong distance.
		//***I removed this in 2.3 while observing Cake's performance vs Tron;
		// When an enemy is running from Cake, it's always chasing it, and
		// sometimes chasing the guy yields better performance; with this if
		// statement active, Cake doesn't log deltas while it's chasing. It
		// learns better without it because it includes chasing in its learning
		// algorithms.
		//if (Math.abs(oComControl.mComEnemy.mEnemyDistance[oComControl.mTarget] - getCurDistance()) < 25) {
			mStatTimeLeft[oComControl.mTarget] -= oComControl.mTimeDelta;
			mStatThisEnergy[oComControl.mTarget] += oComControl.mEnergyDelta;
		//}
		if (mStatTimeLeft[oComControl.mTarget] <= 0) {
			if (mStatLastEnergy[oComControl.mTarget] == 10000) {
				mStatLastEnergy[oComControl.mTarget] = mStatThisEnergy[oComControl.mTarget];
				mStatTimeLeft[oComControl.mTarget] = CStatLearnTime;
				mStatThisEnergy[oComControl.mTarget] = 0;
				if (mStatMode[oComControl.mTarget])
					mDistanceChange[oComControl.mTarget] = -mDistanceChange[oComControl.mTarget];
				else
					mJiggleInc[oComControl.mTarget] = 1 / mJiggleInc[oComControl.mTarget];
			} else {
				if (mStatMode[oComControl.mTarget]) {
					//oRobot.out.println("Farther: " + mStatLastEnergy + ", Closer: " + mStatThisEnergy);
					if (mStatThisEnergy[oComControl.mTarget] < mStatLastEnergy[oComControl.mTarget]) {
						mAngleDistance[oComControl.mTarget] -= mDistanceChange[oComControl.mTarget];
						//oRobot.out.println("Increasing Distance");
						if (mDistanceChange[oComControl.mTarget] < -4) oRobot.out.println("[" + oRobot.getTime() + "] MOV: Increasing Distance to " + (double)(Math.round(mAngleDistance[oComControl.mTarget] * 1000) / 1000));
					} else if (mStatThisEnergy[oComControl.mTarget] > mStatLastEnergy[oComControl.mTarget]) {
						mAngleDistance[oComControl.mTarget] += mDistanceChange[oComControl.mTarget];
						if (mAngleDistance[oComControl.mTarget] < CMinAngleDistance) mAngleDistance[oComControl.mTarget] = CMinAngleDistance;
						//oRobot.out.println("Reducing Distance");
						if (mDistanceChange[oComControl.mTarget] < -4) oRobot.out.println("[" + oRobot.getTime() + "] MOV: Reducing Distance to " + (double)(Math.round(mAngleDistance[oComControl.mTarget] * 1000) / 1000));
					}
					mDistanceChange[oComControl.mTarget] *= mBiasIncMult;
					mStatMode[oComControl.mTarget] = false;
				} else {
					if (mStatThisEnergy[oComControl.mTarget] < mStatLastEnergy[oComControl.mTarget]) {
						//mJiggleMult[oComControl.mTarget] *= mJiggleInc[oComControl.mTarget];						
						mJiggleMult[oComControl.mTarget] = Math.max(Math.min(mJiggleMult[oComControl.mTarget] * mJiggleInc[oComControl.mTarget], 2.0), 0.5);
						//if (true)
						oRobot.out.println("[" + oRobot.getTime() + "] MOV: Increasing Jiggle to " + (double)(Math.round((double)1000 / (double)mJiggleMult[oComControl.mTarget]) / (double)1000));
					} else if (mStatThisEnergy[oComControl.mTarget] > mStatLastEnergy[oComControl.mTarget]) {
						mJiggleMult[oComControl.mTarget] = Math.max(Math.min(mJiggleMult[oComControl.mTarget] / mJiggleInc[oComControl.mTarget], 2.0), 0.5);
						//if (true)
						oRobot.out.println("[" + oRobot.getTime() + "] MOV: Reducing Jiggle to " + (double)((double)Math.round((double)1000 / (double)mJiggleMult[oComControl.mTarget]) / (double)1000));
					}
					mJiggleInc[oComControl.mTarget] = 1 / ((mJiggleInc[oComControl.mTarget] - 1) * mBiasIncMult * -1 + 1);
					mStatMode[oComControl.mTarget] = true;
				}
				mStatThisEnergy[oComControl.mTarget] = 0;
				mStatLastEnergy[oComControl.mTarget] = 10000;
				mStatTimeLeft[oComControl.mTarget] = CStatLearnTime;
			}
		}
	}

	public double getCurDistance() {
		if (mAngleDistance[oComControl.mTarget] + mDistanceChange[oComControl.mTarget] < CMinAngleDistance) return CMinAngleDistance;
		else return mAngleDistance[oComControl.mTarget] + mDistanceChange[oComControl.mTarget];
	}	
		
	private void setTurn() {
		double mAngleFix = 0;
		CAngleFixMax = (Math.sin(oRobot.getTime() / 4) + 1) / 2 * (CAngleFixMaxHigh - CAngleFixMaxLow) + CAngleFixMaxLow;
		mAngleFix = (oComControl.mComEnemy.mEnemyDistance[oComControl.mTarget] - getCurDistance()) / CAngleDiv;
		if (Math.abs(mAngleFix) > CAngleFixMax) mAngleFix = CAngleFixMax * mAngleFix / Math.abs(mAngleFix);
		mAngleFix *= mDirection * -1;
		mAngleFix = oRobot.normalRelativeAngle(oComControl.mComEnemy.mEnemyDirection[oComControl.mTarget] - oRobot.getHeading() + 90 + mAngleFix);
		//oRobot.out.println(Math.abs(oRobot.normalRelative90Angle(getFixedHeading() + mAngleFix)) + "   " + Math.abs(oRobot.normalRelative90Angle(getFixedHeading())));
		if (oMovControl.mMovWall.isRobotHeadingToWall(getFixedHeading() + mAngleFix, CLineSpace) && mSpeedTime > CSpeedTime && (Math.abs(oRobot.normalRelative90Angle(getFixedHeading() + mAngleFix)) <= CWallAngleRev || oComControl.mComEnemy.mEnemyDistance[oComControl.mTarget] > mAngleDistance[oComControl.mTarget])) { // && Math.abs(oComControl.mEnemyDistance[oComControl.mTarget] - mAngleDistance[oComControl.mTarget]) <= CDistanceDiffWallRev
			mDirection *= -1;
			mLastJiggle = oRobot.getTime() - 20;
		} else {
			while (oMovControl.mMovWall.isRobotHeadingToWall(getFixedHeading() + mAngleFix, CLineSpace)) mAngleFix += mDirection;//mAngleFix -= (mDirection + 1) * 45 - mAngleFix % 90 - (mDirection - 1) * 45;
			//if (mDirection == 1)
			//	mAngleFix += 90 - mAngleFix % 90;
			//else
			//	mAngleFix += mAngleFix % 90 - 90;
			//mAngleFix -= mDirection * 10;
		}
		oRobot.setTurnRight(oRobot.normalRelativeAngle(mAngleFix));
	}
	
	public double getFixedHeading() {
		return oRobot.normalAbsoluteAngle(oRobot.getHeading() + 90 * (mDirection - 1));
	}
	
	private void setVelocity() {
		if (mSpeedTime > CSpeedTime) {
			oRobot.setMaxVelocity(CSpeedMin + (CSpeedMax - CSpeedMin) * Math.abs(getCurDistance() - oComControl.mComEnemy.mEnemyDistance[oComControl.mTarget]) / CSpeedDiv);
			//oRobot.out.println(oComControl.mEnemyDistance[oComControl.mTarget]);
			//if (Math.abs(CAngleDistance - oComControl.mEnemyDistance) < 10) oRobot.setMaxVelocity(0);
		}
		mSpeedTime += oComControl.mTimeDelta;
	}
	
	public void doBLUpdate(double pEnergy) {
		if (mNextReset) mNextReset = false; else if (pEnergy < mEnergy) onBulletHeard(mEnergy - pEnergy);
		mEnergy = pEnergy;
	}
	
	public void onBulletHeard(double pPower) {
		mSpeedTime = 0;
		oRobot.setMaxVelocity(8);
	}
		
	public void onHitRobot(HitRobotEvent e) {
		mNextReset = true;
	}
	
	public void onHitWall(HitWallEvent e) {
		mDirection *= -1;
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		//The OLD jiggler algorithm; garbage...
		//mDirection = Math.round(Math.random()) * 2 - 1;
		
		//A piece of the NEW jiggler algorithm:
		doJiggle(true);
		//If it's time to switch direction, the 'true'
		// forces the direction change even if the bot
		// is currently dodging a bullet.
	}
	
	public void onBulletHit(BulletHitEvent e) {
		mNextReset = true;
	}
}