package vuen.cfCake;
import vuen.Cake;
import robocode.*;

public class cRadControl {
	private Cake oRobot = null;
	private cComControl oComControl = null;

	public cRadLock mRadLock = null;
	public cRadWide mRadWide = null;

	public String mPattern = "Off";
	
	public cRadControl(Cake pRobot, cComControl pComControl) {
		oRobot = pRobot;
		oComControl = pComControl;
		
		mRadLock = new cRadLock(oRobot, this, oComControl);
		mRadWide = new cRadWide(oRobot, this, oComControl);
		
		doNew("Optimal");
	}
	
	public void doPrintStats() {
		
	}
	
	public void doPrintEnemyStats(int i) {
		
	}
	
	public void doTurn() {
		doNew("Optimal");
		if (mPattern == "Lock") {
			mRadLock.doTurn();
		} else if (mPattern == "Wide") {
			mRadWide.doTurn();
		}
	}
	
	public void doNew(String pPattern) {
		String pNPattern = null;
		if (pPattern == "Optimum" || pPattern == "Optimal") {
			if (oRobot.getOthers() == 1)
				pNPattern = "Lock";
			else
				pNPattern = "Wide";
		} else pNPattern = pPattern;
		if (mPattern == pNPattern) return;
		if (mPattern == "Lock") {
			mRadLock.doUnInit();
		} else if (mPattern == "Wide") {
			mRadWide.doUnInit();
		} else if (pPattern == "Off") {
		}
		if (pNPattern == "Lock") {
			mPattern = "Lock";
			if (oRobot.getTime() == 0)
				oRobot.out.print("[" + oRobot.getTime() + "] Starting Modes: RAD: " + mPattern);
			else
				oRobot.out.println("[" + oRobot.getTime() + "] RAD: Changing Scanner Mode to " + mPattern);
			mRadLock.doInit();
		} else if (pNPattern == "Wide") {
			mPattern = "Wide";
			if (oRobot.getTime() == 0)
				oRobot.out.print("[" + oRobot.getTime() + "] Starting Modes: RAD: " + mPattern);
			else
				oRobot.out.println("[" + oRobot.getTime() + "] RAD: Changing Scanner Mode to " + mPattern);
			mRadWide.doInit();
		} else if (pNPattern == "Off") {
			//oRobot.out.println("[" + oRobot.getTime() + "] RAD: Turning off Radar");
			mPattern = "Off";
			oRobot.setTurnRadarRight(0);
		}
	}
	
	public void onWin(WinEvent e) {
		doNew("Off");
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		if (mPattern == "Lock") {
			mRadLock.onScannedRobot(e);
		} else if (mPattern == "Wide") {
			mRadWide.onScannedRobot(e);
		}
	}
}