package baal.nano;
import robocode.*;
import robocode.util.Utils;

//N 1.42
// AntiGrav system, a la DustBunny.
// Energy Management courtesy Voidious.
// Infinity Lock courtesy wiki.
// Linear Gun courtesy wiki.

public class N extends AdvancedRobot
{
	static final double infinity = Double.POSITIVE_INFINITY;
	static double xForce, yForce;
			
	public void run() {
		setAdjustGunForRobotTurn(true);
		turnRadarRightRadians(infinity);
	}
	public void onScannedRobot(ScannedRobotEvent e) {
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();	
		xForce = xForce * 0.9 - Math.sin(absoluteBearing) / e.getDistance() * Math.random();
		yForce = yForce * 0.9 - Math.cos(absoluteBearing) / e.getDistance() / (getTime() * 0.13);
		setMaxVelocity(400 / getTurnRemaining());
		if(e.getDistance() < 300 || getOthers() == 1)	
			setTurnRadarLeftRadians(getRadarTurnRemaining());
		setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians() + 
			(e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing) / 13.0)));
		setAhead(infinity);
		setTurnRightRadians(Utils.normalRelativeAngle(
			Math.atan2(xForce + 1/getX() - 1/(getBattleFieldWidth() - getX()), 
					   yForce + 1/getY() - 1/(getBattleFieldHeight() - getY()))
						- getHeadingRadians()) );
		fire(2.5 - Math.max(0, (30 - getEnergy()) / 16));		
	}
}
