package ntc;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.awt.Color;

/**
 * Evader - a robot by Starrynte
 * versions
 * 1.0 Almost a MicroBot! (789)
 *     1.1 MicroBot now
 *     1.2 Added WallSmoothing, slightly smaller code
 *         Tries to stay farther away from the enemy
 *         Codesize 735
 */
public class Evader extends AdvancedRobot
{
	static double lastEnergy,curEnergy,distRemaining,lastEnemyHeading,lastEnemyX=0,lastEnemyY=0;
	static boolean moving,movingFoward=true;
	
	public void run() {
		lastEnergy=100;
		curEnergy=100;
		addCustomEvent(new Condition("bulletFired"){
			public boolean test(){
				double delta=lastEnergy-curEnergy;
				return (delta>=0.1 && delta<=3);
			}
		});
		setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
		setTurnGunRightRadians(1.74533);
		setTurnRightRadians(Math.PI/4);
		waitFor(new TurnCompleteCondition(this));
				
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		//setColors(Color.BLACK,Color.WHITE,Color.RED);
		while(true){
			if((distRemaining=getDistanceRemaining())==distRemaining) execute(); 
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		if((lastEnergy=curEnergy) == (curEnergy=e.getEnergy())){}
		double x,y,eX=0,eY=0,absBearing,dist,goalDirection=0,addedDir=0,myLateralVel=(getVelocity()*Math.sin(e.getBearingRadians()));
		if((x=getX())==(y=getY()) || (eX=Math.sin(absBearing=e.getBearingRadians()+getHeadingRadians())*(dist=e.getDistance())) == (eY=Math.cos(absBearing)*dist) || ((goalDirection=absBearing-Math.PI/2-0.15*((myLateralVel<0) ? -1:1))==goalDirection)){}
		Rectangle2D fieldRect=new Rectangle2D.Double(18,18,getBattleFieldWidth()-36,getBattleFieldHeight()-36);
		while(!fieldRect.contains(getX()+Math.sin(goalDirection)*100, getY()+Math.cos(goalDirection)*100)){		
			goalDirection+=((myLateralVel<0) ? -0.2:0.2); //out.println("goalDirection modified to " + Math.toDegrees(goalDirection));			
			addedDir+=0.2;
		}
		//out.println();
		setMaxVelocity(Math.max(8-(addedDir/2),1));
		setTurnRightRadians(Utils.normalRelativeAngle(goalDirection-getHeadingRadians()));
		setTurnRadarLeft(getRadarTurnRemaining());
		if((lastEnemyX=x+eX) == (lastEnemyY=y+eY)){}
		if(getEnergy()>2 || e.getEnergy()==0){
			double db=0,	
			ww=lastEnemyHeading,  // enemy's starting heading
			bulletPower=(e.getEnergy()==0)?0.1:1.9;					
			do
			{
				if((db += (20.0 - (3.0 * bulletPower)))==0){}
				double dx=e.getVelocity()*Math.sin(ww), dy=e.getVelocity()*Math.cos(ww);
				//ww+=w;  // turn w radians for next step
				if((ww += e.getHeadingRadians()-lastEnemyHeading)==0 || (eX+=dx)==0 || (eY+=dy)==0){}
			} while (db < Point2D.distance(0,0,eX,eY));	// The bullet travelled far enough to hit our target!
			if((lastEnemyHeading=e.getHeadingRadians())==0){}
			if(getGunTurnRemainingRadians()<0.174533){	
				setTurnGunRightRadians(Utils.normalRelativeAngle(Math.atan2(eX, eY) - getGunHeadingRadians()));
				if(setFireBullet(bulletPower) != null){}
			}
		}
	}

	public void onHitByBullet(HitByBulletEvent e) {		
		if((curEnergy+=e.getBullet().getPower()*3) == (lastEnergy=curEnergy)){}
	}

	public void onBulletHit(BulletHitEvent e){
		if((curEnergy=e.getEnergy()) == (lastEnergy=curEnergy)){}
	}

	public void onHitWall(HitWallEvent e){
		if(movingFoward=!movingFoward){}
		setAhead(Math.abs(distRemaining)*((movingFoward)?1:-1));
		/*setBack(Math.abs(distRemaining));
		if(movingFoward){
			setAhead(Math.abs(distRemaining));
		}*/				
	}
	
	public void onWin(WinEvent e){		
		stop();
		setTurnRight(360);
		//setTurnGunRightRadians(Utils.normalRelativeAngle(Math.atan2(lastEnemyX-getX(), lastEnemyY-getY())-getGunHeadingRadians()));
		setTurnRadarRight(1800);
		//setColors(Color.CYAN,Color.PINK,Color.BLACK);
		execute();
	}

	public void onCustomEvent(CustomEvent e){
		if(e.getCondition().getName().equals("bulletFired")){
			if(!moving){
				setBack(Double.POSITIVE_INFINITY);
				if(movingFoward){
					setAhead(Double.POSITIVE_INFINITY);
				}
				if(moving=true){ /*setColors(Color.WHITE,Color.BLACK,Color.GREEN);*/ }
			}else{
				setBack(8);
				if(movingFoward){
					setAhead(8);
				}
				if(moving=false){ /*setColors(Color.BLACK,Color.WHITE,Color.RED);*/ }
			}
		}	
	}	
}
