package genprog;
import robocode.*;
import static robocode.util.Utils.normalRelativeAngleDegrees;



public class Rinmorikazu extends AdvancedRobot {
	public void run() {
		setAdjustGunForRobotTurn(true);
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
		setTurnRight(getX());
		setTurnLeft(getRadarHeading());
		execute();
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double absoluteBearing = getHeading() + e.getBearing();
		double bearingFromGun = normalRelativeAngleDegrees(absoluteBearing - getGunHeading());
		setTurnGunRight(bearingFromGun);
		setFire( 2 );
		setAhead(getY());
		execute();
	}
	
	public void onHitRobot(HitRobotEvent e) {
		setFire( 2 );
		setFire( 2 );
		setFire( 2 );
		execute();
	}
	
	public void onHitWall(HitWallEvent e) {
		setTurnRight(( getEnergy() + getY() ));
		execute();
	}
}