package djc;
import robocode.*;
import java.util.Enumeration;

/**
 * TacticalStrategy - Based on the Strategy class by Simon Parker in JollyNinja
 *    Provides the framework for (Strategy) Robot behavior.
 */
public abstract class TacticalStrategy
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */
    /** Time to live before considering scanned position information out-of-date */
    public static final double POSITION_STALENESS = 15.0;

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */
    protected StrategyBot self;  // Entity to control
    protected TacticalStrategyManager strategyManager;
    protected double myTurnVelocity = 8;
    protected double myMaxVelocity = 8;
    public double lastShotPassesAt = -1;  // Estimated time a shot will wiz by me
    public String name = "None";  // TacticalStrategy Name
    public double accruedDamageThisUse = 0;

    // Constructor; set up the TacticalStrategy class.
    public TacticalStrategy (StrategyBot theRobot, TacticalStrategyManager theStrategyManager)
    {
	self = theRobot;
	strategyManager = theStrategyManager;
    }

    public void reset(){}          // initialize the robot
    public void startTurn(){}      // any init that needs doing at the start of the turn
    public void setMovement(){}    // sets the turning angle and the ahead/back movement
    public void setScan(){}        // control the radar motion
    public void endTurn(){}        // any cleanup at the end of the turn
    public void onScannedRobot(ScannedRobotEvent e){} // Event handler
    public void onHitByBullet(HitByBulletEvent e){}   // Event handler
    public void onDeath(DeathEvent e){}               // Event handler
    public void onHitWall(HitWallEvent e){}           // Event handler
    public void onHitRobot(HitRobotEvent e){}         // Event handler
    public void onBulletHit(BulletHitEvent e){}       // Event handler
    public void onRobotDeath(RobotDeathEvent e){}     // Event handler

    // Helper functions

    /**
     * enemyFired - what to do when shot at
     *
     *  Derived classes are expected to implement this
     *  function.
     */
    public abstract void enemyFired(Target shooter, double bulletPower);

    /**
     * findOldestTarget
     *
     *  @return Target that is has oldest position time or null.
     */
    public final Target findOldestTarget()
    {
	Enumeration e = self.targetList.elements();
	Target oldestTarget = null;
	Target currentTarget = null;
	double oldestTime = Double.MAX_VALUE;

	while(e.hasMoreElements()) {
	    currentTarget = (Target)e.nextElement();
	    if (currentTarget.isAlive) {
		if (oldestTarget == null) {
		    oldestTarget = currentTarget;
		    oldestTime = currentTarget.lastTimePosition;
		} else {
		    if(currentTarget.lastTimePosition < oldestTime) {
			oldestTarget = currentTarget;
			oldestTime = currentTarget.lastTimePosition;
		    }
		}
	    }  
	} // end while(e.hasMoreElements())

	return oldestTarget;
    }
}
