package djc;
import robocode.*;
import java.util.Hashtable;
import java.util.Enumeration;

/**
 * TronTacticalStrategy
 *   Move around randomly at right angles
 *
 * All code created by Dan Cieslak, 2002.
 *
 * All code that is mine is available for anyone to use for
 * any purpose, so long as I am listed as a source.
 *
 */
public class TronTacticalStrategy extends DefaultTacticalStrategy
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */
    public static final double MIN_DISTANCE = 20.0;
    public static final double MAX_DISTANCE_RANGE = 80.0;

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */
    public boolean moveX = false;

    // Constructor; set up the TronTacticalStrategy class.
    public TronTacticalStrategy (StrategyBot theRobot, TacticalStrategyManager theStrategyManager)
    {
	super(theRobot, theStrategyManager);
	name = TacticalStrategyManager.TRON;
    }

    /**
     * What to do when shot at.
     *
     * @param minRadius - smallest distance away to pick
     */
    public void enemyFired(Target shooter, double bulletPower)
    {
	super.enemyFired(shooter, bulletPower);  // speed adjustment.
	moveX = !moveX;
    }

    /**
     * pick a random point at least minRadius away and at most maxRadius
     * and make sure it is in the field.
     *
     * Randomly pick to move either in x or in y only.
     */
    public Coordinate pickNewLocation(double minRadius, double maxRadius)
    {
	
	// how much x to move
	double dx = self.random.nextDouble() * (maxRadius - minRadius) + minRadius;
	// how much y to move
	double dy = self.random.nextDouble() * (maxRadius - minRadius) + minRadius;
	double width = self.getBattleFieldWidth();
	double height = self.getBattleFieldHeight();
	double myWidth = self.getWidth() / 2;
	
	if(self.random.nextBoolean())
	    dx = -dx;
	if(self.random.nextBoolean())
	    dy = -dy;
	
	Coordinate newLoc;
	
	if(moveX) { // Move in X
	    newLoc = new Coordinate(self.getX() + dx, self.getY());
	    // Sanity check for wall avoidance
	    if(newLoc.offField(width, height, myWidth))
		newLoc.x -= 2 * dx;
	} else {                         // Move in Y
	    newLoc = new Coordinate(self.getX(), self.getY() + dy);
	    // Sanity check for wall avoidance
	    if(newLoc.offField(width, height, myWidth))
		newLoc.y -= 2 * dy;
	}
	
	return newLoc;
    }

    public void onHitWall(HitWallEvent e)
    {
	moveX = !moveX;
    }

}
