package nz.jdc.nano;

import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/**
 * AralR : Adaptive rolling average linear randomized
 * Brother to Aral.
 * Take Aral, replace the oscillate detection with randomness, use the saved space
 * to do some bullet power management.
 * 
 * Firing: rolling average of absolute linear velocity feeding into linear targeting,
 *   which hits orbit and stop/go movement well.  
 *   Additional randomness to hit ocsillating and random movement.
 * Movement: Bullet dodge. Toggles between uni-directional and reversing moves.
 * 
 * Note: this bot is derived from Aral. It is stupider (i.e. random), but perversely
 * ranks about the same. More commentary on that in the wiki...
 * 
 * Credits: Pretty much everybody, especially those who contributed helpful articles to the
 * wiki, particularly the stuff on flat movement, rolling averages and nano-linear targetting.
 * Movement is based on the very elegant movement strategy of dft.Freddie 1.32 by Alcatraz271.
 * Updates and code size improvements from perusing rectent top bots like little black book,
 * Yatagan etc, so credit to Skilgannon, Sheldor, Michael Dorgan any anybody else whose code 
 * I have perused and forgotten to credit.
 *  
 * Version 1.0: Initial version. 
 *   Codesize 249.
 *   
 * Version 1.1: Changed to new "adept" style movement to give it a trial. It not not clear 
 *   whether it is an improvement on the old neophyte movemment.  
 *   Codesize 247.
 *
 * @author John Cleland
 */
public class AralR extends AdvancedRobot {
  // tunable constants
  // for movement
  private final static double MOVE_DISTANCE       = 80;
  private final static double PREFERRED_RANGE     = 220;
  private final static double CLOSE_FCT           = 430 * MOVE_DISTANCE;
  
  // for gun
  private final static double BULLET_POWER_FACTOR = 450;
  private final static double ROLL_FACTOR         = 14;
  private final static double TO_DEGREES          = 180 / Math.PI;
  private final static char   GF_1                = (char) (int) (1 * TO_DEGREES);
  private final static char   GF_0                = (char) (int) (0 * TO_DEGREES);
  private final static char   GF_OSC              = (char) (int) (-0.45 * TO_DEGREES);
  private final static double NUM_RAND            = 10;
  
  // attributes
  // for movement
  private static double       enemyEnergy;
  private static double       moveDir;
  private static int          moveMode;
  
  // for gun  
  private static double       rAvgAbsLatV;
  private static double       eoDir;

  /**
   * Bot run method.
   */
  public void run() {
    // testparam = Double.parseDouble(System.getProperty("RUMBLETESTER_PARAM"));
    
    // start our infinite radar loop
    turnRadarRightRadians(moveDir = MOVE_DISTANCE);
  }
  
  /**
   * Scan handler.
   * This is where it all happens.
   */
  public void onScannedRobot(ScannedRobotEvent e) {
    // register vars, should be the most commonly used
    // unused int    ri;
    double rd;

    // other vars
    double latVel;
    
    // radar scan
    setTurnRadarLeftRadians(getRadarTurnRemaining());
    
    // bullet dodge a random distance
    if ( (char) ((enemyEnergy - 1.0999 - (enemyEnergy = e.getEnergy()))) < 2) {
      moveDir *= (short) MOVE_TABLE.charAt(moveMode);
    }
    setAhead(moveDir * Math.random());
    
    // turn perpendicular with range control
    setTurnRightRadians(Math.cos((rd = e.getBearingRadians()) - (e.getDistance() - PREFERRED_RANGE) * moveDir / CLOSE_FCT));
    // rd has enemy relative bearing
    
    // targeting
    rAvgAbsLatV = (rAvgAbsLatV * ROLL_FACTOR + Math.abs(latVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - (rd +=  getHeadingRadians())))) / (1 + ROLL_FACTOR);
    // rd now has enemy absolute bearing
    
    // nano linear targeting fn
    setTurnGunRightRadians(Utils.normalRelativeAngle(rd  - getGunHeadingRadians() 
      + rAvgAbsLatV * Math.signum(eoDir = eoDir * .1 + latVel) 
      * Math.toRadians((short) table.charAt((int) (Math.random() * NUM_RAND))) 
      / Rules.getBulletSpeed(rd = BULLET_POWER_FACTOR / e.getDistance()) 
    ));

    // fire
    setFire(rd);
  }
  
  /**
   * Hit a wall, reverse direction and start moving immediately.
   */
  public void onHitWall(HitWallEvent e) {
    moveDir = -moveDir;
  }

  public void onDeath(DeathEvent event) {
    moveMode += 2;
  }

  /**
   * Hit by bullet, change movement strategy.
   */
  public void onHitByBullet(HitByBulletEvent e) {
    moveMode ^= 1;
  }
  
  // table constants
  private final static char  ORBIT = (char) 1;
  private final static char  OSC   = (char) -1;
  private final static String MOVE_TABLE = "" 
    + ORBIT + ORBIT + OSC + OSC + ORBIT + ORBIT + OSC + OSC + ORBIT + ORBIT + OSC + OSC + ORBIT + ORBIT
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    ;

  private final static String table = "" 
    + GF_1  + GF_1 + GF_1 + GF_1 + GF_1 
    + GF_0  + GF_0 
    + GF_OSC + GF_OSC + GF_OSC 
    + GF_1 + GF_1 + GF_1 + GF_1 + GF_1 + GF_1 + GF_1 + GF_1 + GF_1 + GF_1 + GF_1; // padding
  
}
