package theo;
import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
import robocode.util.Utils;
import java.awt.Graphics2D;
import java.util.Arrays;
/**
 * Tungsten - a robot by theo
 */
public class Tungsten extends AdvancedRobot
{

	static final boolean isMC = false;
	static final boolean isTC = false;

	OtherGuy enemy = new OtherGuy();
	HelperFunctions utils = new HelperFunctions(this);
	GHandler gWaver = new GHandler(this, utils, enemy);
	SHandler sWaver = new SHandler(this, utils, enemy);
	
	double heading, velocity,
			radarOffset, greatestDist;
	Point2D.Double position;
	
	RoundRectangle2D.Double playField;

	public void run() {

		setColors(Color.green,Color.blue,Color.green);
		
		greatestDist = Math.sqrt(getBattleFieldWidth()*getBattleFieldWidth()
							+ getBattleFieldHeight()*getBattleFieldHeight());
							
		playField = new RoundRectangle2D.Double(20,20,
				getBattleFieldWidth() - 40, getBattleFieldHeight()-40,
				18,18);
		
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustGunForRobotTurn(true);

		while(true) {
			turnRadarRight(Double.POSITIVE_INFINITY);
		}
	}

	void updateStats(){
		velocity = this.getVelocity();
		heading = this.getHeadingRadians();
		position = new Point2D.Double(this.getX(),this.getY());
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		
		updateStats();	

		enemy.velocity = e.getVelocity();
		enemy.heading = e.getHeadingRadians();
		enemy.bearing = e.getBearingRadians();
		enemy.absBearing = Utils.normalRelativeAngle(heading + enemy.bearing);
		enemy.distance = e.getDistance();
		enemy.position = utils.project(position,enemy.distance,enemy.absBearing);
		enemy.absBearingFrom = utils.getAbsBearing(enemy.position,position);
		enemy.lateralHeading = Utils.normalRelativeAngle(enemy.heading - enemy.absBearing);
		enemy.lateralVelocity = enemy.velocity * Math.sin(enemy.heading - enemy.absBearing);
		enemy.angularVelocity = enemy.lateralVelocity/enemy.distance;
		enemy.energy = e.getEnergy();
		
		if(enemy.velocity!=0)
			enemy.latDirection = utils.sign(enemy.lateralVelocity);
		else { enemy.latDirection = enemy.lastLatDirection; }
		enemy.lastLatDirection = enemy.latDirection;
		
		radarOffset = Utils.normalRelativeAngle(enemy.absBearing-getRadarHeadingRadians());
		
		setTurnRadarRightRadians(2*radarOffset);
		
		if(!isTC){
		gWaver.update();}
		if(!isMC){
		sWaver.update();}
		
		enemy.lastLateralVelocity = enemy.lateralVelocity;
		enemy.lastVelocity = enemy.velocity;
		enemy.lastEnergy = enemy.energy;
		enemy.lastBearing = enemy.bearing;
		enemy.lastLateralHeading = enemy.lateralHeading;

		execute();
	}

	public void onHitByBullet(HitByBulletEvent e) {
		sWaver.storeEvent(e.getBullet());
	}

	public void onBulletHitBullet(BulletHitBulletEvent e){
		sWaver.storeEvent(e.getHitBullet());
	}

	public void onHitWall(HitWallEvent e) {
	
	}
	
	public void onDeath(DeathEvent e){
		sWaver.surfGroup.clear();
		gWaver.waveGroup.clear();
		System.out.println("We died yay!");
	}
	
	public void onWin(WinEvent e){
		sWaver.surfGroup.clear();
		gWaver.waveGroup.clear();
		out.println("I'm alive, yay!");
	}
	
	public void onPaint(Graphics2D g){
		g.setColor(Color.green);
		for(GHandler wave:gWaver.waveGroup){
			double radius = wave.distTravelled + wave.bSpeed;
			g.drawOval((int)(wave.shotPosition.x-radius+.5d),
				(int)(wave.shotPosition.y-radius+.5d),
					((int)(radius*2+.5d)),((int)(radius*2+.5d)));
		}
		g.setColor(Color.red);
		for(SHandler wave:sWaver.surfGroup){
			double radius = wave.distTravelled + wave.bSpeed;
			g.drawOval((int)(wave.shotPosition.x-radius+.5d),
				(int)(wave.shotPosition.y-radius+.5d),
					((int)(radius*2+.5d)),((int)(radius*2+.5d)));
		}
	}
}

class OtherGuy{
	Point2D.Double position;
	double velocity;
	double lastVelocity;
	double heading;
	double absBearing;
	double absBearingFrom;
	double distance;
	double bearing, lastBearing;
	double lateralHeading, lastLateralHeading;
	double lateralVelocity;
	double lastLateralVelocity;
	double angularVelocity;
	double energy, lastEnergy;
	int latDirection;
	int lastLatDirection;
}

class HelperFunctions{
	Tungsten Tu;
	HelperFunctions(Tungsten type1){
		Tu = type1;
	}
	
	double bSpeed(double pow){
		return (20-3*pow);
	}
	double getAbsBearing(Point2D.Double source, Point2D.Double target){
		return Utils.normalRelativeAngle(
				Math.atan2(target.x-source.x,target.y-source.y));
	}
	double getAbsAngle(Point2D.Double source, Point2D.Double target){
		return Utils.normalAbsoluteAngle(
				Math.atan2(target.x-source.x,target.y-source.y));
	}
	Point2D.Double project(Point2D.Double source, double dist, double theta){
		return new Point2D.Double(
			source.x + dist * Math.sin(theta),
			source.y + dist * Math.cos(theta) );
	}
	int sign(double val){
		return (val>=0?1:-1);
	}
	List<double[]> getNearestNeighbors(Set<double[]> pointSet, double[] dataPoint, int numNeighbors){
		if(numNeighbors == -1 || numNeighbors == 0){
			return new ArrayList<double[]>(pointSet);
		}
		List<double[]> neighborList = new ArrayList<double[]>(numNeighbors);
		List<double[]> fullList = new ArrayList<double[]>(pointSet);
		for(int i = 0; i < numNeighbors; i ++){
			neighborList.add(fullList.get(i));
		}
		double[] nearestDistSq = new double[numNeighbors];
		nearestDistSq[0] = distanceSquared(dataPoint,neighborList.get(0));
		double longestDistSq = nearestDistSq[0];
		int longestIndex = 0;
		
		for(int y = 1; y < numNeighbors; y ++){
			nearestDistSq[y] = distanceSquared(dataPoint,neighborList.get(y));
			if(nearestDistSq[y]>longestDistSq){
				longestDistSq = nearestDistSq[y];
				longestIndex = y;
			}
		}
		double distSq, dist, tempDist = 0;
		for(int x = numNeighbors; x < fullList.size(); x++){
			distSq = distanceSquared(dataPoint,fullList.get(x));
			if(distSq < longestDistSq){
				neighborList.set(longestIndex,fullList.get(x));
				nearestDistSq[longestIndex] = distSq;
				tempDist = 0;
				for(int i = 0; i < nearestDistSq.length; i ++){
					dist = nearestDistSq[i];
					if(dist>tempDist){
						longestDistSq = dist;
						tempDist = dist;
						longestIndex = i;
					}
				}
			}
		}
		return neighborList;
	}
	double distanceSquared(double[] a, double[] b){
		double dist = 0;
		for(int i = 0; i < a.length; i ++){
			dist += sqr(a[i]-b[i]);
		}
		return dist;
	}
	double sqr(double val){
		return (val*val);
	}
	double limit(double a, double b, double c){
		return Math.max(a,Math.min(b,c));
	}
}

class GHandler{
	Tungsten Tu;
	HelperFunctions utils;
	OtherGuy enemy;
	GHandler(Tungsten type1, HelperFunctions type2, OtherGuy type3){
		Tu = type1; utils = type2; enemy = type3;
	}
	GHandler(){	}
	
	static{
		waveGroup = new ArrayList<GHandler>();
		offsetMap = new HashMap<double[], Double>();
		neighborGroup = new ArrayList<double[]>();
	}
	
	static List<GHandler> waveGroup;
	static HashMap<double[], Double> offsetMap;
	static List<double[]> neighborGroup;
	
	double bPower = 3d;
	Point2D.Double shotPosition;
	double distance;
	double distTravelled;
	double bSpeed;
	double absBearing;
	double maxEscapeAngle;
	double latDirection;
	long shotTime;
	double[] dataPoints = new double[9];
	boolean fireToDeath = Tu.isMC;

	void update(){
		
		//bPower = 1.9d;
		bPower = Math.random()*1d+1.5d;
		if(enemy.energy<4){
			bPower = enemy.energy/4d;
		}
		else if(enemy.energy<16){
			bPower = (enemy.energy+2d)/6d;
		}
		if(Tu.isMC){ bPower = 3; }
		
		bPower = utils.limit(.1,bPower,3d);
		bSpeed = utils.bSpeed(bPower);
		dataPoints[0] = bPower/3d;
		dataPoints[1] = Math.abs(enemy.lateralVelocity)/8d;
		dataPoints[2] = enemy.distance/Tu.greatestDist;
		dataPoints[3] = utils.limit(0,(enemy.lateralHeading-
									enemy.lastLateralHeading)/(Math.PI/18d)*.5d + .5d,1);
		//dataPoints[4] = Math.abs(enemy.lastVelocity)/8d;
		dataPoints[5] = utils.limit(0,(enemy.velocity-enemy.lastVelocity)/2d*.5d+.5d,1);
		dataPoints[6] = Math.abs(enemy.velocity)/8d;
		//dataPoints[7] = Math.abs(enemy.lastLateralVelocity)/8d;
		//dataPoints[8] = enemy.lateralHeading/(Math.PI/2d)*.5d + .5d;
		
		advanceWaves();
		checkFire();
		aimGun();
	}
	
	void advanceWaves(){
		for(int i = 0; i < waveGroup.size(); i ++){
			GHandler wave = waveGroup.get(i);
			wave.distTravelled = (Tu.getTime()-wave.shotTime)
				* wave.bSpeed;
			boolean remove = checkWave(wave);
			if(remove){ waveGroup.remove(i); i --; }
		}
	}
	
	boolean checkWave(GHandler wave){
		if(wave.distTravelled>wave.shotPosition.distance(enemy.position)){
			storeWave(wave);
			return true;
		}
		return false;
	}

	void storeWave(GHandler wave){
		double offset = getImmediateOffset(wave);
		offsetMap.put(wave.dataPoints,offset);
	}
	
	
	double getImmediateOffset(GHandler wave){
		double resultBearing = utils.getAbsBearing(wave.shotPosition,enemy.position);
		double bearingDiff = Utils.normalRelativeAngle(resultBearing-wave.absBearing);
		return utils.limit(-1d,bearingDiff/wave.maxEscapeAngle,1d);
	}
	
	void aimGun(){
		double aimBearing = checkHeaviestAngle();
		
		Tu.setTurnGunRightRadians(Utils.normalRelativeAngle(aimBearing - Tu.getGunHeadingRadians()));
	}
	
	double checkHeaviestAngle(){
		
		neighborGroup = utils.getNearestNeighbors(offsetMap.keySet(),dataPoints,Math.min(
							/*Math.min(Tu.getRoundNum()*/(18),offsetMap.keySet().size())-1);
		double botWidth = 36d/enemy.distance, ratio, density, maxDensity = 0, firingAngle = enemy.absBearing;
		
		for(double[] dataPointsA:neighborGroup){
			double angleA = getThetaForData(dataPointsA);
			density = 0;
			for(double[] dataPointsB:neighborGroup){
				if(!Arrays.equals(dataPointsA,dataPointsB)){
					double angleB = getThetaForData(dataPointsB);
					ratio = (angleB-angleA)/botWidth;
					if(Math.abs(ratio)<=1){
						density ++;
					}
				}
			}
			if(density > maxDensity){
				maxDensity = density;
				firingAngle = angleA;
			}
		}

		return firingAngle;
		//return getNearestThetaForData(dataPoints);
	}
	
	double getNearestThetaForData(double[] dataPoint){
		double dist, tempDist = 100000, offset = 0;
		for(double[] dataPointReal:offsetMap.keySet()){
			dist = utils.distanceSquared(dataPointReal,dataPoint);
			if(dist<tempDist){
				tempDist = dist;
				offset = offsetMap.get(dataPointReal);
			}
		}
		return Utils.normalRelativeAngle(
			offset*Math.asin(8d/bSpeed)*
				enemy.latDirection + enemy.absBearing);
	}
	
	double getThetaForData(double[] dataPoint){
		return Utils.normalRelativeAngle(
			(offsetMap.get(dataPoint)*Math.asin(8d/bSpeed)
				*enemy.latDirection) + enemy.absBearing);
	}
	
	void checkFire(){
		if(Tu.getGunTurnRemainingRadians()==0
				&& Tu.getGunHeat()==0
					&& (Tu.getEnergy()>bPower
						||fireToDeath)){
			spawnWave();
		}
	}
	
	void spawnWave(){
		GHandler gWave = new GHandler();
		
		gWave.bPower = bPower;
		gWave.shotPosition = Tu.position;
		gWave.distance = Tu.position.distance(enemy.position);
		gWave.distTravelled = 0;
		gWave.bSpeed = utils.bSpeed(bPower);
		gWave.maxEscapeAngle = Math.asin(8d/gWave.bSpeed)*enemy.latDirection;
		gWave.shotTime = Tu.getTime() + 1;
		gWave.absBearing = enemy.absBearing;
		gWave.latDirection = enemy.latDirection;
		
		gWave.dataPoints[0] = gWave.bPower/3d;
		gWave.dataPoints[1] = Math.abs(enemy.lateralVelocity)/8d;
		gWave.dataPoints[2] = enemy.distance/Tu.greatestDist;
		gWave.dataPoints[3] = utils.limit(0,(enemy.lateralHeading-
									enemy.lastLateralHeading)/(Math.PI/18d)*.5d + .5d,1);
		//gWave.dataPoints[4] = Math.abs(enemy.lastVelocity)/8d;
		gWave.dataPoints[5] = utils.limit(0,(enemy.velocity - enemy.lastVelocity)/2d*.5d+.5d,1);
		gWave.dataPoints[6] = Math.abs(enemy.velocity)/8d;
		//gWave.dataPoints[7] = Math.abs(enemy.lastLateralVelocity)/8d;
		//gWave.dataPoints[8] = enemy.lateralHeading/(Math.PI/2d)*.5d + .5d;
		
		waveGroup.add(gWave);

		Tu.setFire(bPower);
	}
}

class SHandler{
	Tungsten Tu;
	HelperFunctions utils;
	OtherGuy enemy;
	SHandler(Tungsten type1, HelperFunctions type2, OtherGuy type3){
		Tu = type1; utils = type2; enemy = type3;
	}
	SHandler(){ }
	
	static{
		surfGroup = new ArrayList<SHandler>();
		offsetMap = new HashMap<double[],Double>();
		neighborList = new ArrayList<double[]>();
		
		e = Math.E;
	}
	
	static List<SHandler> surfGroup;
	static HashMap<double[],Double> offsetMap;
	static List<double[]> neighborList;
	static double e;

	double[] dataPoint = new double[8];
	double velocity, maxEscapeAngle, lastVelocity;
	Point2D.Double position, desiredPosition,
		shotPosition;
	double heading;
	double distance;
	double distTravelled;
	double bPower, bSpeed, lastShotPower;
	double absBearing, absAngle;
	long shotTime; int moveDir;
	int latDirection = 1, lastLatDirection = 1, goDir = 1;
	SHandler lastWave, currentWave;
	
	void update(){
		
		velocity = Tu.velocity;
		position = Tu.position;
		heading = Tu.heading;
		distance = enemy.distance;
		if(velocity!=0){
			latDirection = (int)utils.sign(velocity)
				* (int)utils.sign(enemy.absBearing);
		}
		else{ latDirection = lastLatDirection; }
		lastLatDirection = latDirection;
		
		bPower = enemy.lastEnergy - enemy.energy;
		if(bPower<=3&&bPower>0){
			spawnWave(bPower);
			lastShotPower = bPower;
		}
		enemy.lastEnergy = enemy.energy;
		advanceWaves();

		dataPoint[0] = Math.abs(velocity)/8d;
		dataPoint[1] = distance/Tu.greatestDist;
		dataPoint[2] = utils.limit(0,Math.abs(enemy.bearing/Math.PI),1);// * .5d + .5d;
		dataPoint[3] = lastShotPower/3d;
		dataPoint[4] = (velocity-lastVelocity)/2d*.5+.5d;
		//dataPoint[5] = utils.limit(0,Math.abs(enemy.lastBearing/Math.PI),1);// * .5d + .5d;
		
		currentWave = getClosestSurfableWave();
		if(!currentWave.equals(lastWave)){
			neighborList = utils.getNearestNeighbors(offsetMap.keySet(),
						currentWave.dataPoint, Math.min(offsetMap.keySet().size(),8)-1);
		}
		lastWave = currentWave;
		lastVelocity = velocity;
		
		if(!surfGroup.isEmpty()){
			drive(
				getDesiredPosition(
					currentWave
				)
			);
		}
		else{
			Tu.setTurnRightRadians(
				getTurnAmount(enemy.absBearingFrom + Math.PI/2d - Math.PI/13d*goDir,
					position, heading, utils.sign(velocity))
			);
			Point2D.Double projectSpot = utils.project(position,120*utils.sign(velocity),heading);
			if(!Tu.playField.contains(projectSpot)&&projectSpot.distance(enemy.position)<position.distance(enemy.position)){
				goDir *= -1;
			}
			Tu.setMaxVelocity(Math.PI/Tu.getTurnRemainingRadians());
			Tu.setAhead(100*goDir);
		}
	}
	
	void spawnWave(double shotPow){
		SHandler sWave = new SHandler();
		
		sWave.velocity = Tu.getVelocity();
		sWave.shotPosition = enemy.position;
		sWave.position = Tu.position;
		sWave.shotTime = Tu.getTime();
		sWave.distance = enemy.distance;
		sWave.bPower = shotPow;
		sWave.bSpeed = utils.bSpeed(bPower);
		sWave.latDirection = (velocity*(enemy.bearing)>=0?1:-1);
		sWave.maxEscapeAngle = Math.asin(8d/sWave.bSpeed)*sWave.latDirection;
		sWave.absBearing = enemy.absBearingFrom;
		sWave.absAngle = Utils.normalAbsoluteAngle(sWave.absBearing);
		
		sWave.dataPoint[0] = Math.abs(sWave.velocity)/8d;
		sWave.dataPoint[1] = sWave.distance/Tu.greatestDist;
		sWave.dataPoint[2] = utils.limit(0,Math.abs(enemy.bearing)/Math.PI,1);
		sWave.dataPoint[3] = shotPow/3d;
		sWave.dataPoint[4] = (velocity-lastVelocity)/2d*.5d+.5d;
		//sWave.dataPoint[5] = utils.limit(0,Math.abs(enemy.lastBearing)/Math.PI,1);
		
		surfGroup.add(sWave);
	}
	
	void advanceWaves(){
		SHandler wave; boolean discard;
		for(int i = 0; i < surfGroup.size(); i ++){
			wave = surfGroup.get(i);
			discard = checkWave(wave);
			if(discard) { surfGroup.remove(i);
				i --; }
		}
	}
	
	boolean checkWave(SHandler wave){
		wave.distTravelled = (Tu.getTime() - 
				wave.shotTime) * wave.bSpeed;
		if(wave.distTravelled >= 
			wave.shotPosition.distance(
				position) + 8d){
					return true;
		}
		return false;	
	}
	
	Point2D.Double getDesiredPosition(SHandler wave){
		double desiredAngle = Utils.normalRelativeAngle(enemy.bearing+Math.PI/2d
								-Math.PI/13d*utils.sign(velocity));
		double turnAmount = getTurnAmount(desiredAngle,position,heading,(int)utils.sign(velocity));
		Point2D.Double idealSpot = utils.project(position, 120d*utils.sign(velocity), heading);
		boolean interrupted = false;
		double projectedVelocity = velocity, projectedHeading = heading, maxTurn;
		Point2D.Double tempSpot = (position);
		long itterations = 1;
		List<Point2D.Double> spotList = new ArrayList<Point2D.Double>();
		if(velocity <= 1) { spotList.add(position); }
		double[] directions = new double[] { -1*wave.latDirection,1*wave.latDirection };
		double distTrav;
		
		for(double dir:directions){
			projectedVelocity = Tu.velocity;
			projectedHeading = Tu.heading;
			tempSpot = Tu.position;
			velocity = Tu.velocity;
			itterations = 1;
			interrupted = false;
			while(!interrupted){
				desiredAngle = Utils.normalAbsoluteAngle(
						utils.getAbsAngle(wave.shotPosition, tempSpot)
						 	+ Math.PI/2d - Math.PI/13*utils.sign(projectedVelocity));
				projectedVelocity += (dir*projectedVelocity>=0?dir:2*dir);
				projectedVelocity = utils.limit(-8,projectedVelocity,8);
				turnAmount = getTurnAmount(desiredAngle,tempSpot,
						projectedHeading,(int)utils.sign(projectedVelocity));
				maxTurn = Math.PI/720d*(40d - 3d*Math.abs(projectedVelocity));
				turnAmount = utils.limit(-1d*maxTurn,turnAmount,maxTurn);
				projectedHeading = Utils.normalAbsoluteAngle(
							projectedHeading + turnAmount);
				tempSpot = utils.project(tempSpot,
								projectedVelocity,
										projectedHeading);
				spotList.add(tempSpot);
				distTrav = wave.distTravelled + 
							wave.bSpeed*(itterations);
				if(tempSpot.distance(wave.shotPosition)
					- 16 < distTrav){
						interrupted = true;
				}
				itterations ++;
			}
		}
		double danger = 0; double minDanger = 100000;
		for(Point2D.Double dSpot:spotList){
			danger = getDanger(wave,dSpot);
			if(danger<minDanger){
				minDanger = danger;
				idealSpot = dSpot;
			}
		}
		return idealSpot;
	}
	
	double getTurnAmount(double desired,Point2D.Double source, double tempHeading, int dir){
		long itterations = 0;
		double turnAmountTemp = Utils.normalRelativeAngle(desired-tempHeading);
		while(!Tu.playField.contains(
			utils.project(source,120d*(double)dir,tempHeading+turnAmountTemp))
				&& itterations < 167){
					turnAmountTemp += .01*dir;
					itterations ++;
		}
		return Utils.normalRelativeAngle(turnAmountTemp);
	}
	
	double getDanger(SHandler wave,Point2D.Double testSpot){
		double danger = 0, ratio = 0;
		double angleFrom = Utils.normalRelativeAngle(
								utils.getAbsBearing(wave.shotPosition,testSpot));
		double botWidth = 36d/wave.shotPosition.distance(testSpot);
		
		for(double[] dataKey:neighborList){
			double angleFrom2 = getThetaForData(dataKey,wave,testSpot);
			ratio = Utils.normalRelativeAngle(angleFrom2-angleFrom)/botWidth;
			danger += Math.pow(e,-.5d*utils.sqr(ratio));
		}
		
		return danger/testSpot.distance(enemy.position);
	}
	
	double getThetaForData(double[] key, SHandler wave, Point2D.Double spot){
		return Utils.normalRelativeAngle(offsetMap.get(key)*
				wave.maxEscapeAngle  + wave.absBearing);
	}
	
	SHandler getClosestSurfableWave(){
		double timeTillHit; SHandler closeWave = new SHandler();
		double shortestTime = Tu.greatestDist;
		for(SHandler wave:surfGroup){
			timeTillHit = 
				(wave.shotPosition.distance(position) -
					wave.distTravelled - wave.bSpeed) /
						wave.bSpeed;
			if(timeTillHit < shortestTime){
				shortestTime = timeTillHit;
				closeWave = wave;
			}
		}
		return closeWave;
	}
	
	SHandler getClosestSurfWave(Point2D.Double spot){
		double dist = 0, shortestDist = Tu.greatestDist;
		SHandler closeWave = new SHandler();
		for(SHandler wave:surfGroup){
			double absoluteDist = spot.distance(wave.shotPosition);
			dist = absoluteDist - wave.distTravelled;
			if(Math.abs(dist)<shortestDist){
				closeWave = wave;
				shortestDist = dist;
			}
		}
		return closeWave;
	}
	
	void storeEvent(Bullet ev){
		Point2D.Double hitSpot = new
			Point2D.Double(ev.getX(),ev.getY());
		SHandler culprit = 
			getClosestSurfWave(hitSpot);
		if(culprit.shotPosition!=null){
			storeWave(culprit, hitSpot);
			surfGroup.remove(surfGroup.indexOf(culprit));
		}
		else{ Tu.out.println("dropped A Wave"); }
	}
	
	void storeWave(SHandler wave, Point2D.Double hitPos){
		double offset = getOffset(wave, hitPos);
		offsetMap.put(wave.dataPoint,offset);
		//System.out.println(offset + " hit at");
	}
	
	double getOffset(SHandler wave, Point2D.Double hitPos){
		double resultBearing = utils.getAbsAngle(wave.shotPosition,hitPos);
		double bearingDiff = Utils.normalRelativeAngle(resultBearing-wave.absAngle);
		return utils.limit(-1d,bearingDiff/wave.maxEscapeAngle,1d);
	}
	
	void drive(Point2D.Double target){
		double driveAngle = utils.getAbsAngle(Tu.position,target);
		double deltaTheta = Utils.normalRelativeAngle(driveAngle-heading);
		int direction = 1;
		double distance = target.distance(Tu.position);

		if(deltaTheta>Math.PI/2d||
			deltaTheta<-Math.PI/2d){
				direction = -1;
		}
		
		moveDir = direction;

		Tu.setTurnRightRadians(deltaTheta*direction*Math.signum(distance));
		if(Math.signum(distance)==0){
			Tu.setTurnRightRadians(getTurnAmount(enemy.absBearingFrom + Math.PI/2d,
				Tu.position,Tu.heading,(int)utils.sign(Tu.velocity)));
		}
		Tu.setAhead(distance*direction);
		Tu.setMaxVelocity(8);
	}
}