package ar.horizon.util;

public final class FireRecording {
	private RobotRecording targetRecording;
	private boolean realBullet;

	public FireRecording(RobotRecording targetRecording) {
		this.targetRecording = targetRecording;
	}

	public RobotRecording getTargetRecording() {
		return targetRecording;
	}

	/**
	 * This value means two different but related things in the context of the
	 * targeting or the movement. In the targeting, this is true if the wave
	 * carries a bullet, and false if it is a tick wave with no bullet. In the
	 * movement, this is true if we detected the enemy's bullet by a bullet-hit
	 * or bullet-hit-bullet event, and false if we did not detect the bullet but
	 * are logging the wave hit for the flattener. In both cases, we want to
	 * weight real and imaginary bullets differently.
	 */
	public boolean isRealBullet() {
		return realBullet;
	}

	public void setRealBullet(boolean realBullet) {
		this.realBullet = realBullet;
	}
}
