package suh.nano;

import java.awt.geom.Point2D;
import robocode.*;
import robocode.util.Utils;

public class AngularMirrorC extends AdvancedRobot {
    private double lastEnemyHeading;
    
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	while(true) {
	    execute();
	}
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	double bearing;
	
	// Radar
	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((bearing = getHeadingRadians() + e.getBearingRadians()) - getRadarHeadingRadians()));
	
	// Targeting
	double power = 600.0 / e.getDistance();
	double ex = e.getDistance() * Math.sin(bearing);
	double ey = e.getDistance() * Math.cos(bearing);
				
	double dis = 0;
	double heading = lastEnemyHeading;
	do {
	    dis += Rules.getBulletSpeed(power);
	    heading += e.getHeadingRadians() - lastEnemyHeading;
	    ex += e.getVelocity() * Math.sin(heading);
	    ey += e.getVelocity() * Math.cos(heading);
	} while (dis < Point2D.distance(0, 0, ex, ey));

	setTurnGunRightRadians(Utils.normalRelativeAngle(Math.atan2(ex, ey) - getGunHeadingRadians()));
	setFire(power);
	
	lastEnemyHeading = e.getHeadingRadians();
	
	// Movement
	setTurnRightRadians(Utils.normalRelativeAngle(e.getHeadingRadians() - getHeadingRadians()));
	setAhead(100 * e.getVelocity());
	setMaxVelocity(Math.abs(e.getVelocity()));
    }
}
