package ph.mini;
import robocode.*;
import robocode.util.*;
import java.util.*;
import java.awt.geom.*;

public class Archer extends AdvancedRobot {
    static final double MAX_VELOCITY = 8;
    static final double WALL_MARGIN = 25;
    static final double REVERSE_TUNER = 0.421075;
    static final double WALL_BOUNCE_TUNER = 0.699484;
    double firePower=1.9;
    Point2D robotLocation;
    Point2D enemyLocation;
    
    int enemyDirection;
    
    double enemyAbsoluteBearing;
    double enemyDistance;
    double enemyEnergy;
    double enemyFirePower;
    double enemyHeading;
    double enemyVelocity;
    double enemyAcceleration;
    double movementLateralAngle = 0.2;
    long accelerationTimer;
    long directionTimer;
    
    // distance, velocity, acceleration, acceleration timer, direction timer, wall index, guess factors
    static int[][][][][][][] guessFactors=new int[6][3][3][4][4][3][27];
    
    public void run() {
        setAdjustRadarForGunTurn(true);
        setAdjustGunForRobotTurn(true);
        
        do {
            turnRadarRightRadians(Double.POSITIVE_INFINITY);
        } while (true);
    }
    
    protected int velocityIndex() {
	double v;
	if ((v=Math.abs(enemyVelocity)) < 2) {
	    return 0;
	}
	if (v < 6) {
	    return 1;
	}
	return 2;
    }
    
    protected int accelerationIndex() {
        if(enemyAcceleration<0)
            return 0;
        else if(enemyAcceleration>0)
            return 1;
        else
            return 2;
    }
    
    protected int accelerationTimerIndex() {
        double time=(getTime()-accelerationTimer)/(enemyDistance/getBulletSpeed(firePower));
        if(time<0.1)
            return 0;
        else if(time<0.3)
            return 1;
        else if(time<1)
            return 2;
        else
            return 3;
    }
    
    protected int directionTimerIndex() {
        double time=(getTime()-directionTimer)/(enemyDistance/getBulletSpeed(firePower));
        if(time<0.1)
            return 0;
        else if(time<0.3)
            return 1;
        else if(time<1)
            return 2;
        else
            return 3;
    }
    
    protected int wallIndex() {
	Point2D nextEnemyLocation = vectorToLocation(enemyHeading,
	    (enemyDistance / getBulletSpeed(firePower)) * enemyVelocity, enemyLocation);
	if (!fieldRectangle(18).contains(nextEnemyLocation)) {
	    return 2;
	}
	if (!fieldRectangle(36).contains(nextEnemyLocation)) {
	    return 1;
	}
	return 0;
    }
    
    protected double normalFirePower(double fp) {
        return Math.max(0.1,Math.min(3,fp));
    }
    
    protected double firePowerToKill(double energy) {
        double firePower = (energy + 2d) / 6d;
        if(firePower <= 1d) firePower = energy / 4d;
        return normalFirePower(firePower);
    }
    
    protected double firePower() {
        return normalFirePower(Math.min(getEnergy() / 5, Math.min(firePowerToKill(enemyEnergy), enemyDistance <= 150 ? 3 : 1.9)));
    }
    
    public static double getBulletSpeed(double power) {
        return 20-power*3;
    }
    
    public static double maxEscapeAngle(double power) {
        return Math.asin(8/getBulletSpeed(power));
    }
    
    public void onScannedRobot(ScannedRobotEvent e) {
        enemyAcceleration=Math.abs(e.getVelocity())-Math.abs(enemyVelocity);
        double enemyEnergyLost = enemyEnergy - e.getEnergy();
        enemyEnergy = e.getEnergy();
        if (enemyEnergyLost >= 0.1 && enemyEnergyLost <= 3.0) {
            enemyFirePower = enemyEnergyLost;
        }
        enemyHeading=e.getHeadingRadians();
        enemyLocation = vectorToLocation((enemyAbsoluteBearing= getHeadingRadians() + e.getBearingRadians()), (enemyDistance=e.getDistance()), (robotLocation= new Point2D.Double(getX(), getY())));
        if(enemyVelocity != (enemyVelocity=e.getVelocity())) accelerationTimer=getTime();
        if (enemyVelocity != 0) {
            int newEnemyDirection = Math.sin(e.getHeadingRadians()-enemyAbsoluteBearing)*enemyVelocity < 0 ? -1 : 1;
            if(newEnemyDirection != enemyDirection) directionTimer = getTime();
            enemyDirection = newEnemyDirection;
        }
        firePower = firePower();
        int[] stats=guessFactors[(int)Math.min(5,enemyDistance/160)][velocityIndex()][accelerationIndex()][accelerationTimerIndex()][directionTimerIndex()][wallIndex()];
        int bestindex = (stats.length-1)/2;	//initialize it to be in the middle, guessfactor 0.
        for (int i=0; i<stats.length; i++)
            if (stats[bestindex] < stats[i])
                bestindex = i;
        
        setTurnGunRightRadians(Utils.normalRelativeAngle((absoluteBearing(robotLocation,enemyLocation)+((double)enemyDirection*((double)((2d*(double)bestindex)/((double)stats.length-1d))-1d)*maxEscapeAngle(firePower)))-getGunHeadingRadians()));
        setFire(firePower);
        
        addCustomEvent(new Wave(stats));
        
        /*if (Math.random() < 0.05) {
            movementLateralAngle *= -1;
        }*/
        Point2D robotDestination = null;
        double tries = 0;
        double baseDistance = Math.max(enemyDistance, 80);
        do {
            robotDestination = vectorToLocation(absoluteBearing(enemyLocation, robotLocation) + movementLateralAngle,
            baseDistance * (1.1 - tries++ / 100.0), enemyLocation);
        } while (tries < 100 && !fieldRectangle(WALL_MARGIN).contains(robotDestination));
        double angle = Utils.normalRelativeAngle(absoluteBearing(robotLocation, robotDestination) - getHeadingRadians());
        double turnAngle = Math.atan(Math.tan(angle));
        setTurnRightRadians(turnAngle);
        setAhead(robotLocation.distance(robotDestination) * (angle == turnAngle ? 1 : -1));
        // Hit the brake pedal hard if we need to turn sharply
        setMaxVelocity(Math.abs(getTurnRemaining()) > 33 ? 0 : MAX_VELOCITY);
        
        if(Math.random() < (getBulletSpeed(enemyFirePower) / REVERSE_TUNER) / enemyDistance
        || tries > (enemyDistance / getBulletSpeed(enemyFirePower) / WALL_BOUNCE_TUNER)) {
            movementLateralAngle *= -1;
        }
        
        setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getRadarHeadingRadians()) * 2);
    }
    
    RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin,
        getBattleFieldWidth() - margin * 2, getBattleFieldHeight() - margin * 2, 75, 75);
    }
    
    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
        sourceLocation.getY() + Math.cos(angle) * length);
    }
    
    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
    
    private class Wave extends Condition {
        protected Point2D launchLocation;
        protected long launchTime;
        protected double heading;
        protected double direction;
        protected double power;
        protected int[] returnSegment;
        
        public Wave(int[] returnSegment) {
            launchLocation=robotLocation;
            launchTime=getTime();
            this.heading=enemyAbsoluteBearing;
            this.direction=enemyDirection;
            this.returnSegment = returnSegment;
            power = firePower;
        }
        
        public boolean test() {
            //if the distance from the wave origin to our enemy has passed the distance the bullet would have traveled...
            if (launchLocation.distance(enemyLocation) <= (getTime()-launchTime)*getBulletSpeed(power)) {
                if(enemyEnergy>0) {
                    returnSegment[(int)Math.round(((returnSegment.length-1)*((Math.max(-1, Math.min(1, (Utils.normalRelativeAngle(absoluteBearing(launchLocation,enemyLocation)-heading))/maxEscapeAngle(power)))*direction)+1))/2)]++;
                }
                removeCustomEvent(this);
            }
            return false;
        }
        
    }
    
}