package theo.avenge.gun;
import theo.avenge.Pequod;
import theo.avenge.wave.Wave;
import theo.avenge.utils.WaveUtils;
import theo.avenge.enemy.Enemy;
import java.util.*;
import java.awt.geom.*;
import java.awt.Color;
import java.awt.Graphics2D;
import robocode.*;
import robocode.util.*;
/**
 * MyClass - a class by (your name here)
 */
public class GHandler {


		protected final static long SHOT_TIMER = 3;
		protected final static long
				NUM_NEIGHBORS = 7;
		
		protected final static int DISTANCE_SEGMENTS = 12;

		static int gIndex, numTurrets = 7, distanceSegment;
		
		static double bPower, bSpeed, gunHeat, energy, theoryShots;//, realShots;
		double desiredAngle;

		public Pequod owner;

	//	static Turret[] turrets = new Turret[numTurrets];
	//	Turret aimingTurret;
		double[] stats = new double[11];

		static double[] realShots = new double[DISTANCE_SEGMENTS];
		
		String enemyName;
		Enemy enemy;
		
		List<Wave> neighborList, waveList = new ArrayList<Wave>();
		static List<double[]> keyList = new ArrayList<double[]>();
		
		static HashMap<double[], Wave> waveMap = new HashMap<double[], Wave>();
		
		static double[][] hits = new double[DISTANCE_SEGMENTS][numTurrets];
		static double[][] shots = new double[DISTANCE_SEGMENTS][numTurrets];
		static double[][] accuracies = new double[DISTANCE_SEGMENTS][numTurrets];
		static double[] angles = new double[numTurrets];
		static int turretUsed = 0;
		
		long time;
		
		public GHandler(Pequod owner, Enemy Enemy){
			this.owner = owner;
			this.enemy = Enemy;
		}

		public void update(ScannedRobotEvent e){
		
			enemyName = e.getName();
			this.gunHeat = owner.getGunHeat();
			this.energy = owner.getEnergy();
			this.time = owner.getTime();
			this.distanceSegment = (int)Math.floor(Enemy.distance/(owner.maxDistance/(double)DISTANCE_SEGMENTS));
			
			
			this.advanceWaves();
			this.calcBPower();
			this.calcStats();
			this.findNeighbors();
			this.calcWeights();
			this.takeAim();
			this.checkFire();
			this.clearWaveSet();
		}
		
		private void advanceWaves(){
			for(int i = 0; i < waveList.size(); i ++){
				Wave wave = waveList.get(i);
				wave.distTraveled = (this.time - wave.shotTime) * wave.velocity;
				waveList.set(i,wave);
				if(wave.distTraveled > (wave.startPoint.distance(Enemy.pos))){
					this.storeWave(wave);
					waveList.remove(wave);
					i --;
				}
			}
		}

		public void calcBPower(){
			if(owner.isMC){
				this.bPower = 3.0;
			}
			else{
				bPower = 2.1;
				if (Enemy.energy < 4.0){
					this.bPower =  WaveUtils.limit(0.1,Enemy.energy / 4.0,3.0);
				}
				else if (Enemy.energy <= 16.0){
					this.bPower = WaveUtils.limit(0.1,(Enemy.energy+2.0)/6.0,3.0);
				}
			}
			if(owner.energy<this.bPower&&owner.isMC){
				this.bPower = owner.energy;
			}
			this.bSpeed = WaveUtils.bSpeed(bPower);
		}

		private void calcStats(){
			this.stats[0] = Math.abs(Enemy.velocity)/8.0;
			this.stats[1] = Math.abs(Enemy.absBearing)/(Math.PI);
			this.stats[2] = Enemy.distance / owner.maxDistance;
			this.stats[3] = Math.abs(Enemy.lastVelocity)/8.0;
			this.stats[4] = Math.abs(Enemy.latVelocity)/8.0;
			this.stats[5] = Enemy.width;
			try{
				this.stats[6] = waveList.get(0).distTraveled/waveList.get(0).startPoint.distance(Enemy.pos);
			}
			catch(Exception e){
				this.stats[6] = 0.0;
			}
			this.stats[7] = radianToWallRatio();
			this.stats[8] = Enemy.getTorsionUnit();
			this.stats[9] = Enemy.timeSinceDirChange/(owner.maxDistance/11.0);
			
			for(int i = 0; i < stats.length; i ++){
				stats[i] = WaveUtils.limit(0d,stats[i],1d);
			}
		}
		
		private void findNeighbors(){
			this.neighborList = WaveUtils.findNearestNeighbors(
					this.stats.clone(), this.waveMap, NUM_NEIGHBORS);
		}

		private void calcWeights(){
			double maxWeight = 0; int o = 0;
			double[] offsetter = new double[neighborList.size()];
			boolean[] real = new boolean[neighborList.size()];
			
			for(Wave wave : neighborList){
				offsetter[o] = wave.resultOffset;
				real[o] = wave.isReal;
				o++;
			}
			
			Turret turret = new Turret(this, 0, enemy);
			turret.setOffsets(offsetter);
			turret.setReal(real);
			this.angles = (double[])turret.getAngles();
			
			this.desiredAngle = angles[turretUsed];
			
			
		}
		
		private void takeAim(){
			owner.setTurnGunRightRadians(
				Utils.normalRelativeAngle(desiredAngle - owner.getGunHeadingRadians()));
		}
		
		private void checkFire(){
			if(Math.abs(owner.getGunTurnRemainingRadians()) < Enemy.width / 2.0
				&& this.gunHeat == 0.0
					&& (this.energy > bPower
						| owner.isMC) && energy > 0.0
							&& (waveList.size() <= 1 
								| Enemy.energy < this.energy | true )){
				this.spawnWave(true);
			}
		}
		
		private void spawnWave(boolean isReal){
			Wave wave = new Wave();
			wave.isReal = isReal;
			wave.startPoint = (Point2D.Double)owner.ourPos.clone();
			wave.distTraveled = 0;
			wave.distance = Enemy.distance;
			wave.startBearing = Enemy.absBearing;
			wave.startAngle = Enemy.absAngle;
			wave.angles = (double[])this.angles.clone();
			wave.stats = (double[])this.stats.clone();
			wave.maxEscapeAngle = this.liveMaxEscapeAngle();
			wave.velocity = this.bSpeed;
			wave.shotTime = this.time;
			wave.distanceSegment = this.distanceSegment;
			this.shots[wave.distanceSegment][turretUsed] ++;
			this.theoryShots ++;
			
			waveList.add(wave.doClone());
			
			if(wave.isReal){
				owner.setFire(bPower);
				realShots[wave.distanceSegment] ++;
			}
		}
		
		private void checkHits(Wave wave){
			wave.endBearing = WaveUtils.absBearing(wave.startPoint,Enemy.pos);
			wave.resultOffset = getOffset(wave);
			for(int g = 0; g < wave.angles.length; g ++){
				double zeta = wave.angles[g];
				double ratio = Utils.normalRelativeAngle(wave.endBearing-zeta)/Enemy.width;
				if(WaveUtils.square(ratio)<=0.5){
					hits[wave.distanceSegment][g] ++;
				}
			}
			double accuracy = 0.0, maxAccuracy = 0.0;
			for(int i = 0; i < accuracies[0].length; i ++){
				accuracies[wave.distanceSegment][i] = (hits[wave.distanceSegment][i]/realShots[wave.distanceSegment]);
				if(accuracies[wave.distanceSegment][i]>maxAccuracy){
					maxAccuracy = accuracies[wave.distanceSegment][i];
				}
			}
			for(int i = 0; i < accuracies[0].length; i ++){
				accuracies[this.distanceSegment][i] = (hits[this.distanceSegment][i]/realShots[this.distanceSegment]);
				if(accuracies[this.distanceSegment][i]>maxAccuracy){
					maxAccuracy = accuracies[this.distanceSegment][i];
				}
			}
			for(int i = 0; i < accuracies[0].length; i ++){
				if(accuracies[this.distanceSegment][i] == maxAccuracy){
					turretUsed = i;
					break;
				}
			}
			
			String used;
			switch(turretUsed){
				case 0:
					used = "Main";
					break;
				case 1:
					used = "AS";
					break;
				case 2:
					used = "AS2";
					break;
				case 3:
					used = "AS3";
					break;
				case 4:
					used = "AS4";
					break;
				case 5:
					used = "HOT";
					break;
				case 6:
					used = "Circular";
					break;
				default:
					used = "Main";
					break;
			}


			/*System.out.println("Using turret: " + used + " at distance: " + this.distanceSegment);
			System.out.println("Accuracies  : ");
			System.out.println("Main        : " + treat(accuracies[this.distanceSegment][0]) + "%  " + "Shots   : " + shots[this.distanceSegment][0]);
			System.out.println("AS          : " + treat(accuracies[this.distanceSegment][1]) + "%  " + "Shots   : " + shots[this.distanceSegment][1]);
			System.out.println("AS2         : " + treat(accuracies[this.distanceSegment][2]) + "%  " + "Shots   : " + shots[this.distanceSegment][2]);
			System.out.println("AS3         : " + treat(accuracies[this.distanceSegment][3]) + "%  " + "Shots   : " + shots[this.distanceSegment][3]);
			System.out.println("AS4         : " + treat(accuracies[this.distanceSegment][4]) + "%  " + "Shots   : " + shots[this.distanceSegment][4]);
			System.out.println("HOT         : " + treat(accuracies[this.distanceSegment][5]) + "%  " + "Shots   : " + shots[this.distanceSegment][5]);
			System.out.println("Circular    : " + treat(accuracies[this.distanceSegment][6]) + "%  " + "Shots   : " + shots[this.distanceSegment][6]);
			System.out.println("-----------------------------");*/
		}
		
		private void storeWave(Wave wave){
			this.checkHits(wave);
			waveMap.put(wave.stats,wave);
			keyList.add(wave.stats);
			//Make it so he'll forget the entire shot (accuracy and shotsfired need changing);
			if(waveMap.keySet().size()>300*NUM_NEIGHBORS){
				waveMap.remove(keyList.get(0));
				keyList.remove(keyList.get(0));
			}
		}
		

				

		
		private void clearWaveSet(){
			neighborList.clear();
		}
		
	/*	private void createTurrets(){
			for ( int g = 0; g < turrets.length; g ++) {
				turrets[g] = new Turret(this, g, enemy);
			}
		}*/
		public double getBSpeed(){
			return this.bSpeed;
		}
		public double liveMaxEscapeAngle(){
			return Utils.normalRelativeAngle(Math.asin(8.0/bSpeed)*Enemy.latDirection);
		}
		public double getOffset(Wave wave){
			double offset = Utils.normalRelativeAngle(WaveUtils.absAngle(wave.startPoint,Enemy.pos)-wave.startAngle)/wave.maxEscapeAngle;
			return WaveUtils.limit(-1d,offset,1d);
		}
		

		////////////////////////////////////////////////////////////////////
		////////////////////////////////////////////////////////////////////
		//////////////////UTILITY METHODS///////////////////////////////////
		////////////////////////////////////////////////////////////////////
		////////////////////////////////////////////////////////////////////

		public void paint(Graphics2D g){
			for(Wave wave:waveList){
			//	if(wave.isReal){
					Point2D.Double point1, point2, point3, point4;
					point1 = WaveUtils.project(wave.startPoint,wave.distTraveled+wave.velocity,wave.angles[0]);
					point2 = WaveUtils.project(wave.startPoint,wave.distTraveled+wave.velocity,wave.angles[1]);
					point3 = WaveUtils.project(wave.startPoint,wave.distTraveled+wave.velocity,wave.angles[2]);
					point4 = WaveUtils.project(wave.startPoint,wave.distTraveled+wave.velocity,wave.angles[3]);
					g.setColor(Color.green);
					g.fillOval((int)point1.x-3,(int)point1.y-3,6,6);
					g.setColor(Color.blue);
					g.fillOval((int)point2.x-3,(int)point2.y-3,6,6);
					g.setColor(Color.red);
					g.fillOval((int)point3.x-3,(int)point3.y-3,6,6);
					g.setColor(Color.yellow);
					g.fillOval((int)point4.x-3,(int)point4.y-3,6,6);
			//	}
			}
		}

		double radianToWallRatio(){
			Point2D.Double projPos = (Point2D.Double)Enemy.pos.clone();
			double mEA = Math.abs(liveMaxEscapeAngle()), thetaOffset = 0;
			while(Math.abs(thetaOffset) < mEA && owner.playField.contains(projPos)){
				thetaOffset += 0.007 * Enemy.latDirection;
				projPos = WaveUtils.project(owner.ourPos, Enemy.distance, Enemy.absBearing + thetaOffset);
			}
			thetaOffset = Math.min(Math.abs(thetaOffset), mEA);
			return Math.abs(thetaOffset/mEA);
		}
		
		double treat(double input){
			return Math.round(input*10000.)/100.0;
		}
		
		//public void setRealShots(double num){
		//	realShots = num;
		//}

}

class Turret {
	
	GHandler owner;
	Enemy Enemy;
	
	int id;
	
	private double[] offsets;
	private boolean[] reals;
	
	private double mainWeight, mainDesiredOffset;
	private double asWeight, asDesiredOffset;

	public Turret(GHandler owner, int id, Enemy Enemy){
		this.id = id;
		this.owner = owner;
		this.Enemy = Enemy;
		this.offsets = new double[(int)GHandler.NUM_NEIGHBORS];
	}
	
	public double[] getAngles(){
		double[] gunAngles = new double[owner.numTurrets];
		gunAngles[0] = this.getMainGunAngle();
		gunAngles[1] = this.getAntiSurfAngle();
		gunAngles[2] = this.getAntiSurf2Angle();
		gunAngles[3] = this.getAntiSurf3Angle();
		gunAngles[4] = this.getAntiSurf4Angle();
		gunAngles[5] = Enemy.absBearing;
		gunAngles[6] = this.getCircularAngle();
		return gunAngles;
	}
	
	public double getWeight(){
		return this.mainWeight;
	}
	
	private double getMainGunAngle(){
		double density, maxDensity = 0, angle1;
		double desiredAngle = 0;
	//	int o = 0;
		for(double offset : this.offsets){
			angle1 = getLiveAngleForOffset(offset);
			density = 0;
			//o = 0;
			for(double offset2 : this.offsets){
				if(offset2 != offset){
					double angle2 = getLiveAngleForOffset(offset2);
					double ratio = Utils.normalRelativeAngle(angle2-angle1)/Enemy.width;
					if(Math.abs(ratio)<=0.5){
					//	if(reals[o]){
							density ++;
						//}
					//	else{
							//density += 0.2;
						//	density ++;
						//}
						//o++;
						if(density > maxDensity){
							maxDensity = density;
							desiredAngle = angle1;
							this.mainWeight = maxDensity;
							this.mainDesiredOffset = offset;
						}
					}
				}
			}
		}
		//System.out.println("Offset: " + this.mainDesiredOffset);
		return Utils.normalAbsoluteAngle(desiredAngle + Enemy.absBearing);
	}
	
	private double getAntiSurfAngle(){
		double density, maxDensity = 0, angle1;
		double desiredAngle = 0;
		int o = 0;
		for(double offset : this.offsets){
			angle1 = getLiveAngleForOffset(offset);
			density = 0;
			//o = 0;
			for(double offset2 : this.offsets){
				if(offset2 != offset){
					double angle2 = getLiveAngleForOffset(offset2);
					double ratio = Utils.normalRelativeAngle(angle2-angle1)/Enemy.width;
					if(Math.abs(ratio)>=.5){
					//	if(reals[o]){
							density += Math.pow(Math.E,-.5d*ratio*ratio);
						//}
						//o++;
						if(density > maxDensity){
							maxDensity = density;
							desiredAngle = angle1;
							this.asWeight = maxDensity;
							this.asDesiredOffset = offset;
						}
					}
				}
			}
		}
		//System.out.println("Offset: " + this.mainDesiredOffset);
		return Utils.normalAbsoluteAngle(desiredAngle + Enemy.absBearing);
	}
	
	private double getAntiSurf2Angle(){
		double density, maxDensity = 0, angle1;
		double desiredAngle = 0;
	//	int o = 0;
		for(double offset : this.offsets){
			angle1 = getLiveAngleForOffset(offset);
			density = 0;
			//o = 0;
			for(double offset2 : this.offsets){
				if(offset2 != offset){
					double angle2 = getLiveAngleForOffset(offset2);
					double ratio = Utils.normalRelativeAngle(angle2-angle1)/Enemy.width;
					/*if(Math.abs(ratio)>=.5){
						if(reals[o]){
							density += Math.pow(Math.E,.5d*ratio*ratio);
						}
					
						o++;
						if(density > maxDensity){
							maxDensity = density;
							desiredAngle = angle1;
							this.asWeight = maxDensity;
							this.asDesiredOffset = offset;
						}
					}*/
					if(Math.abs(ratio)<=2.0){
					//	if(reals[o]){
							density += Math.pow(Math.E,.5d*ratio*ratio);
						//}
					
						//o++;
						if(density > maxDensity){
							maxDensity = density;
							desiredAngle = Utils.normalRelativeAngle((angle1+angle2))/2.0;
							desiredAngle = Utils.normalRelativeAngle(angle1+(angle1-desiredAngle));
							this.asWeight = maxDensity;
							this.asDesiredOffset = offset;
						}
					}
				}
			}
		}
		//System.out.println("Offset: " + this.mainDesiredOffset);
		return Utils.normalAbsoluteAngle(desiredAngle + Enemy.absBearing);
	}
	
	private double getAntiSurf4Angle(){
		double density, maxDensity = 0, angle1;
		double desiredAngle = 0;
	//	int o = 0;
		for(double offset : this.offsets){
			angle1 = getLiveAngleForOffset(offset);
			density = 0;
		//	o = 0;
			for(double offset2 : this.offsets){
				if(offset2 != offset){
					double angle2 = getLiveAngleForOffset(offset2);
					double ratio = Utils.normalRelativeAngle(angle2-angle1)/Enemy.width;
					if(Math.abs(ratio)<=2.0){
					//	if(reals[o]){
							density += Math.pow(Math.E,.5d*ratio*ratio);
						//}
					
						//o++;
						if(density > maxDensity){
							maxDensity = density;
							desiredAngle = Utils.normalRelativeAngle((angle1+angle2))/2.0;
							desiredAngle = Utils.normalRelativeAngle(angle1-2*(angle1-desiredAngle));
							this.asWeight = maxDensity;
							this.asDesiredOffset = offset;
						}
					}
				}
			}
		}
		//System.out.println("Offset: " + this.mainDesiredOffset);
		return Utils.normalAbsoluteAngle(desiredAngle + Enemy.absBearing);
	}
	
	private double getAntiSurf3Angle(){
		double density, maxDensity = 0, angle1;
		double desiredAngle = 0;
	//	int o = 0;
		for(double offset : this.offsets){
			angle1 = getLiveAngleForOffset(offset);
			density = 0;
		//	o = 0;
			for(double offset2 : this.offsets){
				if(offset2 != offset){
					double angle2 = getLiveAngleForOffset(offset2);
					double ratio = Utils.normalRelativeAngle(angle2-angle1)/Enemy.width;
					if(Math.abs(ratio)<=2.0){
						//if(reals[o]){
							density += Math.pow(Math.E,.5d*ratio*ratio);
						//}
					
						//o++;
						if(density > maxDensity){
							maxDensity = density;
							desiredAngle = Utils.normalRelativeAngle((angle1+angle2))/2.0;
							this.asWeight = maxDensity;
							this.asDesiredOffset = offset;
						}
					}
				}
			}
		}
		//System.out.println("Offset: " + this.mainDesiredOffset);
		return Utils.normalAbsoluteAngle(desiredAngle + Enemy.absBearing);
	}
	
	private double getCircularAngle(){
		long time, nextTime, currTime = owner.owner.getTime();
		Point2D.Double p = (Point2D.Double)Enemy.pos.clone();
		for (int i = 0; i < 15; i++){
       		nextTime = (int)Math.round((p.distance(owner.owner.ourPos)/(owner.bSpeed)));
			time = currTime + nextTime;
        	p = guessPosition(time);
		}
		return WaveUtils.absAngle(owner.owner.ourPos,p);
	}
	
	private Point2D.Double guessPosition(double time){
		double diff = time - Enemy.cTime;
		double newY, newX;
		/**if the change in heading is significant, use circular targeting**/
		if (Math.abs(Enemy.changeHead) > 0.00001) {
			double radius = Enemy.velocity/Enemy.changeHead;
			double tothead = diff * Enemy.changeHead;
			newY = Enemy.pos.y + (Math.sin(Enemy.heading+ tothead) * radius) - (Math.sin(Enemy.heading) * radius);
			newX = Enemy.pos.x + (Math.cos(Enemy.heading) * radius) - (Math.cos(Enemy.heading + tothead) * radius);
		}
		/**If the change in heading is insignificant, use linear**/
		else {
			newY = Enemy.pos.y + Math.cos(Enemy.heading) * Enemy.velocity * diff;
			newX = Enemy.pos.x + Math.sin(Enemy.heading) * Enemy.velocity * diff;
		}
		return new Point2D.Double(newX, newY);
	}
	
	public void setOffsets(double[] offsets){
		this.offsets = offsets;
	}
	
	public void setReal(boolean[] reals){
		this.reals = reals;
	}

	double getLiveAngleForOffset(double offset){
		return Utils.normalRelativeAngle(Math.asin(8.0/owner.getBSpeed())*offset*Enemy.latDirection);
	}

}
