package zyx.mega.radar;

import static java.lang.Double.POSITIVE_INFINITY;
import static robocode.util.Utils.normalRelativeAngle;
import static zyx.mega.utils.TurnHandler._1v1_;
import static zyx.mega.utils.TurnHandler._melee_;
import static zyx.mega.utils.TurnHandler.others_;
import static zyx.mega.utils.TurnHandler.robot_;

import java.util.LinkedHashMap;

import zyx.mega.bot.Enemy;

public class Radar {
  public static boolean _paint_;
  public LinkedHashMap<Enemy, Double> hash_map_;
  public double scan_angle_;
  public Enemy sought_;
  public Radar() {
    if ( _melee_ ) hash_map_ = new LinkedHashMap<Enemy, Double>(5, 2, true);
  }
  public void Init() {
    if ( _melee_ ) hash_map_.clear();
    scan_angle_ = POSITIVE_INFINITY;
  }
  public void run() {
    if ( scan_angle_ == 0 ) scan_angle_ = POSITIVE_INFINITY;
    robot_.setTurnRadarRightRadians(scan_angle_);
  }
  public void onScannedRobot(Enemy enemy) {
    if ( _1v1_ ) scan_angle_ = normalRelativeAngle(enemy.bearing_ - robot_.getRadarHeadingRadians()) * 1.999;
    else {
      hash_map_.put(enemy, enemy.bearing_);
      //System.out.printf("radar(%s): %d(%s): %d %d\n", sought_, time_, enemy, hash_map_.size(), others_);
      if ( (enemy == sought_ || sought_ == null) && hash_map_.size() == others_ ) {
        scan_angle_ = normalRelativeAngle(hash_map_.values().iterator().next() - robot_.getRadarHeadingRadians()) * POSITIVE_INFINITY;
        sought_ = hash_map_.keySet().iterator().next();
        //System.out.println(scan_dir_);
      }
    }
  }
  public void onRobotDeath(Enemy enemy) {
    hash_map_.remove(enemy);
    sought_ = null;
  }
}
