package zyx.mega.targeting.melee;


import static java.lang.Double.POSITIVE_INFINITY;
import static java.lang.Math.min;
import static zyx.mega.targeting.melee.MeleeGun._paint_;
import static zyx.mega.utils.TurnHandler.time_;
import static zyx.mega.utils.wave.WaveHit.ALL_IN;

import java.awt.Color;

import zyx.debug.painter.Painter;
import zyx.mega.bot.Bot;
import zyx.mega.bot.Enemy;
import zyx.mega.geometry.Point;

public class MeleeVShot {
  public Enemy enemy_;
  public Bot position_;
  public int gun_;
  public int previous_;
  public double best_;
  
  public MeleeVShot(Enemy enemy, Bot position, int gun) {
    enemy_ = enemy;
    position_ = position;
    gun_ = gun;
    previous_ = ALL_IN;
    best_ = POSITIVE_INFINITY;
  }

  public void FindHitRange(MeleeShootingWave wave) {
    Bot _1ago_ = enemy_._1ago_.enemy_;
    double dx = (_1ago_.x_ - enemy_.x_) / enemy_.scans_difference_;
    double dy = (_1ago_.y_ - enemy_.y_) / enemy_.scans_difference_;
    Bot sim = new Bot(enemy_);
    int i = 0;
    while ( true ) {
      sim.x_ += dx;
      sim.y_ += dy;
      wave.Update(time_ - i++);
      sim.bbox_.Update();
      if ( !wave.Hit(sim).AllOut() ) break;
    }
    while ( true ) {
      best_ = min(best_, sim.distanceSq(position_));
      sim.x_ += dx;
      sim.y_ += dy;
      wave.Update(time_ - i++);
      sim.bbox_.Update();
      if ( wave.Hit(sim).AllIn() ) break;
    }
  }
  public void FindHitEnd(MeleeShootingWave wave) {
    Bot _1ago_ = enemy_._1ago_.enemy_;
    double dx = (enemy_.x_ - _1ago_.x_) / enemy_.scans_difference_;
    double dy = (enemy_.y_ - _1ago_.y_) / enemy_.scans_difference_;
    Bot sim = new Bot(_1ago_);
    for ( int i = 0; i < enemy_.scans_difference_; ++i ) {
      best_ = min(best_, sim.distanceSq(position_));
      sim.x_ += dx;
      sim.y_ += dy;
      if ( _paint_ ) Painter.Add(sim, new Color(164, 255, 128, 128));
      wave.Update(time_ - enemy_.scans_difference_ + i);
      sim.bbox_.Update();
      if ( wave.Hit(sim).AllOut() ) break;
    }
  }
  public void FindHitStart(MeleeShootingWave wave) {
    Bot _1ago_ = enemy_._1ago_.enemy_;
    double dx = (_1ago_.x_ - enemy_.x_) / enemy_.scans_difference_;
    double dy = (_1ago_.y_ - enemy_.y_) / enemy_.scans_difference_;
    Bot sim = new Bot(enemy_);
    for ( int i = 0; i < enemy_.scans_difference_; ++i ) {
      best_ = min(best_, sim.distanceSq(position_));
      sim.x_ += dx;
      sim.y_ += dy;
      if ( _paint_ ) Painter.Add(sim, new Color(164, 255, 128, 128));
      wave.Update(time_ - i);
      sim.bbox_.Update();
      if ( wave.Hit(sim).AllIn() ) break;
    }
  }
  public void InterpolateAll() {
    Bot _1ago_ = enemy_._1ago_.enemy_;
    double dx = (_1ago_.x_ - enemy_.x_) / enemy_.scans_difference_;
    double dy = (_1ago_.y_ - enemy_.y_) / enemy_.scans_difference_;
    Point sim = new Point(enemy_);
    for ( int i = 0; i < enemy_.scans_difference_; ++i ) {
      best_ = min(best_, sim.distanceSq(position_));
      sim.x_ += dx;
      sim.y_ += dy;
      if ( _paint_ ) Painter.Add(sim, new Color(164, 255, 128, 128));
    }
  }
}
