package rc.yoda.utils;

import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;

/** 
 * Factory - by Robert Codd (Gorded) 
 *
 * This code is here by released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL
 * (Basically it means you must keep the code public if you base any bot on it)
 *
 * Factory.java : v1.0 -- 2007/05/12
 */

/**
 * Factory is utility class designed to 
 * dynamically instantiate all classes
 * from a folder that implement or extend
 * a reference Class object 
 *
 * @author Robert Codd
 * @version v1.0
 */
public class Factory
{		
	/**
	 * A Class object that all loaded class must either extend or implement
	 */
	private Class reference;
	
	/**
	 * An array of parameters needed to Instantiate all loaded classes
	 */
	private Object[] parameters;
	
	private Class[] classObjs;
		
	/**
	 * Class constructor specficfying the castable type, class parametes, canonical path to classes and the package of the classes
	 */
	public Factory(Class reference, Object[] parameters, Class... classObjs) {
		this.reference = reference;
		this.parameters = parameters;
		this.classObjs = classObjs;
	}

	/**
	 * Converts the Object from loadClasses into an Object array
	 * that is directly castable to the type reference
	 *
	 * @return Object an array that is directly castable to the type reference
	 */
	public Object[] getClasses() {
		Object[] classes = loadClasses(),
			array = (Object[]) Array.newInstance(reference,classes.length);
		System.arraycopy(classes, 0, array, 0, classes.length);
		return array;
	}

	/**
	 * Instantiates classes from the class paths retrived 
	 * from listClasses, checks for castabilty and creates 
	 * an array of Objects with the loaded Classes
	 *
	 * @return Object an array that is indirectly castable to the type reference
	 */
	private Object[] loadClasses() {
		ArrayList classes = new ArrayList();
		
		for (Class object : classObjs)
		{		
			try {
				if (castable(object)) { classes.add(object.getConstructors()[0].newInstance(parameters)); }
			} catch (Exception e) { System.out.println(e + " " + e.getCause()); }
		}  	
		return classes.toArray();
	}

	/**
	 * Checks if the loaded class is a child
	 * class of reference or if the class implements 
	 * the interface reference
	 *
	 * @return boolean if the loaded class can be casted to the type reference
	 */
	private boolean castable(Class instance) {
		if (instance == null) { return false; }
		if (reference.isInterface()) { if (castable(instance.getInterfaces())) { return true; }	}
		else if (reference == instance) { return true; } 
		return castable(instance.getSuperclass()); 
	}

	/**
	 * Check if one of the implemented interfaces 
	 * of the loaded class is castable to the Interface 
	 * represented by reference Class Object
	 *
	 * @return boolean if the loaded class can be casted to the interface reference
	 */
	private boolean castable(Class[] interfaces) {
		for (int count = 0; count < interfaces.length; count++) { if (interfaces[count] == reference) { return true; } }
		return false;
	}
}