package rc.yoda.utils;

import java.awt.geom.Point2D;

/** 
 * Wave - by Robert Codd (Gorded) 
 *
 * This code is here by released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL
 * (Basically it means you must keep the code public if you base any bot on it)
 *
 * Wave.java : v1.0 -- 2007/05/12
 */ 

/**
 * Wave - A class which contains 
 * needed info for recontructing 
 * a wave of bullets
 *
 * @author Robert Codd
 * @version v 1.0
 */
public class Wave
{
	/**
	 * This Waves point of orgin
	 */
	public Point2D.Double fireLocation;
	
	/**
	 * The time at which this wave was fired
	 */
	public long fireTime;
	
	/**
	 * The speed at which this wave is traveling
	 */
	public double bulletVelocity;
	
	/**
	 * The angle at which the target was when this Wave was fired
	 */
	public double directAngle;
	
	/**
	 * The distance this Wave has traveled since the time it was fired
	 */
	public double distanceTraveled;
	
	/**
	 * The direction the targetted robot was travelling when this Wave was fired
	 */	
	public int direction;
	
	/**
	 * If factor stats are segmented then this Waves indexes are stored for reference on logging
	 */
	public int[] segments;
	
	/**
	 * Class Constructor
	 */
	public Wave() {}
		
	/**
	 * Calculates the time in which it will take 
	 * this Wave to reach to specified target
	 * 
	 * @param Point2D.Double location of Wave target
	 * @return double the amount of ticks it will take to reach the target
	 */
	public double flightTime(Point2D.Double target) { 
		return (target.distance(fireLocation) - distanceTraveled) / bulletVelocity; 
	}
}