package kawigi.nano;
import robocode.*;

/**
 * ThnikkaBot - a nano guess-factor robot by Kawigi.  Finally got one in!  I've worked on this idea
 * off and on for about 8 months probably.  Thanks to PEZ, David and Nano for reminding me to try
 * and get this working again.
 *
 * If you can't get Falcon small enough and Nemo's source doesn't make any sense, maybe this can
 * help out anyone else trying to nano-ize a guess factor gun.  If it does, share the knowledge
 * (at least with me, fair's fair, right?)
 *	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*
 * I'd like to see YOU stay focused when you're staring down the barrel of a loaded ThnikkaBot.
 * Hey, shut up, kids!
 *
 *		http://www.homestarrunner.com/sbemail97.html
 */
public class ThnikkaBot extends AdvancedRobot
{
	static int/*[]*/[] stats = new int/*[13]*/[25];
	//I can barely effectively use 65536 frames here, so I hope you don't plan on this thing acting reliably over more than about 200 rounds.
	static double[] bearings = new double[70000];
	static int[] directions = new int[70000];
	static double currentBearing;
	static int index;
	
	public void run()
	{
		turnRadarRight(Double.POSITIVE_INFINITY);
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		int tempindex = ++index;
		double absBearing;
		setTurnRightRadians(Math.cos(absBearing = e.getBearingRadians()));
		
		//Basically, diff is their current latv and bearings[index] is the sum of their first index latv's.
		double diff;
		//accessing the global static variables is bigger than accessing local variables
		bearings[tempindex] = (currentBearing += (diff = Math.sin(e.getHeadingRadians() - (absBearing += getHeadingRadians()))*e.getVelocity()));
		
		//ok, basically, my movement is kind of like yours, something like an opposing mirror movement:
		setAhead(diff*4);
		//old-fashioned FunkyChicken 1.0 movement would be a little better, or at least more stable...
		//setAhead(Math.tan(e.getEnergy()*5)*500);
		
		//get the lateral direction for now and save it for later
		int direction = (directions[tempindex] = (int)(diff/Math.abs(diff)));
		int distance = (int)e.getDistance();
		//int[] current;
		//Here, I find the lateral distance they've traveled over the last distance/11 ticks and divided it by the distance to find the bearing offset that would hit them now (if fired distance/11 ticks ago)
		//the cast to a char is so that tempindex is always positive (even if the stuff at that array index is 0).  Then I can get away with not handling exceptions :-)  Of course, it's pretty useless after 200 rounds
		//with 9 more bytes, I could do distance segmentation.  Then I could cream FunkyChicken.  Let me know if you find them!
		/*(current = */stats/*[(distance = (int)e.getDistance())/100])*/[(int)(((currentBearing-bearings[tempindex = (char)(tempindex - distance/11)])/distance*directions[tempindex]+1)*12)]++;
		//if bestindex were set to 12 at the beginning, it would start out shooting straight at the enemy instead of behind it...
		int bestindex = 0, i = 25;
		do
		{
			i--;
			if (stats[i] > stats[bestindex])
				bestindex = i;
		}
		while (i > 0);
		
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing - getGunHeadingRadians() + direction*(bestindex-12)/12.0));
		setFire(3);
		setTurnRadarLeft(getRadarTurnRemaining());
	}
}
