package kc.serpent;
import kc.serpent.melee.*;
import kc.serpent.movement.*;
import kc.serpent.gun.*;
import kc.serpent.utils.*;
import robocode.*;
import robocode.util.Utils;
import java.util.*;
import java.awt.Color;
import java.awt.geom.*;
import wiki.mc2k7.*;


/**
 * Hydra - a robot by Kevin Clark (Kev)
 * See http://robowiki.net/cgi-bin/robowiki?Hydra fot details.
 */
public class Hydra extends AdvancedRobot {
	public static boolean isTC = false;
	public static boolean isMC = false;
	public static boolean isPainting = false; 
	
	DuelMovementDC duelMovement;
	DuelGunDC duelGun;
	RaikoGun raikoGun;
	RobotPredictor robotPredictor = new RobotPredictor();
	
	long lastScannedTime = -1;
	ScannedRobotEvent lastScanEvent;
	static int[] finishes;
	static int wallHits = 0;
	static int skippedTurns = 0;
	
	public void run() {
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		setColors(new Color(0, 2, 1), new Color(0, 40, 50), new Color(255, 0, 0));
		
		if(finishes == null) {
			finishes = new int[getOthers() + 1];
		}
				
		if(!isMC) {
			DuelGunDC.isTC = isTC;
			duelGun = new DuelGunDC(this, robotPredictor);
			duelGun.init();
		} else {
			raikoGun = new RaikoGun(this);
		}
	
		DuelMovementDC.isMC = isMC;
		duelMovement = new DuelMovementDC(this);
		duelMovement.init();
		
		do {
			if(lastScannedTime + 1 <= getTime()) {
				setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			}
			if(getOthers() == 0 && !isTC) {
				duelMovement.onScannedRobot(lastScanEvent);
			}
			execute();
		} while(true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		lastScanEvent = e;
		lastScannedTime = getTime();
		
		if(!isTC) {
			duelMovement.onScannedRobot(e);
		}
		if(!isMC) {
			duelGun.onScannedRobot(e);
		} else {
			//raikoGun.onScannedRobot(e);
		}
		
		double radarTurn = Utils.normalRelativeAngle(getHeadingRadians() + e.getBearingRadians() - getRadarHeadingRadians());
		setTurnRadarRightRadians(radarTurn += KUtils.sign(radarTurn) * KUtils.botWidthAngle(35.0, e.getDistance()));
	}
	
	public void onBulletHit(BulletHitEvent e) {
		if(!isTC) {
			duelMovement.onBulletHit(e);
		}
		if(!isMC) {
			duelGun.onBulletHit(e);
		}
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		if(!isTC) {
			duelMovement.onHitByBullet(e);
		}
	}

	public void onBulletHitBullet(BulletHitBulletEvent e) {
		if(!isTC) {
			duelMovement.onBulletHitBullet(e);
		}
	}
	
	public void onDeath(DeathEvent e) {
		Vector v = getAllEvents();
		Iterator i = v.iterator();
		while(i.hasNext()) {
			Object obj = i.next();
			if(obj instanceof HitByBulletEvent && !isTC) {
				duelMovement.onHitByBullet((HitByBulletEvent) obj);
			}
		}
		printStats();
	}
	
	public void onWin(WinEvent e) {
		printStats();
	}
	
	public void printStats() {
		if(!isMC) {
			duelGun.printStats();
		}
		if(!isTC) {
			duelMovement.printStats();
		}
		
		out.println("skipped turns: " + skippedTurns);
		finishes[getOthers()]++;
		for (int i=0; i < finishes.length; i++) {
			out.print((i == getOthers() ? "*" : "") + finishes[i] + " ");
		}
		out.println();
	}
	
	public void onPaint(java.awt.Graphics2D g) {
		if(isPainting) {
			duelMovement.onPaint(g);
		} 
	}
	
	public void onSkippedTurn(SkippedTurnEvent e) {
		skippedTurns++;
	}
	
	public void onHitWall(HitWallEvent e) {
		wallHits++;
	}
	
	public void setTurnRightRadians(double turn) {
		robotPredictor.setTurnRightRadians(turn);
		super.setTurnRightRadians(turn);
    }

    public void setAhead(double d) {
		robotPredictor.setAhead(d);
		super.setAhead(d);
    }

    public void setMaxVelocity(double v) {
		robotPredictor.setMaxVelocity(v);
		super.setMaxVelocity(v);
    }
}
