package kc.serpent.movement;
import kc.serpent.*;
import kc.serpent.utils.*;
import robocode.*;
import robocode.util.Utils;
import java.io.*;
import java.util.*;
import java.awt.geom.*;
import java.awt.Color;

public class DuelMovementDC {
	public static boolean isMC = false;
	public static boolean isMelee = false;
	AdvancedRobot robot;
	
	public DuelMovementDC(AdvancedRobot robot) {
		this.robot = robot;
	}
	
	static final double PI = Math.PI;
	static final double SMOOTH_MARGIN = 25.0;
	static final double LOW_HIT_RATE = 0.05;
	static final int RECORDED_HITS = 200;
	static final int RECORDED_POSITION_TICKS = 8;
	static final int CLUSTER_SIZE = 12;
	static final int DIMENSIONS = 8;
	static final int SIMPLE_WEIGHTING_SYSTEMS = 5;
	static final int ADVANCED_WEIGHTING_SYSTEMS = 5;
	static final double ROLLING = 0.3;
	static double MAX_DISTANCE;
	static double NORMAL_BULLET_SPEED;
	static double NORMAL_ESCAPE_ANGLE;
	static double NORMAL_MAX_IMPACT_TIME;
	static final double[][] WEIGHT_SYSTEM = new double[ADVANCED_WEIGHTING_SYSTEMS][DIMENSIONS]; {
		WEIGHT_SYSTEM[0] = new double[] {6, 5, 0, 0, 0, 0, 0, 0};
		WEIGHT_SYSTEM[1] = new double[] {6, 5, 5, 0, 0, 0, 0, 0};
		WEIGHT_SYSTEM[2] = new double[] {0, 5, 5, 5, 0, 0, 0, 15};
		WEIGHT_SYSTEM[3] = new double[] {8, 4, 2, 0, 0, 5, 2, 0};
		WEIGHT_SYSTEM[4] = new double[] {6, 5, 5, 4, 0, 5, 2, 0};
	};
	static final double[] EXPONENTS = new double[]  {0.3, 0.5, 0.7, 0.75, 1};//{0.3, 0.5, 0.65, 0.7, 0.75, 1};
	static final double[] SIMPLE_EXPONENTS = new double[] {0.3, 0.5, 0.7, 0.75, 1};//{0.3, 0.5, 1};
	
	//BattleFieldInfo
	Point2D.Double myLocation;
	Point2D.Double enemyLocation;
	Point2D.Double center;
	static double battleFieldHeight;
	static double battleFieldWidth;
	static Rectangle2D battleField;
	static Rectangle2D smoothingField;
	
	long gameTime = -1;
	int myClockDirection = 1;
	double absoluteBearing;
	double myHeading;
	double myVelocity;
	double enemyEnergy = 100;
	double enemyVelocity;
	double enemyDistance;
	int lastClockDirection = 1;
	double lastDistance;
	double lastVelocity;
	double lastAcceleration;
	long lastAccelTime = 0;
	double lastAccelTimer;
	double lastDLET;
	double lastRelativeHeading;
	double lastWallAhead;
	double lastWallReverse;
	ArrayList myPositionHistory = new ArrayList();
	
	//Movement Data
	PossibleMove[][] move = new PossibleMove[3][3]; 
	
	static int enemyShots;
	static int enemyHits;
	static int specialCase;
	int nonHeadOnHits = 0;
	int currentDirection = 1;
	int antiRamMode = 0;

	static ArrayList data = new ArrayList();
	//Wave Data
	long lastEnemyFireTime = 0;
	double lastEnemyBulletPower = 3;
	
	EnemyWave nearestSurfableWave;
	EnemyWave secondarySurfableWave;
	EnemyWave nearestActiveWave;
	ArrayList surfableWaves = new ArrayList(0); 
	ArrayList activeWaves = new ArrayList(0);
	ArrayList enemyWaves = new ArrayList(0);
	
	//Dance Variables
	int danceRobotTurnDirection = 1;
	int danceGunTurnDirection = -1;
	int danceRadarTurnDirection = 1;
	
	public void init() {
		move[0][0] = new PossibleMove(-1, -1);
		move[0][1] = new PossibleMove(-1, 0);
		move[0][2] = new PossibleMove(-1, 1);
		move[1][0] = new PossibleMove(0, -1);
		move[1][1] = new PossibleMove(0, 0);
		move[1][2] = new PossibleMove(0, 1);
		move[2][0] = new PossibleMove(1, -1);
		move[2][1] = new PossibleMove(1, 0);
		move[2][2] = new PossibleMove(1, 1);
		
		battleFieldHeight = robot.getBattleFieldHeight();
		battleFieldWidth = robot.getBattleFieldWidth();
		center = new Point2D.Double(battleFieldWidth / 2, battleFieldHeight / 2);
		smoothingField = KUtils.makeField(battleFieldWidth, battleFieldHeight, SMOOTH_MARGIN);
		battleField = KUtils.makeField(battleFieldWidth, battleFieldHeight, 18.3);
	
		MAX_DISTANCE = Math.max(robot.getBattleFieldWidth(), robot.getBattleFieldHeight());
		NORMAL_BULLET_SPEED = isMC ? 11 : 14.3;
		NORMAL_ESCAPE_ANGLE = Math.asin(8 / NORMAL_BULLET_SPEED);
		NORMAL_MAX_IMPACT_TIME = MAX_DISTANCE / NORMAL_BULLET_SPEED;
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		if(gameTime != robot.getTime()) {
			setVariables();
		}
		if(robot.getOthers() > 0) {
			enemyLocation = KUtils.projectMotion(myLocation, myHeading + e.getBearingRadians(), e.getDistance());
		}
		enemyDistance = myLocation.distance(enemyLocation);
		absoluteBearing = KUtils.absoluteBearing(myLocation, enemyLocation);
		if(myVelocity != 0) {
			myClockDirection = -KUtils.sign(Math.sin(myHeading - absoluteBearing) * myVelocity);
		}
	
		double wallDamage = 0;
		if(Math.abs(e.getVelocity()) == 0 && Math.abs(enemyVelocity) > 2.0) {
			wallDamage = Math.max(0, (Math.abs(enemyVelocity) / 2) - 1);
		}
		enemyVelocity = e.getVelocity();
		double energyDifference = enemyEnergy - e.getEnergy() - wallDamage;
		enemyEnergy = e.getEnergy();
		if(energyDifference > 0.09999 && energyDifference < 3.0001){
			lastEnemyFireTime = gameTime - 1; 
			lastEnemyBulletPower = energyDifference;
		}
		
		EnemyWave w = new EnemyWave();
		w.active = 2;
		w.source = enemyLocation;
		w.target = myLocation;
		w.speed = KUtils.bulletSpeed(lastEnemyBulletPower);
		w.fireTime = gameTime;
		w.power = lastEnemyBulletPower;
		w.clockDirection = lastClockDirection;
		w.waveNode = new Node(lastDistance, Math.abs(lastVelocity), lastAcceleration, lastAccelTimer, lastDLET, lastWallAhead, lastWallReverse, lastRelativeHeading);
		
		enemyWaves.add(w);
		updateWaves();
		
		if((Math.abs(Utils.normalRelativeAngle(absoluteBearing - e.getHeadingRadians())) < PI/6 && enemyVelocity < -4)
			||(Math.abs(Utils.normalRelativeAngle(absoluteBearing - e.getHeadingRadians() - PI)) < PI/6 && enemyVelocity > 4)
			||(enemyDistance < 60.0)) {
			if(enemyDistance < 133.0) {
				antiRamMode = 1;
			} else { 
				antiRamMode = 2;
			}
		} else {
			antiRamMode = 0;
		}
		
		if(antiRamMode == 1 || !surfableWaveExists()) {
			if(robot.getOthers() > 0) {
				optimizePosition();
			} else {
				doDance();
			}
		}else { 
			surf();
		}
		
		int roundsLeft = robot.getNumRounds() - robot.getRoundNum() - 1;
		if(!isMelee 
			&& surfableWaveExists()
			&& !isMC 
			&& enemyHits == 0
			&& ((nearestSurfableWave.power <= 0.3 && roundsLeft < 6)
				||(roundsLeft < 3 && nearestSurfableWave.power < 3 - roundsLeft))) {
					robot.setMaxVelocity(0);		
		} 
		
		lastAcceleration = Math.abs(myVelocity - lastVelocity) * (Math.abs(myVelocity) < Math.abs(lastVelocity) ? -1 : 1);
		lastDistance = enemyDistance;
		lastVelocity = myVelocity;
		if(Math.abs(lastAcceleration) > 0.1) {
			lastAccelTime = gameTime;
		}
		lastAccelTimer = ((double)(gameTime) - (double)(lastAccelTime)) / w.speed;
		lastClockDirection = myClockDirection;
		
		myPositionHistory.add((Point2D.Double)(myLocation));
		if(myPositionHistory.size() > RECORDED_POSITION_TICKS + 1) {
			myPositionHistory.remove(0);
		}
		Point2D.Double latestPoint = myLocation;
		Point2D.Double earliestPoint = (Point2D.Double)(myPositionHistory.get(0));
		lastDLET = latestPoint.distance(earliestPoint);
		
		lastWallAhead = 1.5 * NORMAL_ESCAPE_ANGLE;
		lastWallReverse = 1.5 * NORMAL_ESCAPE_ANGLE;
		for(lastWallAhead = 0; lastWallAhead <= 1.5 * NORMAL_ESCAPE_ANGLE; lastWallAhead += 0.1){
			Point2D.Double projectedLocation = KUtils.projectMotion(enemyLocation, absoluteBearing + PI + (myClockDirection * lastWallAhead), enemyDistance);
			if(!battleField.contains(projectedLocation)) {
				break;
			}
		}
		for(lastWallReverse = 0; lastWallReverse <= 1.5 * NORMAL_ESCAPE_ANGLE; lastWallReverse += 0.1){
			Point2D.Double projectedLocation = KUtils.projectMotion(enemyLocation, absoluteBearing + PI - (myClockDirection * lastWallReverse), enemyDistance);
			if(!battleField.contains(projectedLocation)) {
				break;
			}
		}
		lastWallAhead /= KUtils.maxEscapeAngle(w.speed);
		lastWallReverse /= KUtils.maxEscapeAngle(w.speed);
		
		lastRelativeHeading = Math.abs(Utils.normalRelativeAngle(myHeading - absoluteBearing + Math.PI + (myVelocity > 0 ? 0 : PI)));
	}
	
	public void optimizePosition() {
		robot.setMaxVelocity(8);
		int bestDriveDirection = 0;
		double bestTurn = 0;
		double maxValue = Double.NEGATIVE_INFINITY;
		double centerDistance = myLocation.distance(center);
		
		for(double i = 0; i < 2*PI; i+= (2*PI) / 120) {
			double relativeTurn = Utils.normalRelativeAngle(i - myHeading);
			int virtualDirection = 1;
			if(relativeTurn < -PI/2) {
				relativeTurn += PI;
				virtualDirection = -1;
			}
			if(relativeTurn > PI/2) {
				relativeTurn -= PI;
				virtualDirection = -1;
			}
			
			Point2D.Double testLocation = KUtils.projectMotion(myLocation, i, 180);
			double value = Math.abs(Math.sin(Utils.normalRelativeAngle(absoluteBearing - i)));
			if(enemyEnergy > 10) {
				value += ((testLocation.distance(enemyLocation) - enemyDistance) / enemyDistance) * (gameTime < 50 ? 5 : 2);
			} else {
				value -= ((testLocation.distance(enemyLocation) - enemyDistance) * enemyDistance) / 125000;
			}
			value -= (testLocation.distance(center) - centerDistance) / 5000;
			if(antiRamMode == 1) {
				testLocation = KUtils.projectMotion(myLocation, i, 1);
				value = Math.abs(Math.sin(Utils.normalRelativeAngle(absoluteBearing - i))) / 2;
				value += (testLocation.distance(enemyLocation) - enemyDistance) * 30;
				value -= (testLocation.distance(center) - centerDistance) * 3;
				testLocation = KUtils.projectMotion(myLocation, i, 150.0);
			}
			
			if(!smoothingField.contains(testLocation)) {
				continue;
			}
			if(value > maxValue){
				maxValue = value;
				bestTurn = relativeTurn;
				bestDriveDirection = virtualDirection;
			} 
		}
		
		currentDirection = bestDriveDirection;
		robot.setTurnRightRadians(bestTurn + (antiRamMode == 1 ? KUtils.sign(bestTurn) : 0));
		robot.setAhead(Double.POSITIVE_INFINITY * currentDirection);
	}
	
	public void surf() {
		robot.setMaxVelocity(8);
	
		for(int i = 0; i < 3; i++) {
			move[i][0].setVariables(myLocation, myHeading, myVelocity, 1, 0.01, false);
			move[i][0].setLocation(true);
			move[i][0].setRisk(true, false, false);
			move[i][0].riskMod = Math.pow(enemyDistance / move[i][0].location.distance(enemyLocation), KUtils.quadratic(enemyDistance, 5.4700855e-6, -0.00936752, 6));
		}	
				
		if(!(move[0][0].hitWall && move[2][0].hitWall)) {
			if(move[0][0].hitWall) {
				move[0][0].riskMod *= 100;
			}
			if(move[2][0].hitWall) {
				move[2][0].riskMod *= 100;
			}
		} 
		if(move[1][0].hitWall) {
			move[1][0].riskMod *= 100;
		}
		if(antiRamMode == 2) {
			move[1][0].riskMod *= 1000; 
		}
	
		if(secondarySurfableWave != null && specialCase > -1) {
			for(int i = 0; i < 3; i++) {
				move[i][1].setVariables(move[i][0]);
				move[i][2].setVariables(move[i][0]);
			}	
			for(int i = 0; i < 3; i++) {
				for(int ii = 0; ii < 3; ii++) {
					move[i][ii].setLocation(false);
					move[i][ii].setRisk(false, true, false);
					move[i][ii].risk *= move[i][ii].riskMod;
				}
			}
		} else {
			for(int i = 0; i < 3; i++) {
				move[i][1].risk = Double.POSITIVE_INFINITY;
				move[i][2].risk = Double.POSITIVE_INFINITY;
				move[i][0].risk *= move[i][0].riskMod;
			}
		}
		
		PossibleMove bestMove = move[0][0];
		for(int i = 0; i < 3; i++) {
			for(int ii = 0; ii < 3; ii++) {
				if(move[i][ii].risk < bestMove.risk){
					bestMove = move[i][ii];
				}
			}
		}
		
		currentDirection = bestMove.firstDirection == 0 ? currentDirection : bestMove.firstDirection;
		robot.setMaxVelocity(bestMove.firstDirection == 0 ? 0 : 8);
		robot.setAhead(Double.POSITIVE_INFINITY * currentDirection);
		robot.setTurnRightRadians(bestMove.initialTurn);
	}
	
	public class PossibleMove {
		Point2D.Double location;
		double heading;
		double velocity;
		
		double initialTurn;
		int firstDirection;
		int secondDirection;
		double risk;
		double riskMod;
		boolean hitWall;
		int time;
		
		public PossibleMove(int firstDirection, int secondDirection) {
			this.firstDirection = firstDirection;
			this.secondDirection = secondDirection;	
		}
		
		public void setVariables(Point2D.Double location, double heading, double velocity, int time, double risk, boolean hitWall) {
			this.location = new Point2D.Double(location.getX(), location.getY());
			this.heading = heading;
			this.velocity = velocity;
			this.time = time;
			this.risk = risk;
			this.riskMod = riskMod;
			this.hitWall = hitWall;
		}
	
		public void setVariables(PossibleMove p) {
			this.location = new Point2D.Double(p.location.getX(), p.location.getY());
			this.heading = p.heading;
			this.velocity = p.velocity;
			this.risk = p.risk;
			this.hitWall = p.hitWall;
			this.time = p.time;
			this.riskMod = p.riskMod;
			this.initialTurn = p.initialTurn;
		}
		
		public void setLocation(boolean surfingFirst) {
			double waveBearing;
			int testDirection = surfingFirst ? firstDirection : secondDirection;
			Wave surfingWave = surfingFirst ? nearestSurfableWave : secondarySurfableWave;
			do {
				double absoluteBearing = KUtils.absoluteBearing(location, enemyLocation);
				waveBearing = KUtils.absoluteBearing(location, surfingWave.source);
				double targetHeading = optimumHeading(location, heading, absoluteBearing, testDirection == 0 ? currentDirection : testDirection);
				double targetTurn = Utils.normalRelativeAngle(targetHeading - heading);
				if(time == 1 && surfingFirst) {
					initialTurn = targetTurn;
				}
				
				heading += RobotPredictor.turnIncrement(targetTurn, velocity);
				velocity = RobotPredictor.nextVelocity(velocity, testDirection, testDirection == 0 ? 0 : 8);
				location = KUtils.projectMotion(location, heading, velocity);
				if(!battleField.contains(location) && surfingFirst) {
					hitWall = true;
				}
			} while(surfingWave.radius + (++time * surfingWave.speed) < location.distance(surfingWave.source) - KUtils.realBotWidth(waveBearing, 18.0));
		}
		
		public void setRisk(boolean surfFirst, boolean surfSecond, boolean surfOthers) {
			Iterator i = surfableWaves.iterator();
			while(i.hasNext()) {
				double addedRisk = 1;
				EnemyWave w = (EnemyWave)(i.next());
				
				if(!surfFirst && w == nearestSurfableWave) {
					continue;
				}
				if(!surfSecond && w == secondarySurfableWave) {
					continue;
				}
				if(!surfOthers && w != nearestSurfableWave && w != secondarySurfableWave) {
					return;
				}
				
				boolean isDangerous = (surfFirst && w == nearestSurfableWave);// || 
				                      //(surfSecond && w == secondarySurfableWave && secondarySurfableWave.impactTime - nearestSurfableWave.impactTime < 6);
				double GF = w.getGF(location);
				double windowFactor = KUtils.windowFactor(
									  KUtils.realBotWidth(KUtils.absoluteBearing(w.source, location), 25.0), 
									  location.distance(w.source), KUtils.maxEscapeAngle(w.speed));
									
				if(specialCase == 0) {
					risk += (KUtils.eighth(2 - Math.abs(GF))
							+ (Math.abs(GF) > windowFactor ? 0 : (isDangerous ? 512.0 : 0.0)))
							* KUtils.sqr(w.weight);
					return;
				}
				
				double rolling = 1;
				if(specialCase == 2) {
					rolling = ROLLING;
				}
			
				for(int ws = 0; ws < (specialCase == 1 ? SIMPLE_WEIGHTING_SYSTEMS : ADVANCED_WEIGHTING_SYSTEMS); ws++) {
					double thisRisk = 1;
					for(int c = 0; c <= w.filledSlots[ws]; c++) {
						double diff = Math.abs(GF - w.GFList[ws][c]);
						if(specialCase == 2) {
							thisRisk *= 1 - rolling;
						}
						thisRisk += rolling *
						    	    (1 / Math.sqrt(w.deviationList[ws][c] + 2)) * 
								    (diff < windowFactor ? (isDangerous ? 32 + (KUtils.fourth(2 - diff) / 2) : 16 + (KUtils.fourth(2 - diff) / 3)) : KUtils.fourth(2 - diff));
					}
					
					addedRisk *= specialCase == 1 ? Math.pow(thisRisk, SIMPLE_EXPONENTS[ws]) : Math.pow(thisRisk, EXPONENTS[ws]);
				}
				if(specialCase == 1) {
					risk += addedRisk * w.weight;
				} else {
					//risk *= Math.pow(addedRisk, w.weight);
					risk += addedRisk * w.weight;
					//risk *= addedRisk;
				}
			}
		}
	}
	
	/*public static boolean isSimilar(double newValue, double oldValue) { 
		if(specialCase == 2) {
			return true;
		} else {
			return (newValue < oldValue + 0.75 || newValue < 1);
		}
	}*/

	double optimumHeading(Point2D.Double location, double heading, double absoluteBearing, int direction) {
		int orbitDirection = -KUtils.sign(Math.sin(heading - absoluteBearing) * direction);
		
		double distance = location.distance(enemyLocation);
		double evasion = 0;
		if(specialCase == 0) {
			evasion = KUtils.quartic(distance, -1.77739e-12, 3.49197e-9, -2.96805e-6, 0.0016218, -0.398912);
		}
		if(specialCase == 1) {
			evasion = KUtils.quartic(distance, -1.09266e-12, 3.99994e-9, -4.98975e-6, 0.0027317, -0.505602);
		}
		if(specialCase == 2) {
			evasion = KUtils.quartic(distance, -1.15151515e-12, 3.68686869e-9, -4.39393939e-6, 0.0032434343, -0.895454545);
		}
		if(antiRamMode == 1) {
			evasion = -0.9;
		}
		double bestHeading;
		double smoothedHeading = bestHeading = (Math.abs(Utils.normalRelativeAngle(absoluteBearing - heading + (PI/2))) < Math.abs(Utils.normalRelativeAngle(absoluteBearing - heading - (PI/2))) 
								               ? absoluteBearing + (PI/2) : absoluteBearing - (PI/2))
								               + (evasion * orbitDirection);
		
		double stick = Math.min(170.0, distance);
		boolean top = false;
		boolean right = false;
		boolean bottom = false;
		boolean left = false;
		int smoothedWall = 0;//1 = top, 2 = right, 3 = bottom, 4 = left
		Point2D.Double predictedLocation = KUtils.projectMotion(location, smoothedHeading, stick * direction);
		if(predictedLocation.getX() < SMOOTH_MARGIN) {
			left = true;
		} else if(predictedLocation.getX() > battleFieldWidth - SMOOTH_MARGIN) {
			right = true;
		}
		if(predictedLocation.getY() < SMOOTH_MARGIN) {
			bottom = true;
		} else if(predictedLocation.getY() > battleFieldHeight - SMOOTH_MARGIN){
			top = true;
		}
		
		if(top) {
			if(right) {
				if(orbitDirection == 1) {smoothedWall = 2;}
				else {smoothedWall = 1;}
			} else if(left) {
				if(orbitDirection == 1) {smoothedWall = 1;}
				else {smoothedWall = 4;}
			} else {
				smoothedWall = 1;
			}
		}
		else if(bottom) {
			if(right) {
				if(orbitDirection == 1) {smoothedWall = 3;}
				else{smoothedWall = 2;}
			} else if(left) {
				if(orbitDirection == 1) {smoothedWall = 4;}
				else{smoothedWall = 3;}
			} else {
				smoothedWall = 3;
			}
		} else {
			if(right) {smoothedWall = 2;}
			else if(left) {smoothedWall = 4;}
		}
		
		if(smoothedWall == 1) {
			smoothedHeading = orbitDirection * Math.acos((battleFieldHeight - SMOOTH_MARGIN - location.getY()) / stick);
		} else if(smoothedWall == 2) {
			smoothedHeading = (PI/2) + (orbitDirection * Math.acos((battleFieldWidth - SMOOTH_MARGIN - location.getX()) / stick));
		} else if(smoothedWall == 3) {
			smoothedHeading = PI + (orbitDirection * Math.acos((location.getY() - SMOOTH_MARGIN) / stick));
		} else if(smoothedWall == 4) {
			smoothedHeading = (3*PI/2) + (orbitDirection * Math.acos((location.getX() - SMOOTH_MARGIN) / stick));
		}
		if(direction == -1 && smoothedWall != 0) {
			smoothedHeading += PI;
		}
		
		return smoothedHeading;
	}
	
	public void setWaveNodes() {
		Iterator i = surfableWaves.iterator();
		while(i.hasNext()) {
			EnemyWave w = (EnemyWave)(i.next());
			setWaveNodes(w);
		}
	}

	public void setWaveNodes(EnemyWave w) {
		for(int ws = 0; ws < (specialCase == 0 ? SIMPLE_WEIGHTING_SYSTEMS : ADVANCED_WEIGHTING_SYSTEMS); ws++) {
			double[] weights = WEIGHT_SYSTEM[ws];
					
			double[] deviationList = new double[CLUSTER_SIZE];
			double[] GFList = new double[CLUSTER_SIZE];
			int[] indexList = new int[CLUSTER_SIZE];
			w.filledSlots[ws] = 0;
			for(int a = 0; a < CLUSTER_SIZE; a++) {
				deviationList[a] = Double.POSITIVE_INFINITY;
			}
			
			for(int testIndex = data.size() - 1; testIndex >= 0; testIndex--) {
				Node test = (Node)(data.get(testIndex));
				double deviation = 0;
				boolean considered = true;
				double recentFactor = specialCase == 2 ? Math.pow(data.size() + 5 - testIndex, (1/4)) : 1;
				for(int compareIndex = 0; compareIndex < DIMENSIONS; compareIndex++) {
					if(weights[compareIndex] == 0) {
						continue;
					}
					deviation += recentFactor * weights[compareIndex] * KUtils.sqr(test.data[compareIndex] - w.waveNode.data[compareIndex]);
					if(deviation > deviationList[CLUSTER_SIZE - 1]) {// || !isSimilar(deviation, deviationList[0])) {
						considered = false;
						break;
					}
				}	
						
				if(considered) {
					for(int compare = 0; compare <= w.filledSlots[ws]; compare++) {
						if(deviation <= deviationList[compare]) {
							for(int refill = w.filledSlots[ws]; refill > compare; refill--) {
								deviationList[refill] = deviationList[refill - 1];
								GFList[refill] = GFList[refill - 1];
								indexList[refill] = indexList[refill - 1];
							}
							w.filledSlots[ws] = Math.min(w.filledSlots[ws] + 1, CLUSTER_SIZE - 1);
							deviationList[compare] = deviation;
							GFList[compare] = test.GF;
							indexList[compare] = testIndex;
							break;
						}				
					}
				}
			}	 
						
			for(int b = 0; b <= w.filledSlots[ws]; b++) {
				w.indexList[ws][b] = 100000;
			}
			
			for(int test = 0; test <= w.filledSlots[ws]; test++) {
				for(int compare = 0; compare <= w.filledSlots[ws]; compare++) {
					if(indexList[test] < w.indexList[ws][compare]) {
						for(int refill = w.filledSlots[ws]; refill > compare; refill--) {
							w.deviationList[ws][refill] = w.deviationList[ws][refill - 1];
							w.GFList[ws][refill] = w.GFList[ws][refill - 1];
							w.indexList[ws][refill] = w.indexList[ws][refill - 1];
						}
						w.deviationList[ws][compare] = deviationList[test];
						w.GFList[ws][compare] = GFList[test];
						w.indexList[ws][compare] = indexList[test];
						break;
					}			
				}
			}	
		}
	}

	public void updateWaves() {
		int n = 0;
		while (n < enemyWaves.size()) {
			EnemyWave w = (EnemyWave)(enemyWaves.get(n));
			n++;
			if((lastEnemyFireTime == w.fireTime)&&(w.active == 2)) {
				w.active = 1;
				w.power = lastEnemyBulletPower;
				w.speed = KUtils.bulletSpeed(lastEnemyBulletPower);
				setWaveNodes(w);
				
				surfableWaves.add(w);
				activeWaves.add(w);
			}
			
			double angle = KUtils.absoluteBearing(myLocation, w.source);
			w.distance = myLocation.distance(w.source);
			w.impactTime = (int)(Math.max((w.distance - w.radius - KUtils.realBotWidth(angle, 18.0)) / w.speed, 1));
			w.weight = (w.power + 2) / (w.impactTime + 1);
			w.setRadius(gameTime);
			
			if(w.radius + 18.0 + w.speed >= w.distance && w.active == 1) {
				w.active = 0;
				surfableWaves.remove(w);
				enemyShots++;
			}
			if(w.radius - KUtils.realBotWidth(angle, 30.0) >= w.distance) {
				enemyWaves.remove(w);
				activeWaves.remove(w);
				n--;
			}
		}
		
		secondarySurfableWave = null;
		nearestSurfableWave = null;
		
		long lowestImpactTime = Long.MAX_VALUE;
		long secondLowestImpactTime = Long.MAX_VALUE;
		Iterator i = surfableWaves.iterator();
		while(i.hasNext()) {
			EnemyWave w = (EnemyWave)(i.next());
			if(w.impactTime <= lowestImpactTime) {
				secondLowestImpactTime = lowestImpactTime;
				secondarySurfableWave = nearestSurfableWave;
				lowestImpactTime = w.impactTime;
				nearestSurfableWave = w;
			} else if (w.impactTime <= secondLowestImpactTime) {
				secondLowestImpactTime = w.impactTime;
				secondarySurfableWave = w;
			}
		}
		
		lowestImpactTime = Long.MAX_VALUE;
		i = activeWaves.iterator();
		while(i.hasNext()) {
			EnemyWave w = (EnemyWave)(i.next());
			if(w.impactTime <= lowestImpactTime) {
				lowestImpactTime = w.impactTime;
				nearestActiveWave = w;
			}
		}
		
		/*if(nearestSurfableWave != null) {
			nearestSurfableWave.weight = Math.sqrt(nearestSurfableWave.weight);
		}	
		if(secondarySurfableWave != null) {
			secondarySurfableWave.weight = Math.sqrt(secondarySurfableWave.weight);
		}*/
		
		if(specialCase == 1 && (double)(enemyHits) / (double)(enemyShots) > LOW_HIT_RATE && (robot.getRoundNum() > 2 || isMelee)) {
			specialCase = 2;
		}
		if(specialCase == 2 && (double)(enemyHits) / (double)(enemyShots) <= LOW_HIT_RATE && (robot.getRoundNum() > 2 || isMelee)) {
			specialCase = 1;
		}
	}
	
	public boolean surfableWaveExists() {
		return surfableWaves.size() > 0;
	}
	
	public boolean activeWaveExists() {
		return activeWaves.size() > 0;
	}
	
	public void setVariables() {
		gameTime = robot.getTime();
		myLocation = new Point2D.Double(robot.getX(), robot.getY());
		myHeading = robot.getHeadingRadians();
		myVelocity = robot.getVelocity();
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		if(gameTime != robot.getTime()) {
			setVariables();
			updateWaves();
		}
		
		enemyEnergy += e.getPower() * 3;
		
		if(robot.getOthers() > 0) {
			enemyHits++;
		}
		
		if(antiRamMode == 1) {
			return;
		}
		
		Iterator i = activeWaves.iterator();
		EnemyWave hitWave = nearestActiveWave;
		while(i.hasNext()) {
			EnemyWave w = (EnemyWave)(i.next());
			if(e.getPower() == w.power && w.impactTime == 1) {
				hitWave = w;
				break;
			}
		}
		if(activeWaveExists() && hitWave.impactTime < 2) {
			Point2D.Double bulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
			double GF = hitWave.getGF(bulletLocation);
			registerHit(GF, hitWave);
			
			if(specialCase == 0 && Math.abs(GF) > 0.3 && (isMelee || ++nonHeadOnHits > (robot.getRoundNum() < 5 ? 0 : 1))) {
				specialCase = 1;
			}
		} else {
			System.out.println("UNREGISTERED HIT");
		}
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		if(gameTime != robot.getTime()) {
			setVariables();
			updateWaves();
		}
		
		Bullet b = e.getHitBullet();
		Point2D.Double bulletLocation = new Point2D.Double(b.getX(), b.getY());
		
		double closestMatch = Double.POSITIVE_INFINITY;
		Iterator i = activeWaves.iterator();
		EnemyWave hitWave = nearestActiveWave;
		while(i.hasNext()) {
			EnemyWave w = (EnemyWave)(i.next());
			double thisMatch = Math.abs(w.source.distance(bulletLocation) - w.radius) * (Math.abs(w.power - b.getPower()) < 0.01 ? 0.01 : 10);
			if(thisMatch < closestMatch) {
				closestMatch = thisMatch;
				hitWave = w;
			}
		}
		
		if(closestMatch < 0.25) {
			double GF = hitWave.getGF(bulletLocation);
			registerHit(GF, hitWave);
		} else {
			System.out.println("UNREGISTERED BULLET COLLISION");
		}
	}
	
	public void registerHit(double GF, EnemyWave w) {
		w.waveNode.GF = GF;
		data.add(w.waveNode);
		if(data.size() > 200) {
			data.remove(0);
		} 
	
		setWaveNodes();
	}	
	
	public void onBulletHit(BulletHitEvent e) {
		double power = e.getBullet().getPower();
		enemyEnergy -= (4 * power) + (2 * Math.max(power - 1, 0));
	}
	
	public class EnemyWave extends Wave {
		int impactTime;
		double power;
		
		int[][] indexList = new int[ADVANCED_WEIGHTING_SYSTEMS][CLUSTER_SIZE];
		double[][] deviationList = new double[ADVANCED_WEIGHTING_SYSTEMS][CLUSTER_SIZE];
		double[][] GFList = new double[ADVANCED_WEIGHTING_SYSTEMS][CLUSTER_SIZE];
		int[] filledSlots = new int[ADVANCED_WEIGHTING_SYSTEMS];
		Node waveNode;
	}

	public class Node {
		public double[] data = new double[DIMENSIONS];
		public double GF;
		
		public Node(double bulletImpactTime, double velocity, double accel, double accelTimer, double dlet, double wallAhead, double wallReverse, double relativeHeading) {
			data[0] = Math.min(bulletImpactTime / NORMAL_MAX_IMPACT_TIME, 1);
			data[1] = velocity / 8;
			data[2] = KUtils.minMax(accel, -2, 1) / 3;
			data[3] = Math.min(accelTimer / 1.5, 1);
			data[4] = dlet / (8 * RECORDED_POSITION_TICKS);
			data[5] = Math.min(wallAhead, 1.5) / 1.5;
			data[6] = Math.min(wallReverse, 1.5) / 1.5;
			data[7] = relativeHeading / PI;
		}
	}
	
	public void doDance() {
		robot.setAdjustGunForRobotTurn(false);
		robot.setAdjustRadarForGunTurn(false);
		robot.setAdjustRadarForRobotTurn(false);
		if(Math.random() < 0.05) {
			danceRobotTurnDirection *= -1;
		}
		if(Math.random() < 0.05) {
			danceGunTurnDirection *= -1;
		}
		if(Math.random() < 0.05) {
			danceRadarTurnDirection *= -1;
		}
		robot.setTurnRightRadians(danceRobotTurnDirection * Double.POSITIVE_INFINITY);
		robot.setTurnGunRightRadians(danceGunTurnDirection * Double.POSITIVE_INFINITY);
		robot.setTurnRadarRightRadians(danceRadarTurnDirection * Double.POSITIVE_INFINITY);
		robot.setMaxVelocity(0);
	}
	
	public void printStats() {
		System.out.println("special case: " + specialCase);
		System.out.println("enemy hit rate: " + enemyHits + "/" + enemyShots + " = " + (100 * (float)(enemyHits)/(float)(enemyShots)) + "%");
	}

	public void onPaint(java.awt.Graphics2D g) {
		if(gameTime != robot.getTime()) {
			setVariables();
			updateWaves();
		}
		Iterator i = enemyWaves.iterator();
		while (i.hasNext()) {
			EnemyWave w = (EnemyWave)(i.next());
			g.setColor(w.active == 2 ? Color.gray : Color.yellow);
			if(w == nearestSurfableWave) {
				g.setColor(Color.red);
			}
			if(w == secondarySurfableWave) {
				g.setColor(Color.orange);
			}
			if(w.active == 0) {
				g.setColor(Color.darkGray);
			}
			g.drawOval((int)(w.source.getX() - w.radius),
					   (int)(w.source.getY() - w.radius),
					   (int)(2 * w.radius),
					   (int)(2 * w.radius));
			
			if(w.active == 2) {
				continue;
			}
			
			Point2D.Double l = KUtils.projectMotion(w.source, KUtils.absoluteBearing(w.source, w.target), w.radius + 20);
			g.setColor(Color.white);
			g.drawString(String.valueOf(100 * Math.sqrt(w.weight) / Math.sqrt(nearestSurfableWave.weight)), (float)l.getX(), (float)l.getY());
		}
	}
}
