package klein;

import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.*;

import robocode.*;

public class GottesKrieger extends TeamRobot {
	/*========= Constants ===========*/
	public static final int PREDICTION_TROY = 0;
	public static final int PREDICTION_LINEAR = 1;
	public static final int PREDICTION_CIRCULAR = 2;
	public static final int PREDICTION_CIRCULAR_RW = 3;
	public static final int PREDICTION_GUESS_FACTOR = 4;
	public static final int DODGE_TROY = 0;
	public static final int DODGE_SLOW = 1;
	public static final int DODGE_REVERSE = 2;
	public static final int WALL_CORRECTION_REVERSE = 0;
	public static final int WALL_CORRECTION_TURN = 1;
	public static final int GUESS_FACTOR_MODE = 0;
	public static final int GUESS_FACTOR_MEAN = 1;
	public static final int MOVEMENT_ORBIT = 0;
	public static final int MOVEMENT_RANDOM = 1;
	public static final int MOVEMENT_RAM = 2;
	public static final int MOVEMENT_WAVE = 3;
	public static final int MOVEMENT_CENTER = 4;
	public static final double SQRT2 = Math.sqrt(2);
	public static final double PI = Math.PI;
	public static final double PI2 = 2*Math.PI;
	
	/*========= Options ============*/
	/* Radar */
	public static final boolean RADAR_TRACK_AWARENESS_SCAN = true;
	public static final long RADAR_TRACK_AWARENESS_SCAN_INT = 64;
	public static final boolean RADAR_TRACKING_DISABLE = false;
	public static final double RADAR_TRACK_WIDTH = Math.toRadians(40);
	public static final long RADAR_INACTIVITY_AGE = 20;
	
	/* Navigation */
	public static final int MOVEMENT_ENEMY = MOVEMENT_ORBIT;
	public static final int MOVEMENT_ENEMY_LOW = MOVEMENT_RAM;
	public static final int MOVEMENT_NO_TARGET = MOVEMENT_RANDOM;
	public static final boolean DISABLE_MOVEMENT = false;
	/* Navigation - Wall */
	public static final int WALL_CORRECTION_TYPE = WALL_CORRECTION_TURN;
	public static final double WALL_NEAR_THRESHOLD = 120;//120 works well
	/* Navigation - Orbit */
	public static final double MIN_ORBIT_RADIUS = 120;
	public static final double MAX_ORBIT_RADIUS = 400;
	public static final double ORBIT_APPROACH_RADIUS = 400;
	public static final double EMERGENCY_DISTANCE = 200;
	/* Navigation - Dodging */
	public static final int DODGE = DODGE_SLOW | DODGE_REVERSE;
	public static final int DODGE_SLOW_SPEED = 0;
	public static final int DODGE_REVERSE_MIN_TIME = 40;
	/* Navigation - Ram */
	final double RAM_ADJUSTMENT_MAX = 90;
	final double RAM_STRAIGHT_DISTANCE = 200;
	
	/* Weapons */
	public static final boolean DISABLE_RAM_MODE = false;
	public static final boolean DISABLE_FIRE = false;
	public static final double FIRE_POWER = 3;
	public static final int PREDICTION_TYPE = PREDICTION_GUESS_FACTOR;
	public static final double ROBOT_WIDTH = 36;
	public Random rand = new Random();
	
	/* Preciction - GuessFactor */
	public static final int GUESS_FACTOR_RESOLUTION = 35;
	public static final double GUESS_FACTOR_RANGE = 1.5;
	public static final int GUESS_FACTOR_TYPE = GUESS_FACTOR_MODE;
	
	/* Ally */
	//public static final String[] ALLY_CLASSES = {""};
	
	/* Colors */
	public static final Color COLOR_PRIMARY = Color.RED;
	public static final Color COLOR_ORBIT = Color.RED;
	public static final Color COLOR_RAM = Color.GREEN;
	public static final Color COLOR_SCAN = Color.WHITE;
	public static final Color COLOR_BODY = Color.BLACK;
	
	public void init(){
		
		
		//body,gun,radar
		setColors(Color.BLACK,Color.RED,Color.RED);
		setScanColor(Color.RED);
		setBulletColor(Color.RED);
		
		setAdjustRadarForGunTurn(false);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(false);
		
		enemies.clear();
		self = new EnemyRecord(getName());
		enemies.put(getName(),self);
		self.updateSelf();
		
	}
	
	public void run(){
		init();
		mainLoop();
	}
	
	boolean radarTrack = false;
	
	/* Main Loop */
	public void mainLoop(){
		execute();
		
		
		while(true){
			/* Radar step includes pointing the radar, and updating target info */
			//System.out.println("Running step "+getTime());
			radarStep();
			targeterStep();
			if(target == null){
				/* If we dont have a target, we really cant to much */
				setGunColor(Color.WHITE);
				//centerStep();
				moveStep(MOVEMENT_NO_TARGET);
			} else {
				setMaxVelocity((DISABLE_MOVEMENT)?0:Rules.MAX_VELOCITY);
				if(!DISABLE_RAM_MODE && getEnergy() > 3*target.getEnergy()){//If the enemy has low energy
					setGunColor(Color.GREEN);
					moveStep(MOVEMENT_ENEMY_LOW);
				} else {
					setGunColor(Color.RED);
					moveStep(MOVEMENT_ENEMY);
				}
				weaponStep();
				if(putOffAnal.containsKey(getTime())){
					guessFactorAnalyze(putOffAnal.remove(getTime()));
				}
			}
			/* Now just wait for this step to end; */
			teamStep();
			execute();
			
			self.updateSelf();
			//waitFor(step);
		}
	}
	
	public void teamStep(){
		try {
			//System.out.println(new Pair(getX(), getY()));
			for(String en:enemies.keySet()){
				for(Message m:enemies.get(en).getUpdateMessages())
					broadcastMessage(m);
			}
			
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	double rand_maxVel = Rules.MAX_VELOCITY;
	double rand_heading = 0;
	double rand_headingdir = 1;
	boolean rand_forwards = true;
	
	public void randomStep(){
		if(rand.nextInt(15) == 0){//Switch heading change dir
			rand_headingdir = Math.toRadians(rand.nextInt(12) - 6);
		}
		if(rand.nextInt(35) == 0 || getHitRobotEvents().size() > 0){//Switch  dir
			getHitRobotEvents().clear();
			rand_forwards = !rand_forwards;
		}
		if(rand.nextInt(20) == 0 && rand_maxVel < Rules.MAX_VELOCITY){//Vel up
			rand_maxVel += 1;
		} else if(rand.nextInt(18) == 0 && rand_maxVel > 4){//Vel down
			//rand_maxVel -= 1;
		}
		rand_heading += rand_headingdir;
		this.setMaxVelocity(rand_maxVel);
		setPointRobot(rand_heading);
		if(rand_forwards){
			setAhead(100);
		} else {
			setBack(100);
		}
		
		if(nearWall()){	
			setPointRobot(rand_forwards?awayFromWall():(PI+awayFromWall()));
			rand_heading = rand_forwards?awayFromWall():(PI+awayFromWall());
			
		} else {
			this.setBodyColor(Color.BLACK);
		}
		
		
	}
	
	public void moveStep(int type){
		if(DISABLE_MOVEMENT){
			setAhead(0);
		} else switch(type){
			case MOVEMENT_ORBIT:
				orbitStep();
				break;
			case MOVEMENT_RANDOM:
				randomStep();
				break;
			case MOVEMENT_RAM:
				ramStep();
				break;
			case MOVEMENT_CENTER:
				centerStep();
				break;
			case MOVEMENT_WAVE:
				
				break;
			
		}
	}
	public void targeterStep(){
		
		//if(target.scanAge() > )
		
		if(target != null && target.isDead())
			target = null;
		
		for(String s:enemies.keySet()){
			if(!enemies.get(s).log.isEmpty() && enemies.get(s).getEstDistance(0) < EMERGENCY_DISTANCE && !enemies.get(s).isDead() && enemies.get(s) != self){
				target = null;
			}
		}
		
		if(target == null){
			radarTrack = false;
			EnemyRecord close = null;
			for(String s:enemies.keySet()){
				EnemyRecord l = enemies.get(s);
				if(l != self && !isTeammate(l.name) && !l.isDead() && 
						(close == null || l.getEstDistance() <= close.getEstDistance()))
					close = l;
			}
			if(close != null){
				target = close;
				radarTrack = true;
			}
		}
	}
	
	public void weaponStep(){
		double firepower = (FIRE_POWER);
		double firevel = 20 - 3 * firepower;
		long aproxtime = (long) (target.getEstDistance()/firevel);
		//* This loop makes it more accurate */ 
		for(int i = 0; i < 5;i++)
			aproxtime = (long)(target.getEstDistance(aproxtime)/firevel);
		
		/**/
		setPointGun(target.getEstBearing(aproxtime));
		
		disp_aimX = target.getLocation(aproxtime).x;
		disp_aimY = target.getLocation(aproxtime).y;
		
		if(!DISABLE_FIRE && Math.abs(target.getEstBearing(aproxtime) - getGunHeadingRadians()) < 
				Math.atan2(ROBOT_WIDTH*SQRT2, target.getEstBearing())){
			//setFire(firepower);
			Bullet b = setFireBullet(firepower);
			if(b != null){
				fireLog.put(b,new FireLogEntry(b, target, new Pair(getX(),getY())));
			}
		}
		//setFireBullet(power);
			
		
	}
	double disp_aimX;
	double disp_aimY;
	double disp_targetHdg = 0;
	public void onPaint(java.awt.Graphics2D g){
		g.setColor(forwards?Color.YELLOW:Color.CYAN);
		double v = 70;
		if(!forwards)disp_targetHdg +=PI;
		g.drawLine((int)getX(),(int)getY(),(int)(getX() + (Math.sin(disp_targetHdg)*v)),(int)(getY() + Math.cos(disp_targetHdg) * v));
		
		v = 15000;
		g.setColor(Color.WHITE);
		if(target != null && !target.log.isEmpty())disp_targetHdg = target.getEstBearing();
		g.drawLine((int)getX(),(int)getY(),(int)(getX() + (Math.sin(disp_targetHdg)*v)),(int)(getY() + Math.cos(disp_targetHdg) * v));
		
		v = 1000000;
		g.setColor(Color.GREEN);
		disp_targetHdg = this.getGunHeadingRadians();
		g.drawLine((int)getX(),(int)getY(),(int)(getX() + (Math.sin(disp_targetHdg)*v)),(int)(getY() + Math.cos(disp_targetHdg) * v));
		
		g.setColor(Color.WHITE);
		g.drawOval((int)disp_aimX, (int)disp_aimY, 10, 10);
		
		for(String s:enemies.keySet()){
			//if(enemies.get(s) == self)continue;
			
			if(isTeammate(enemies.get(s).name) || enemies.get(s) == self){
				g.setColor(Color.GREEN);
			} else {
				g.setColor(Color.RED);
			}
			
			if(!enemies.get(s).isDead()){
				int t = 0;
				long getTime = getTime();
				while(t++ < getTime){
					if(t%10 != 0)continue;
					Pair p = enemies.get(s).getLocationAt(t);
					if(p != null){
						double hdg = enemies.get(s).getHeadingAt(t);
						double vel = enemies.get(s).getVelocityAt(t);
						g.drawLine((int)p.x,(int)p.y, (int)(p.x + (Math.sin(hdg)*(vel*4))),(int)(p.y + (Math.cos(hdg) * (vel*4))));
						g.drawOval((int)p.x-5,(int)p.y-5,5,5);
						g.drawString("" + t, (int)p.x-4, (int)p.y - 13);
					}
				}
			}
				g.drawOval((int)enemies.get(s).getLocation(0).x-18, (int)enemies.get(s).getLocation(0).y-18, 36*(int)SQRT2, 36*(int)SQRT2);
				
				
				g.setColor(Color.WHITE);
				g.drawOval((int)enemies.get(s).getLocation(0).x-(int)(EMERGENCY_DISTANCE/2), (int)enemies.get(s).getLocation(0).y-(int)(EMERGENCY_DISTANCE/2), (int)(EMERGENCY_DISTANCE), (int)(EMERGENCY_DISTANCE));
			
				if(PREDICTION_TYPE == PREDICTION_GUESS_FACTOR){
					long dist = (long)(enemies.get(s).getEstDistance()/Rules.getBulletSpeed(3));
					g.setColor(Color.YELLOW);
					double gf = 1;
					int size = 10;
					g.drawOval((int)enemies.get(s).getGuessFactorLocation(dist,gf).x-(size/2), (int)enemies.get(s).getGuessFactorLocation(dist,gf).y-(size/2), size, size);
					size = 5;
					gf = .75;
					g.drawOval((int)enemies.get(s).getGuessFactorLocation(dist,gf).x-(size/2), (int)enemies.get(s).getGuessFactorLocation(dist,gf).y-(size/2), size, size);
					size = 7;
					gf = .5;
					g.drawOval((int)enemies.get(s).getGuessFactorLocation(dist,gf).x-(size/2), (int)enemies.get(s).getGuessFactorLocation(dist,gf).y-(size/2), size, size);
					size = 5;
					gf = .25;
					g.drawOval((int)enemies.get(s).getGuessFactorLocation(dist,gf).x-(size/2), (int)enemies.get(s).getGuessFactorLocation(dist,gf).y-(size/2), size, size);
					g.setColor(Color.CYAN);
					size = 5;
					gf = -.25;
					g.drawOval((int)enemies.get(s).getGuessFactorLocation(dist,gf).x-(size/2), (int)enemies.get(s).getGuessFactorLocation(dist,gf).y-(size/2), size, size);
					
					
					size = 7;
					gf = -.5;
					g.drawOval((int)enemies.get(s).getGuessFactorLocation(dist,gf).x-(size/2), (int)enemies.get(s).getGuessFactorLocation(dist,gf).y-(size/2), size, size);
					size = 5;
					gf = -.75;
					g.drawOval((int)enemies.get(s).getGuessFactorLocation(dist,gf).x-(size/2), (int)enemies.get(s).getGuessFactorLocation(dist,gf).y-(size/2), size, size);
					
					size = 10;
					gf = -1;
					g.drawOval((int)enemies.get(s).getGuessFactorLocation(dist,gf).x-(size/2), (int)enemies.get(s).getGuessFactorLocation(dist,gf).y-(size/2), size, size);
					
					g.setColor(new Color(0xFF,0x00,0xFF));
					size = 12;
					gf = enemies.get(s).guessFactor();
					g.drawOval((int)enemies.get(s).getGuessFactorLocation(dist,gf).x-(size/2), (int)enemies.get(s).getGuessFactorLocation(dist,gf).y-(size/2), size, size);
					}
		}
		g.setColor(Color.PINK);
		
		g.drawLine(0, 0+(int)WALL_NEAR_THRESHOLD, (int)getBattleFieldWidth(), 0+(int)WALL_NEAR_THRESHOLD);
		g.drawLine(0, (int)getBattleFieldHeight()-(int)WALL_NEAR_THRESHOLD, (int)getBattleFieldWidth(), (int)getBattleFieldHeight()-(int)WALL_NEAR_THRESHOLD);
		g.drawLine(0+(int)WALL_NEAR_THRESHOLD, 0, 0+(int)WALL_NEAR_THRESHOLD, (int)getBattleFieldHeight());
		g.drawLine((int)getBattleFieldWidth()-(int)WALL_NEAR_THRESHOLD, 0, (int)getBattleFieldWidth()-(int)WALL_NEAR_THRESHOLD, (int)getBattleFieldHeight());
	}
	
	int radarDir = 1;
	int scanTimer = 8;
	public void radarStep(){
		if(!radarTrack || RADAR_TRACKING_DISABLE || (RADAR_TRACK_AWARENESS_SCAN && scanTimer-- > 0)){
			/* Radar - Omni*/
			setTurnRadarLeftRadians(PI2);
		} else {
			if(getTime() % RADAR_TRACK_AWARENESS_SCAN_INT == 0)scanTimer = 8;
			/* Radar - track */
			setPointRadar(target.getEstBearing() + (RADAR_TRACK_WIDTH/2)*(radarDir *= -1));
			
		}
	}
	
	/* Orbit vars */
	double r = MAX_ORBIT_RADIUS;
	double a = ORBIT_APPROACH_RADIUS;
	int dir = 1;
	int reverseTimer = 0;
	boolean correcting = false;
	int correctingAng;
	boolean correctingDir;
	boolean forwards = true;
	
	double slowTime;
	public void orbitStep(){
		
		/* Orbit distance (set this up early so dodging can modify it) */
		r = (MAX_ORBIT_RADIUS - MIN_ORBIT_RADIUS) * (target.getEnergy()/getEnergy());
		if(r > MAX_ORBIT_RADIUS)
			r = MAX_ORBIT_RADIUS;
		
		/* Dodging */
		boolean fired = target.getEstHasFired();
		if((DODGE & DODGE_SLOW) == DODGE_SLOW){
			if(fired){
				slowTime = 4;
			}
			if(slowTime-- > 0){
				setMaxVelocity(DODGE_SLOW_SPEED);
			}
		}
		if((DODGE & DODGE_REVERSE) == DODGE_REVERSE){
			if(reverseTimer-- < 0 && fired){
				dir = -dir;
				forwards = !forwards;
				reverseTimer = DODGE_REVERSE_MIN_TIME;
			}
		}
		
		r = (MAX_ORBIT_RADIUS - MIN_ORBIT_RADIUS) * (target.getEnergy()/getEnergy());
		if(r > MAX_ORBIT_RADIUS)
			r = MAX_ORBIT_RADIUS;
		
		double h = target.getEstBearing();
		double d = target.getEstDistance();
		double toHdg;
		if((d-r) > a){
			toHdg = h;
		} else if((d-r) > 0) {
			toHdg = posAngle(h + dir * ( (PI/2.) - (PI/2.) * ((d - r)/a)));
		} else {
			toHdg = posAngle(h + dir * ( (PI/2.) + (PI/2.) * ((r-d)/r)));
		}
		if(!forwards)toHdg = posAngle(PI + toHdg);
		setPointRobot(toHdg);
		disp_targetHdg = toHdg;
		
		/* Movement - wall avoidance - fuck */
		if(nearWall()){	
			this.setBodyColor(Color.PINK);
			setPointRobot(forwards?awayFromWall():(PI+awayFromWall()));
			if(!correcting){
				correcting = true;
				dir = -dir;
				if(WALL_CORRECTION_TYPE == WALL_CORRECTION_REVERSE)forwards = !forwards;
				
				correctingAng = dir;
				if(WALL_CORRECTION_TYPE == WALL_CORRECTION_REVERSE)correctingDir = forwards;
			} else {
				dir = correctingAng;
				if(WALL_CORRECTION_TYPE == WALL_CORRECTION_REVERSE)forwards = correctingDir;
			}
		} else {
			this.setBodyColor(Color.BLACK);
			correcting = false;
		}
		if(forwards){
			setAhead(100);
		} else {
			setBack(100);
		}
	}
	
	double ramAdj = 0;
	double ramAdjInt = 2;
	public void ramStep(){
		setAhead(10000);
		long timeToHit = (long) (target.getEstDistance(0)/Rules.MAX_VELOCITY);
		if(Math.abs(target.getEstBearing(timeToHit) - getHeadingRadians()) > PI/2){
			setMaxVelocity(Rules.MAX_VELOCITY/3);
		} else {
			setMaxVelocity(Rules.MAX_VELOCITY);
		}
		if(target.getEstDistance() < RAM_STRAIGHT_DISTANCE){
			setPointRobot(target.getEstBearing(timeToHit));
			disp_targetHdg = target.getEstBearing(timeToHit);
		} else {
			setPointRobot(target.getEstBearing(timeToHit) + ramAdj);
			disp_targetHdg = target.getEstBearing(timeToHit) + ramAdj;
		}
		if(Math.abs(ramAdj + ramAdjInt) > RAM_ADJUSTMENT_MAX){
			ramAdjInt = -ramAdjInt;
		}
		ramAdj += ramAdjInt;
	}
	
	public void centerStep(){
		double x = (getBattleFieldWidth()/2) - getX();
		double y = (getBattleFieldHeight()/2) - getY();
		double bearingToCenter = posAngle(Math.atan2(x, y));
		double distanceToCenter = Math.sqrt(x*x+y*y);
		if(distanceToCenter > 7){
			setPointRobot(bearingToCenter);
			
			setMaxVelocity(Rules.MAX_VELOCITY);
			setAhead(100);
		} else {
			setPointRobot(0);
		}
	}
	
	public void onHitRobot(HitRobotEvent event) {
		dir = -dir;	
	}
	
	public boolean nearWall(){
		if(getX()-WALL_NEAR_THRESHOLD < 0){
			return true;
		}
		if(getX()+WALL_NEAR_THRESHOLD > getBattleFieldWidth()){
			return true;
		}
		if(getY()-WALL_NEAR_THRESHOLD < 0){
			return true;
		}
		if(getY()+WALL_NEAR_THRESHOLD > getBattleFieldHeight()){
			return true;
		}
		return false;
	}
	
	public double awayFromWall(){
		if(getX()-WALL_NEAR_THRESHOLD < 0){
			return PI/2;
		}
		if(getX()+WALL_NEAR_THRESHOLD > getBattleFieldWidth()){
			return 3*PI/2;
		}
		if(getY()-WALL_NEAR_THRESHOLD < 0){
			return 0;
		}
		if(getY()+WALL_NEAR_THRESHOLD > getBattleFieldHeight()){
			return PI;
		}
		return 2;
	}
	
	public void onScannedRobot(ScannedRobotEvent e){
		String name = e.getName();
		if(!enemies.containsKey(name)){
			EnemyRecord er = new EnemyRecord(name);
			enemies.put(name, er);
		}
		if(getTime() < 45 || getTime() > 55)
			enemies.get(name).update(e);
	}
	
	public void onRobotDeath(RobotDeathEvent e){
		System.out.println("Word on the street is that " + e.getName() + " died!");
		enemies.get(e.getName()).setDead();
	}	
	
	public double relToAbsHdgRad(double rad){
		return rad + getHeadingRadians();
	}
	public boolean angleNear(double a, double b){
		return (Math.abs(a - b) < PI/2);//If the difference is less than 90
	}
	
	public void setPointGun  (double hdg){
		double change = posAngle(hdg - this.getGunHeadingRadians());
		if(change > 0 && change < PI){
			setTurnGunRightRadians(change);
		} else if(change > PI && change < PI2) {
			setTurnGunLeftRadians(PI2-change);
		}
	}
	
	public void setPointRobot(double hdg){
		double change = posAngle(hdg - this.getHeadingRadians());
		if(change > 0 && change < PI){
			setTurnRightRadians(change);
		} else if(change > PI && change < PI2) {
			setTurnLeftRadians(PI2-change);
		}
	}
	
	public void setPointRadar(double hdg){
		double change = posAngle(hdg - this.getRadarHeadingRadians());
		if(change > 0 && change < PI){
			setTurnRadarRightRadians(change);
		} else if(change > PI && change < PI2) {
			setTurnRadarLeftRadians(PI2-change);
		}
	}
	long stept = 0;
	Condition step = new Condition(){
		public boolean test(){
			if(getTime() > stept){
				stept = getTime();
				return true;
			}
			return false;
		}
	};
	
	EnemyRecord self;
	EnemyRecord target;
	
	public HashMap<String, EnemyRecord> enemies = new HashMap<String,EnemyRecord>();
	
	public class EnemyRecord{
		long lastMessage;
		public ArrayList<Message> getUpdateMessages(){
			ArrayList<Message> messages = new ArrayList<Message>();
			
			Iterator<PosLogEntry> it = log.iterator();
			PosLogEntry e;
			while(it.hasNext() && (e = it.next()).time > lastMessage){
				messages.add(new Message(name, isDead(), e));
			}
			lastMessage = getTime();
			return messages;
		}
		public void importMessage(Message m){
			if(true || quickLog.containsKey(m.entry.time)){
				log.addFirst(new PosLogEntry(
						m.entry.time,
						m.entry.x,
						m.entry.y,
						m.entry.hdg,
						m.entry.velocity, 
						m.entry.energy));
			}
		}
		
		EnemyRecord(String name){
			this.name = name;
			if(!guessFactorLog.containsKey(name)){
				guessFactorLog.put(name, new int[GUESS_FACTOR_RESOLUTION]);
				for(int i = 0; i < guessFactorLog.get(name).length; i++){
					guessFactorLog.get(name)[i] = 0;
				}
				guessFactorSuccess(0);
			}
		}
		
		public double getEnergy(){
			if(log.size() > 0)
				return log.get(0).energy;
			return 100;
		}
		public long scanAge(){
			if(log.size() > 0)
				return getTime() - log.get(0).time;
			return 0;
		}
		public double getEstBearing(){
			return getEstBearing(0);
		}
		public double getEstDistance(){
			return getEstDistance(0);
		}
		public double getEstBearing(long t){
			double x = getLocation(t).x - getX();
			double y = getLocation(t).y - getY();
			return posAngle(Math.atan2(x, y));
		}
		public double getEstDistance(long t){
			double x = getLocation(t).x - getX();
			double y = getLocation(t).y - getY();
			return Math.sqrt(x*x+y*y);
		}
		
		String name;
		public void update(ScannedRobotEvent e){
			name = e.getName();
			double absHdg = relToAbsHdgRad(e.getBearingRadians());
			double x = getX() + Math.sin(absHdg)*e.getDistance();
			double y = getY() + Math.cos(absHdg)*e.getDistance();
			PosLogEntry entry = new PosLogEntry(getTime(),x,y,e.getHeadingRadians(),e.getVelocity(), e.getEnergy());
			log.addFirst(entry);
			quickLog.put(getTime(), entry);
		}
		public void updateSelf(){
			name = getName();
			double x = getX();
			double y = getY();
			PosLogEntry entry = new PosLogEntry(getTime(),x,y,getHeadingRadians(),getVelocity(), getEnergy());
			log.addFirst(entry);
			quickLog.put(getTime(), entry);
		}
		
		HashMap<Long, PosLogEntry> quickLog = new HashMap<Long, PosLogEntry>();
		LinkedList<PosLogEntry> log = new LinkedList<PosLogEntry>();

		double num = 0;
		public Pair getLocation(long steps){
			PosLogEntry l = log.getFirst();
			long age = getTime() - l.time + steps;
			double hdg = l.hdg;
			double turnrate = getEstTurnRate();
			double x;
			double y;
			
			switch(PREDICTION_TYPE){
			case PREDICTION_GUESS_FACTOR:
				return getGuessFactorLocation(steps,guessFactor());
			case PREDICTION_CIRCULAR:
				x = l.x;
				y = l.y;
				
				for(int i = 0; i < age; i++){
					if((x + l.velocity * Math.sin(hdg)) < 0 || (x + l.velocity * Math.sin(hdg)) > getBattleFieldWidth() ||
							(y + l.velocity * Math.cos(hdg)) < 0 || (y + l.velocity * Math.cos(hdg)) > getBattleFieldHeight()){
						break;
					}
					x += l.velocity * Math.sin(hdg);
					y += l.velocity * Math.cos(hdg);
					hdg += turnrate;
				}
				return new Pair(x,y);
			case PREDICTION_LINEAR:
				x = l.x + age * l.velocity * Math.sin(hdg);
				y = l.y + age * l.velocity * Math.cos(hdg);
				return new Pair(x,y); 
			default:
			case PREDICTION_TROY:
				x = l.x;
				y = l.y;
				return new Pair(x,y); 
			}
			
		}
		
		long lastPoll = 0;
		public boolean getEstHasFired(){
			
			int i = 0;
			boolean fired = false;
			double delta;
			while((i+1) < log.size() && log.get(i).time > lastPoll){
				delta = log.get(i+1).energy - log.get(i).energy;
				if(delta >= Rules.MIN_BULLET_POWER && delta <= Rules.MAX_BULLET_POWER){
					fired = true;
				}
				i++;
			}
			lastPoll = getTime();
			return fired;
		}
		
		public double getEstTurnRate(){
			if(log.size() > 1){
				return (log.get(0).hdg - log.get(1).hdg)/(log.get(0).time - log.get(1).time);
			}
			return 0;
		}
		public void setDead(){
			dead = true;
		}
		boolean dead = false;
		boolean isDead(){
			return dead;
		}
		public double getHeadingAt(long time){
			if(quickLog.containsKey(time))return quickLog.get(time).hdg;
			
			long n = 0;
			PosLogEntry next = null;
			while(next == null){
				next = quickLog.get(time + ++n);
				if(n > getTime())return 0;
			}
			
			long p = 0;
			PosLogEntry prev = null;
			while(prev == null){
				prev = quickLog.get(time - ++p);
				if(p < 0)return 0;
			} 
			return prev.hdg + ( (next.hdg - prev.hdg)/(p + n) ) * p;
		}
		public double getVelocityAt(long time){
			if(quickLog.containsKey(time))return quickLog.get(time).velocity;
			
			long n = 0;
			PosLogEntry next = null;
			while(next == null){
				next = quickLog.get(time + ++n);
				if(n > getTime())return 0;
			}
			
			long p = 0;
			PosLogEntry prev = null;
			while(prev == null){
				prev = quickLog.get(time - ++p);
				if(p < 0)return 0;
			} 
			return next.velocity + ( (next.velocity - prev.velocity)/(p + n) ) * p;
		}
		public double getTurnRateAt(long time){
			long p = 0;
			PosLogEntry next = null;
			do{
				next = quickLog.get(time + ++p);
				if(p > getTime())return 0;
			}while(next == null);
			
			long n = 0;
			PosLogEntry prev = null;
			do{
				prev = quickLog.get(time - 1 - ++n);
				if(p < 0)return 0;
			}while(prev == null);
			
			return (next.hdg-prev.hdg)/(n+p+1);
		}
		public double getAccelerationAt(long time){
			long p = 0;
			PosLogEntry next = null;
			do{
				next = quickLog.get(time + ++p);
				if(p > getTime())return 0;
			}while(next == null);
			
			long n = 0;
			PosLogEntry prev = null;
			do{
				prev = quickLog.get(time - 1 - ++n);
				if(p < 0)return 0;
			}while(prev == null);
			
			return (next.velocity-prev.velocity)/(n+p+1);
		}
		
		public Pair getLocationAt(long time){
			if(quickLog.containsKey(time)){
				return new Pair(quickLog.get(time).x,quickLog.get(time).y);
			}
			
			long n = 0;
			PosLogEntry next = null;
			while(next == null){
				next = quickLog.get(time + ++n);
				if(n > getTime())return null;
			}
			
			long p = 0;
			PosLogEntry prev = null;
			while(prev == null){
				prev = quickLog.get(time - ++p);
				if(p < 0)return null;
			} 
			
			Pair loc = new Pair(
					prev.x + ( (next.x - prev.x)/(p + n) ) * p ,
					prev.y + ( (next.y - prev.y)/(p + n) ) * p);
			return loc;
		}
		
		public Pair getGuessFactorLocation(long steps, double guessFactor){
			PosLogEntry l = log.getFirst();
			
			
			long age = getTime() - l.time + steps;
			double vel = Rules.MAX_VELOCITY;//getVelocityAt(time);
			double hdg = l.hdg;
			if(l.velocity < 0)vel = -vel;
			double x = age * vel * Math.sin(hdg);
			double y = age * vel * Math.cos(hdg);
			return new Pair(l.x + (guessFactor * x),l.y + (guessFactor * y));
		}
		public Pair getGuessFactorLocationAt(long time, long steps, double guessFactor){
			Iterator<PosLogEntry> it = log.iterator();
			PosLogEntry l;
			do{
				if(!it.hasNext())return null;
				l = it.next();
			}while(l.time > time);
			
			
			long age = time - l.time + steps;
			double vel = Rules.MAX_VELOCITY;//getVelocityAt(time);
			double hdg = getHeadingAt(time);
			if(l.velocity < 0)vel = -vel;
			double x = age * vel * Math.sin(hdg);
			double y = age * vel * Math.cos(hdg);
			
			return new Pair(l.x + (guessFactor * x),l.y + (guessFactor * y));
		}
		
		public void guessFactorSuccess(double gf){
			double pre = guessFactor();
			//(GUESS_FACTOR_RANGE*2)
			//int index = (int)((gf * (guessFactorLog.get(name).length / 2))+(GUESS_FACTOR_RESOLUTION/2-1)+.49);
			int index = (int) ((gf/GUESS_FACTOR_RANGE)*(GUESS_FACTOR_RESOLUTION / 2) + (GUESS_FACTOR_RESOLUTION / 2));
			System.out.println(" -> " + index);
			if(index > 0){
				guessFactorLog.get(name)[index-1] += 1;
			}
			if(index < guessFactorLog.get(name).length-1){
				guessFactorLog.get(name)[index+1] += 1;
			}
			guessFactorLog.get(name)[index] += 2;
			if(pre != guessFactor())System.out.println("Changing GuessFactor: " + guessFactor());
		}
		
		public double guessFactor(){
			int maxIndex = 0;
			double gf;
			if(GUESS_FACTOR_TYPE == GUESS_FACTOR_MODE){
				for(int i = 1; i < guessFactorLog.get(name).length; i++){
					if(guessFactorLog.get(name)[i] >= guessFactorLog.get(name)[maxIndex]){
						maxIndex = i;
					}
				}
				
				gf = ( ((double)maxIndex/(double)GUESS_FACTOR_RESOLUTION) * 2 * GUESS_FACTOR_RANGE ) - GUESS_FACTOR_RANGE;
				//System.out.println("Getting gf " + maxIndex + " -> " + gf);
				return gf;
			}
			if(GUESS_FACTOR_TYPE == GUESS_FACTOR_MEAN){
				int n = 0;
				int s = 0;
				for(int i = 1; i < guessFactorLog.get(name).length; i++){
					s += i * guessFactorLog.get(name)[i];
					n += guessFactorLog.get(name)[i];
					
				}
				if(n == 0)return 0;
				gf = ( ((double)(s/n)/(double)GUESS_FACTOR_RESOLUTION) * 2 * GUESS_FACTOR_RANGE ) - GUESS_FACTOR_RANGE;
				return gf;
			}
			return 0;
		}
	}
	static class Pair implements Serializable{
		private static final long serialVersionUID = 7401410272484532420L;
		
		double x;
		double y;
		public Pair(double x, double y) {
			this.x = x;
			this.y = y;
		}
		public String toString(){
			return "(" + x + "," + y + ")";
		}
	}		
	static class PosLogEntry implements Serializable{
		private static final long serialVersionUID = 3458787004839347640L;
		long time;
		double x;
		double y;
		double hdg;
		double velocity;
		double energy;
		public PosLogEntry(long time, double x, double y, double hdg, double velocity, double energy) {
			this.time = time;this.x = x;this.y = y;this.hdg = hdg;this.velocity = velocity;
			this.energy = energy;;
		}
	}

	HashMap<Bullet,FireLogEntry> fireLog = new HashMap<Bullet,FireLogEntry>();
	class FireLogEntry{
		Pair fireLocation;
		Bullet bullet;
		long fireTime;
		EnemyRecord target;
		FireLogEntry(Bullet b, EnemyRecord tgt, Pair fireLocation){
			this.bullet = b;
			fireTime = getTime();
			target = tgt;
			this.fireLocation = fireLocation;
		}
	}
	
	public void onBulletMissed(BulletMissedEvent e){
		guessFactorAnalyze(fireLog.get(e.getBullet()));
	}
	public void onBulletHit(BulletHitEvent e){
		guessFactorAnalyze(fireLog.get(e.getBullet()));
	}
	public void guessFactorAnalyze(FireLogEntry e){
		if(e.target.isDead())return;
		EnemyRecord target = e.target;
		double bulletVel = Rules.getBulletSpeed(e.bullet.getPower());
		double bulletDistance = 0;
		
		long startTime = e.fireTime;
		long endTime = getTime();
		
		Pair myLocation = e.fireLocation;
		Pair enemyLocation;
		
		for(long stepTime = 0; stepTime + startTime < endTime; stepTime++){
			bulletDistance = stepTime * bulletVel;
			enemyLocation = target.getLocationAt(stepTime + startTime);
			
			if(enemyLocation != null){
				
				if(distance(myLocation, enemyLocation) <= bulletDistance){
					Pair max = target.getGuessFactorLocationAt(startTime, stepTime, 1);
					Pair min = target.getGuessFactorLocationAt(startTime, stepTime, -1);
					//double maxDist = distance(enemyLocation,max);
					double minDist = distance(enemyLocation,min);
					double totDist = distance(min,max);
										
					double guessFactor = (2*(minDist/totDist)) -1;
					
					System.out.print(" -> " + Math.floor(guessFactor*100)/100);
					
					if( Math.abs(guessFactor) < GUESS_FACTOR_RANGE )
						target.guessFactorSuccess(guessFactor);
					
					return;
				}
			
		}	}
		putOffAnal.put(getTime()+10,e);
	}
	
	HashMap<Long, FireLogEntry> putOffAnal = new HashMap<Long, FireLogEntry>();
	
	public double distance(Pair p1, Pair p2){
		return Math.sqrt(((p1.x-p2.x)*(p1.x-p2.x)) + ((p1.y-p2.y)*(p1.y-p2.y)));
	}
	
	public double angle(Pair p1,Pair p2){
		return Math.atan2(p2.x-p1.x, p2.y-p1.y);
	}
	
	public double posAngle(double angle){
		return (angle + PI2)%PI2;
	}
	
	public double negAngle(double angle){
		return posAngle(angle+PI)-PI;
	}
	
	ArrayList<Line> lineList = new ArrayList<Line>();
	public static HashMap<String, int[]> guessFactorLog = new HashMap<String, int[]>();
	class Line{
		int x1, x2, y1, y2;
		public Line(Pair p1, Pair p2) {
			this.x1 = (int) p1.x;
			this.x2 = (int) p2.x;
			this.y1 = (int) p1.y;
			this.y2 = (int) p2.y;
		}
	}
	
	ArrayList<Pair> pointz = new ArrayList<Pair>();
	static class Message implements Serializable{
		String name;
		boolean isDead;
		PosLogEntry entry;
		public Message(String name, boolean isDead, PosLogEntry entry) {
			this.name = name;
			this.isDead = isDead;
			this.entry = entry;
		}
	}
}


