package vuen;
import robocode.*;
import java.awt.Color;
import vuen.cfCake.*;
import java.io.*;

/*
    
    Cake 2.51
    
    This is also a patch fix to implement CoopRobot
    in Cake. It can now participate in cooperative
    play. It also now has a Droid version, CupCake.
    
    
    Cake 2.5

    This is simply a patch fix version to allow Cake
    to participate in the Team RoboRumble@home. It
    also fixes a few other bugs; I haven't worked on
    this bot in over a year, so I'm just releasing it
    to let it participate, but it's the first Java
    program I've ever written and I'm still very
    proud of its framework. Anyway, enjoy! Below is
    the introduction left in the previous version of
    Cake.


	Cake 2.41 (s)
	
	This is the version of Cake entered in the 
	alphaWorks Robocode Rumble.
	
	I didn't know any Java when I started Robocode,
	and Cake is my very first Robocode robot; I had
	no knowledge of interfaces, extending or nested
	classes, or any kind of advanced strategy manager
	designs, so Cake's code is really badly coded.
	There's also very little comments in it, and I
	have a bad habit of commenting out lines of code
	I don't want instead of just erasing them :(.
	
	I learned of Robocode when it was assigned to us
	in my Cisco programming class a few months ago;
	we had to design a robot which we submitted for
	evaluation, and we participated in a class
	tournament (which Cake won :).) Since then I've
	been working on it and entered it in the Rumble.
	
	Anyways, Robocode is the greatest learning tool
	ever. I finally finished downloading the Forte
	for Java package today, and am now writing my
	own Java application, all thanks to Robocode.
	
	And also, Cake is submitted by my dad, David
	Fraser, because I am only 16 so I could not
	submit it under my name.
	
	Anyways, I'm finished rambling on now, so here's
	the source code. Bla.
	
					-Nicholas Fraser
*/

public class Cake extends coop.CoopRobot {
	public cJaiControl mJaiControl = null;
	public cComControl mComControl = null;
	public cRadControl mRadControl = null;
	public cGunControl mGunControl = null;
	public cMovControl mMovControl = null;
	
	public boolean mGameOver = false;
	
	public void run() {
		if (getRoundNum() == 0)		
			out.println("[" + getTime() + "] BOT: Spawning Control Layers: JAI, COM, RAD, GUN, MOV");
				
		mComControl = new cComControl(this);
		mJaiControl = new cJaiControl(this, mComControl);
		mRadControl = new cRadControl(this, mComControl);
		mGunControl = new cGunControl(this, mComControl);
		mMovControl = new cMovControl(this, mComControl);
		
		setEventPriority("ScannedRobotEvent", 99);
		//setEventPriority("BulletHitEvent", 60);
		//setEventPriority("HitByBulletEvent", 60);
		
		while(true) {
			if (mGameOver) {
				mComControl.doPrintStats();
				mGameOver = false;
				mJaiControl.doVictoryDance();
			}
			mJaiControl.doTurn();
			mComControl.doTurn();
			mRadControl.doTurn();
			mGunControl.doTurn();
			mMovControl.doTurn();
			mComControl.doEndTurn();
		}
	}
	
	
	
	

	public void onWin(WinEvent e) {
		mGameOver = true;
		mJaiControl.onWin(e);
		//mComControl.onWin(e);
		mRadControl.onWin(e);
		mGunControl.onWin(e);
		mMovControl.onWin(e);
	}
	
	public void onDeath(DeathEvent e) {
		mGameOver = true;
		mJaiControl.onDeath(e);
		//mComControl.onDeath(e);
		//mRadControl.onDeath(e);
		mGunControl.onDeath(e);
		//mMovControl.onDeath(e);
		mComControl.doPrintStats();
	}

	//public void setFire(double power) {}
	//public void fire(double power) {execute();}

	public void onSkippedTurn(SkippedTurnEvent e) {
		mJaiControl.onSkippedTurn(e);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		mRadControl.onScannedRobot(e);
	}
	
	public void onMessageReceived(MessageEvent e) {
		mComControl.onMessageReceived(e);
	}
	
	public void onHitRobot(HitRobotEvent e) {
		mMovControl.onHitRobot(e);
	}
	
	public void onHitWall(HitWallEvent e) {
		mMovControl.onHitWall(e);
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		mJaiControl.onHitByBullet(e);
		mMovControl.onHitByBullet(e);
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		mJaiControl.onRobotDeath(e);
		mComControl.onRobotDeath(e);
	}
	
	public void onBulletHit(BulletHitEvent e) {
		mJaiControl.onBulletHit(e);
		mGunControl.onBulletHit(e);
		mMovControl.onBulletHit(e);
	}
	
	// normalAbsoluteAngle: returns angle such that   0 <= angle < 360
	public double normalAbsoluteAngle(double angle) {
		if (angle < 0)
			return 360 + (angle % 360);
		else
			return angle % 360;
	}
	
	// normalRelativeAngle: returns angle such that   -180 < angle <= 180
	public double normalRelativeAngle(double angle) {
		if (angle > 180)
			return ((angle + 180) % 360) - 180;
		if (angle < -180)
			return ((angle - 180) % 360) + 180;
		return angle;
	}
	
	// normalRelative90Angle: returns angle such that   -45 < angle <= 45
	public double normalRelative90Angle(double angle) {
		if (angle > 45)
			return ((angle + 45) % 90) - 45;
		if (angle < -45)
			return ((angle - 45) % 90) + 45;
		return angle;
	}
}
