package uccc;

import robocode.*;
import java.awt.*;
import uccc.util.*;

/*
 * TODO:Write a method to cause the turning rate change. Something sinusoidal
 * should be fine. We want to see if the turning radius that RoboCode reflects
 * is accurate or not. At a constant speed, with a varying rate of rotation,
 * the turning circle should change size.
 */

public class WallSmoothingMovement {
	AdvancedRobot robot;
	// Variabes related to our bot (dataType botXXXXXX)
	int botX = 0;
	int botY = 0;
	double botHeadingInRadians = 0;
	double botRateOfRotationInRadians = 0;
	double botRateOfRotationInDegrees = 0;
	double botVelocity = 0;
	double botTurningRadius = 0;

	// Variables related to our enemy
	double enemyX = 0;
	double enemyY = 0;
	double enemyBearingInRadians = 0;
	double enemyDistance = 0;
	double enemyVelocity = 0;

	// Dorito-specific flavorings
	double speed = 0;
	double turn = 0;
	boolean turningRight = true;
	boolean accel = true;
	int wallSmoothingDistance = 150;
	

	public WallSmoothingMovement(AdvancedRobot robot){
		this.robot = robot;
	}
	/**
	 * Do all the normal debug output here. Special stuff can go inside robot
	 * methods.
	 */
	public void writeDebugToConsole() {
	}

	/**
	 * Derives information about the robot based on the games physics constants.
	 * Ex: Knowing the formula for calculating rate of rotation, we can compute
	 * turning circles, etc. Because some values are composite functions, they
	 * need to be done in the proper order. robot method helps organize that.
	 */
	public void collectRobotData() {
		// Store get method data in primitives for quick access.
		botX = (int) robot.getX();
		botY = (int) robot.getY();
		botHeadingInRadians = robot.getHeadingRadians();
		botVelocity = robot.getVelocity();

		// Calculate the turningRadius.
		/*
		 * if (botRateOfRotationInRadians != 0) { botTurningRadius =
		 * (robot.getVelocity() / botRateOfRotationInRadians); } else {
		 * botTurningRadius = -1; // TODO: robot must be documented! }
		 */
		// botRateOfRotationInRadians =
		// Rules.getTurnRateRadians(robot.getVelocity());

		// Jules' botTurningRadius = (360*robot.getVelocity()) /
		// (((10-0.75*robot.getVelocity()) * 2 * Math.PI));
		botTurningRadius = Math.abs(robot.getVelocity())
				/ Rules.getTurnRateRadians(Math.abs(robot.getVelocity()));
		robot.out.println("botVelocity: " + robot.getVelocity());
		robot.out.println("botRateOfRotationInRadians: " + Rules.getTurnRateRadians(robot.getVelocity()));
		robot.out.println("botTurningRadius: " + botTurningRadius);
	}

	/**
	 * Find out what quadrant the enemy is in relation to our heading
	 * 
	 * @return Direction TODO: Simplify if statements, is it necessary to check
	 *         two values?
	 */
	public Direction getRelitiveEnemyBearing() {
		if ((enemyBearingInRadians >= (-2 * (Math.PI / 2)))
				&& (enemyBearingInRadians < (-1 * (Math.PI / 2)))) {
			return Direction.SOUTHWEST;
		} else if ((enemyBearingInRadians >= (-1 * (Math.PI / 2)))
				&& (enemyBearingInRadians < (0 * (Math.PI / 2)))) {
			return Direction.NORTHWEST;
		} else if ((enemyBearingInRadians >= (0 * (Math.PI / 2)))
				&& (enemyBearingInRadians < (1 * (Math.PI / 2)))) {
			return Direction.NORTHEAST;
		} else {
			return Direction.SOUTHEAST;
		}
	}

	/**
	 * Do it to it
	 */
	public void doMovementStuff() {

			collectRobotData();
			robot.out.println("RadarTurnRemainingRadians: " + robot.getRadarTurnRemainingRadians());
			/*
			 * Do some trickery to modulate the speed so we can watch the
			 * turning circle grow and shrink.
			 */
			// setAhead(Double.POSITIVE_INFINITY);
			// robot.setVelocityRate(speed);
			// robot.setTurnRateRadians(speed / Math.PI);
			if (robot.getTime() % 3 == 0) {
				if (turningRight == true) {
					if (turn == 12) {
						turningRight = false;
					}
					turn++;

				} else {
					if (turn == -12) {
						turningRight = true;
					}
					turn--;
				}
			}			
			robot.setAhead(Double.POSITIVE_INFINITY);
			robot.setTurnRightRadians(turn);

			avoidWalls();

			robot.execute();
		
	}

	public void onHitWall(HitWallEvent e) {

	}

	public void onHitRobot(HitRobotEvent e) {

	}

	public void avoidWalls(){
		double turningRadiusPiviotX = 0.0;
		double turningRadiusPiviotY = 0.0;
		if (
				((turn > 0) && (robot.getVelocity() > 0)) ||
				((turn < 0) && (robot.getVelocity() < 0))){
			turningRadiusPiviotX = (robot.getX() + (Math.cos(robot
					.getHeadingRadians()) * botTurningRadius));
			turningRadiusPiviotY = (robot.getY() - (Math.sin(robot
					.getHeadingRadians()) * botTurningRadius));
		} else {
			turningRadiusPiviotX = (robot.getX() - (Math.cos(robot
					.getHeadingRadians()) * botTurningRadius));
			turningRadiusPiviotY = (robot.getY() + (Math.sin(robot
					.getHeadingRadians()) * botTurningRadius));
		}
		
		if(turningRadiusPiviotX-botTurningRadius<=18 ||
				turningRadiusPiviotX+botTurningRadius >= (robot.getBattleFieldWidth() - 36) ||
				turningRadiusPiviotY-botTurningRadius<=18 ||
				turningRadiusPiviotY+botTurningRadius>=(robot.getBattleFieldHeight() - 36)
				){
			robot.setAhead(0);
		}
		
	}
	
	
	public void onScannedRobot(ScannedRobotEvent e) {
		enemyBearingInRadians = e.getBearingRadians();
		enemyDistance = e.getDistance();
		enemyVelocity = e.getVelocity();
		enemyX = (robot.getX() + (Math.sin(robot.getHeadingRadians()
				+ enemyBearingInRadians) * enemyDistance));
		enemyY = (robot.getY() + (Math.cos(robot.getHeadingRadians()
				+ enemyBearingInRadians) * enemyDistance));

	}

	
	public void onPaint(Graphics2D g) {
		double foreX = (Math.sin(botHeadingInRadians) * wallSmoothingDistance / 2);
		double foreY = (Math.cos(botHeadingInRadians) * wallSmoothingDistance / 2);
		double aftX = (Math.sin(botHeadingInRadians) * -wallSmoothingDistance / 2);
		double aftY = (Math.cos(botHeadingInRadians) * -wallSmoothingDistance / 2);
		double starboardX = (botX + (Math
				.sin(botHeadingInRadians + Math.PI / 2)
				* wallSmoothingDistance / 2));
		double starboardY = (botY + (Math
				.cos(botHeadingInRadians + Math.PI / 2)
				* wallSmoothingDistance / 2));
		double portX = (botX + (Math.sin(botHeadingInRadians - Math.PI / 2)
				* wallSmoothingDistance / 2));
		double portY = (botY + (Math.cos(botHeadingInRadians - Math.PI / 2)
				* wallSmoothingDistance / 2));

		double turningRadiusPiviotX = 0.0;
		double turningRadiusPiviotY = 0.0;
		if (
				((turn > 0) && (robot.getVelocity() > 0)) ||
				((turn < 0) && (robot.getVelocity() < 0))){
			turningRadiusPiviotX = (robot.getX() + (Math.cos(robot
					.getHeadingRadians()) * botTurningRadius));
			turningRadiusPiviotY = (robot.getY() - (Math.sin(robot
					.getHeadingRadians()) * botTurningRadius));
		} else {
			turningRadiusPiviotX = (robot.getX() - (Math.cos(robot
					.getHeadingRadians()) * botTurningRadius));
			turningRadiusPiviotY = (robot.getY() + (Math.sin(robot
					.getHeadingRadians()) * botTurningRadius));
		}
		
		/*
		 * Draw battlefield boundaries. Get any closer than robot and you hit a
		 * wall.
		 */
		g.setColor(Color.GRAY); // TODO : Improve cast double to int
		g.drawRect(18, 18, (int) robot.getBattleFieldWidth() - 36, (int) robot
				.getBattleFieldHeight() - 36);

		// Draw the feeler's radius
		g.setColor(Color.YELLOW);
		g.drawOval(botX - wallSmoothingDistance / 2, botY
				- wallSmoothingDistance / 2, wallSmoothingDistance,
				wallSmoothingDistance);

		// Draw the turning radius
		if(
				((turn != 0) && (robot.getVelocity() != 0))
				){
		g.setColor(Color.PINK); // TODO : Improve cast double to int
		g.drawOval((int) (turningRadiusPiviotX - botTurningRadius),
				(int) (turningRadiusPiviotY - botTurningRadius),
				(int) (2.0 * botTurningRadius), (int) (2.0 * botTurningRadius));
		}
		// Drop some painting debug into the console
		robot.out.println("Piviot Point (x,y) = " + turningRadiusPiviotX + " "
				+ turningRadiusPiviotY);

		// Draw a circle around the bot
		g.setColor(Color.CYAN);
		g.drawOval(botX - wallSmoothingDistance / 2, botY
				- wallSmoothingDistance / 2, wallSmoothingDistance,
				wallSmoothingDistance);

		// Draw Origin node
		g.setColor(Color.GREEN); // TODO : Improve cast double to int
		g.drawOval((int) (turningRadiusPiviotX - 10.0),
				(int) (turningRadiusPiviotY - 10.0), 20, 20);

		// Draw Starboard feeler
		g.setColor(Color.GREEN); // TODO : Improve cast double to int
		g.drawLine(botX, botY, (int) starboardX, (int) starboardY);

		// Draw directional nodes
		g.setColor(Color.WHITE); // TODO : Improve cast double to int
		g.drawOval((int) (botX - foreX - 10), (int) (botY - foreY - 10),20, 20);
		g.setColor(Color.GRAY); // TODO : Improve cast double to int
		g.drawOval((int) (botX - aftX - 10), (int) (botY - aftY - 10), 20, 20);
		g.setColor(Color.GREEN); // TODO : Improve cast double to int
		g.drawOval((int) (starboardX - 10), (int) (starboardY - 10), 20, 20);
		g.setColor(Color.RED); // TODO : Improve cast double to int
		g.drawOval((int) (portX - 10), (int) (portY - 10), 20, 20);

		// Draw enemy reticle and trace the bearing
		g.setColor(Color.RED); // TODO : Improve cast double to int
		g.drawOval((int) (enemyX - 10), (int) (enemyY - 10), 20, 20);
		g.drawLine(botX, botY, (int) enemyX, (int) enemyY);

	}

}
