package tzu.util;

import robocode.*;
import tzu.intel.*;

/**
 * Describes the motion of a robot or bullet.
 */
public class Motion {

    double x;
    double y;
    double heading;
    double speed;
    double chgHeading;
    double chgSpeed;
    Bot    bot;

    /**
     * Create a Motion object.
     */
    public Motion(
            double x,
            double y,
            double heading,
            double speed,
            double chgHeading,
            double chgSpeed) {

        this.x          = x;
        this.y          = y;
        this.heading    = heading;
        this.speed      = speed;
        this.chgHeading = chgHeading;
        this.chgSpeed   = chgSpeed;
        bot             = null;
    }


    /**
     * Create a motion object to describe motion of a bullet.
     */
    public Motion(
            double x,
            double y,
            double heading,
            double firePower) {

        this(x, y, heading, BotMath.calcBulletSpeed(firePower), 0, 0);
    }


    /**
     * Create a motion object that describes the motion of an enemy Bot.
     */
    public Motion(Bot b) {
        this(b.getX(),
             b.getY(),
             b.getHeading(),
             b.getSpeed(),
             b.getChgHeading(),
             b.getChgSpeed());
        bot = b;
    }

    /** Return the change in heading over time. */
    public double getChgHeading() {
        return chgHeading;
    }
    /** Return the change of speed over time. */
    public double getChgSpeed() {
        return chgSpeed;
    }
    /** Return the heading. */
    public double getHeading() {
        return heading;
    }
    /** Return the speed. */
    public double getSpeed() {
        return speed;
    }
    /** Return the x coordinate. */
    public double getX() {
        return x;
    }
    /** Return the y coordinate. */
    public double getY() {
        return y;
    }
    /** Return the enemy robot object, if set. */
    public Bot getBot() {
        return bot;
    }
    /** Set the enemy robot object. */
    public void setBot(Bot bot) {
        this.bot = bot;
    }
    /** Set the change in heading over time. */
    public void setChgHeading(double chgHeading) {
        this.chgHeading = chgHeading;
    }
    /** Set the change in speed over time. */
    public void setChgSpeed(double chgSpeed) {
        this.chgSpeed = chgSpeed;
    }
    /** Set the heading. */
    public void setHeading(double heading) {
        this.heading = heading;
    }
    /** Set the speed. */
    public void setSpeed(double speed) {
        this.speed = speed;
    }
    /** Set the x coordinate. */
    public void setX(double x) {
        this.x = x;
    }
    /** Set the y coordinate. */
    public void setY(double y) {
        this.y = y;
    }
}
