package ags.lunartwins;

import robocode.*;
import ags.lunartwins.util.*;

/**
 * The sidekick of the LunarTwins
 * 
 * @author Alexander Schultz
 */
public class LunarRover extends LunarBase implements Droid {
    private static OrbitPointMessage lastmessage;
    
    public LunarRover() {
        lastmessage = null;
    }

    public void onMessageReceived(MessageEvent e) {
        try {
            lastmessage = (OrbitPointMessage)e.getMessage();
        } catch (Exception ex) {}
    }
    
    public AbsolutePoint getGoal() {
        try {
            // Tell the leader where we are
            broadcastMessage(location);
            
            return lastmessage.goal;
        } catch (Exception ex) {
            return null;
        } 
    }
    public AbsolutePoint getTarget() {
        if (lastmessage == null)
            return null;
        // Fire at the location predicted by CircularTargeting
        return lastmessage.robot.predict(location, getFirePower());
    }
    
    public double currentDist() {
        return location.distance(lastmessage.robot.location);
    }
    
    public void doRadar() {}
}
