package ers.nano.gokdeniz;

/**
 * Author: ER Samson
 * 
 * First few iterations was built with ISuckNano 0.1d, Meroka and learning from 
 * Zenith (unreleased PM bot)
 *
 * The design has evolved to
 * 		• Pattern Matching gun
 * 		• Randomized Oscillator Movement
 * 		• Staying perpendicular to the enemy
 * 
 * Movement:
 * 		• Mark Whiteley      - http://mark.random-article.com/robocode/improved_movement.html
 * 		• Wiki               - https://robowiki.net/wiki/User:Exauge/snippets
 * 		• Wiki               - https://robowiki.net/wiki/Oscillator_Movement
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 * 		• John Cleland       - https://robowiki.net/wiki/NeophytePRAL
 * 
 * Radar:
 * 		• Wiki               - https://robowiki.net/wiki/One_on_One_Radar
 * 
 * Gun Targeting:
 * 		• Wiki               - https://robowiki.net/wiki/Rolling_Averages
 *		• Exauge             - https://robowiki.net/wiki/User:Exauge/snippets
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 *      • Simonton           - https://robowiki.net/wiki/WeekendObsession
 * 		• John Cleland       - https://robowiki.net/wiki/NeophytePRAL
 * 
 * Code Shrinking Tips:
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 *      • Simonton           - https://robowiki.net/wiki/WeekendObsession
 * 
 * Symbolic Pattern String (old PM gun):
 *      • Sheldor            - https://robowiki.net/wiki/Foilist
 */

import robocode.*;
import robocode.util.Utils;
//import java.awt.*;

public class Gokdeniz extends AdvancedRobot {
	
	/* ---------- Movement Variables ---------- */
	private static final int	 	DISTANCE_FACTOR		= 3000;
	private static final int	 	TARGET_DISTANCE		= 160;
	private static final double		DODGE_FACTOR		= 0.17; // ~0.17 best vs PM guns
	private static int				deathCount		 	= 2;
	private static double	 		moveDirection;

	/* ---------- Gun Variables ---------- */
	private static final int		BULLET_POWER		= 2;
	private static final int		BULLET_VELOCITY		= (int)(20 - 3 * BULLET_POWER);
	private static final int		ANTIRAM_FACTOR		= 108;
	private static final int		PATTERN_DEPTH		= 30;

	public void run() {
		// Color Identification
		//setColors(Color.blue, Color.red, Color.orange);

		// Easy targeting and infinite radar movement
		setAdjustGunForRobotTurn(true); // Saving code size!
		setTurnRadarRightRadians(moveDirection = Double.POSITIVE_INFINITY);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
	
		// Arranged like so to save codesize!
		int patternDepth = PATTERN_DEPTH;
		double targetBearing;
		double enemyDistance;
		int patternIndex;
		int tickIndex;

		/* ---------- Movement Logic ----------	*/
		// Turn perpendicular to enemy, no wall avoidance D:
		// CREDIT: Sheldor/Simonton's Yatagan
		setTurnRightRadians(Math.cos((targetBearing = e.getBearingRadians()) + 
				((TARGET_DISTANCE - (enemyDistance = e.getDistance())) * 
				(getVelocity() / DISTANCE_FACTOR))));

		// Randomized Movement Logic		
		setAhead(moveDirection *= (Math.random() - DODGE_FACTOR) + deathCount);

		/* ---------- Gun Logic ---------- */
		// PM Gun from Exauge in RoboWiki with Dynamic distance
		enemyHistory = String.valueOf((char)Math.round(e.getVelocity() * 
			Math.sin(e.getHeadingRadians() - (targetBearing += getHeadingRadians())))).concat(enemyHistory);
				
		while((patternIndex = enemyHistory.indexOf(enemyHistory.substring(0, patternDepth--), 
               tickIndex = (int)(enemyDistance / BULLET_VELOCITY))) < 0);

		do {
			targetBearing += Math.asin((byte)enemyHistory.charAt(patternIndex--) / enemyDistance); 
		} while (tickIndex-- > 0);		

		setTurnGunRightRadians(Utils.normalRelativeAngle(targetBearing - getGunHeadingRadians()));

		// Shoot to kill with Anti-Ram
		setFire(BULLET_POWER + (int)(ANTIRAM_FACTOR / enemyDistance));
			
		/* ---------- Radar Logic ---------- */
		// From RoboWiki
		setTurnRadarLeft(getRadarTurnRemaining());		
	}

	/**
	 * Reverse direction when I hit wall
	 */
	public void onHitWall(HitWallEvent e) {
		moveDirection = -moveDirection;
	}
	
	/**
	 * Change strat when I lose twice
	 */
	public void onDeath(DeathEvent e) {
		deathCount = deathCount >> 1;
	}

	/**
	 * Symbolic log of enemy movements for pattern matcher.
	 * Preloaded to prevent StringIndexOutOfBoundsException.
	 */
	private static String enemyHistory = ""
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8;
}