/*
 * Created on 16/08/2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.okami;

import java.awt.geom.*;

import axeBots.AxeBot;
import axeBots.util.*;
/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class BulletUnit {
	private String shooter = null;
	private Point2D.Double firedPoint = null;
	private double firedTime = 0;
	private double power = 0;
	private double energy = 0;
	private double velocity = 0;
	private double expires = 0;
	
	public BulletUnit(){
		super();
	}
	
	public BulletUnit(String shooter, 
						Point2D.Double firedPoint, 
						double firedTime, 
						double energy) throws NumberFormatException{
			this();
			if((energy > 3) || (energy < 0.1))
			{
				throw new NumberFormatException("power invalid:"+energy);
			}
			this.energy=energy;
			this.shooter = shooter;
			this.firedTime = firedTime;
			
			this.velocity = RoboMath.getBulletVelocity(energy);
			this.power = RoboMath.getBulletDamage(energy);
			this.firedPoint = firedPoint;
			
			this.expires = AxeBot.getIt().getTime() + this.getMaxDistToWall()/this.velocity;
			//HataMoto.getIt().out.println(" new BulletUnit:"+this);
		}
	

	/**
	 * @return
	 */
	public Point2D.Double getFiredPoint() {
		return firedPoint;
	}

	/**
	 * @return
	 */
	public double getFiredTime() {
		return firedTime;
	}

	/**
	 * @return
	 */
	public double getPower() {
		return power;
	}

	/**
	 * @return
	 */
	public String getShooter() {
		return shooter;
	}

	/**
	 * @return
	 */
	public double getVelocity() {
		return velocity;
	}

	/**
	 * @param double1
	 */
	public void setFiredPoint(Point2D.Double double1) {
		firedPoint = double1;
	}

	/**
	 * @param d
	 */
	public void setFiredTime(double d) {
		firedTime = d;
	}

	/**
	 * @param d
	 */
	public void setPower(double d) {
		power = d;
	}

	/**
	 * @param string
	 */
	public void setShooter(String string) {
		shooter = string;
	}

	/**
	 * @param d
	 */
	public void setVelocity(double d) {
		velocity = d;
	}
	
	public boolean canBe( 
		double dmg){
		//double disTolerance = velocity;
		double pwrTolerance = 0.1;
		/*double dist = RoboMath.getrange(this.firedPoint.x, this.firedPoint.y, 
										me.x, me.y );*/
		//double bulletDelta = this.velocity * (HataMoto.getIt().getTime() - this.firedTime  );
		
		//HataMoto.getIt().out.println("BU.canBe: dist:"+dist+" delta:"+bulletDelta+" pow:"+power+" dmg:"+dmg);
		
		if(/*((dist + disTolerance) >= bulletDelta) 
			&& ((dist - disTolerance) <= bulletDelta)
			&& */((this.power + pwrTolerance) >= dmg) 
			&& ((this.power - pwrTolerance) <= dmg)){
				
			return true;
		}
		else
			return false;
			
	}
	
	public boolean isExpired(){
		if(AxeBot.getIt().getTime() > expires) return true;
		else return false;
	}
	
	private double getMaxDistToWall()
	{
		double minx = 0;
		double miny = 0;
		
		double maxx = AxeBot.getIt().getBattleFieldWidth();
		double maxy = AxeBot.getIt().getBattleFieldHeight();
		
		double dNW = RoboMath.getrange(minx,maxy,
						this.getFiredPoint().getX(),this.getFiredPoint().getY());
						
		double dNE = RoboMath.getrange(maxx,maxy,
								this.getFiredPoint().getX(),this.getFiredPoint().getY());
								
		double dSW = RoboMath.getrange(minx,miny,
								this.getFiredPoint().getX(),this.getFiredPoint().getY());
								
		double dSE = RoboMath.getrange(maxx,miny,
								this.getFiredPoint().getX(),this.getFiredPoint().getY());		
		
		double[] ds = {dNW,dNE,dSW,dSE};
		
		double d = RoboMath.getMax(ds);
		
		return d;
	}
	
	
	public String toString()
	{
		String ret = this.getShooter()//+" at:" +this.getFiredPoint() 
			+" time:" +this.getFiredTime()
			//+" vel:"+this.getVelocity()
			+" pwr:"+this.getPower()
		+" energy:"+this.energy
		+" expires:"+this.expires;
			
			return ret;
	}
	

}
